/*
 * Decompiled with CFR 0.152.
 */
package net.algart.model3d.spherepolyhedra.objects;

import java.util.Arrays;
import java.util.Objects;
import net.algart.arrays.JArrays;
import net.algart.arrays.TooLargeArrayException;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedra;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedraIntersectionsList;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedrion;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedron;

public final class IntersectingNeighboursFinder {
    private final SpherePolyhedra spherePolyhedra;
    private int[] neighbours = JArrays.EMPTY_INTS;
    private int numberOfNeighbours = 0;
    private boolean essentialIntersectionsOnly = false;
    private final SpherePolyhedrion workSum = new SpherePolyhedrion();
    private final SpherePolyhedrion workAddedSpherePolyhedrion = new SpherePolyhedrion();
    private final SpherePolyhedron workSpherePolyhedron = new SpherePolyhedron();

    public IntersectingNeighboursFinder(SpherePolyhedra spherePolyhedra, boolean essentialIntersectionsOnly) {
        this.spherePolyhedra = Objects.requireNonNull(spherePolyhedra, "Null sphere-polyhedra array");
        this.essentialIntersectionsOnly = essentialIntersectionsOnly;
    }

    public boolean isEssentialIntersectionsOnly() {
        return this.essentialIntersectionsOnly;
    }

    public IntersectingNeighboursFinder setEssentialIntersectionsOnly(boolean essentialIntersectionsOnly) {
        this.essentialIntersectionsOnly = essentialIntersectionsOnly;
        return this;
    }

    public int numberOfNeighbours() {
        return this.numberOfNeighbours;
    }

    public int neighbour(int k) {
        if (k < 0 || k >= this.numberOfNeighbours) {
            throw new IndexOutOfBoundsException("Index of neighbour " + k + " is out of range 0.." + (this.numberOfNeighbours - 1));
        }
        return this.neighbours[k];
    }

    public void findNeighboursOfDilatedSpherePolyhedron(int packedSpherePolyhedronIndex, SpherePolyhedrion added) {
        this.workAddedSpherePolyhedrion.setTo(added);
        this.workAddedSpherePolyhedrion.minkowskiAddSymmetric();
        this.spherePolyhedra.getSpherePolyhedron(this.workSpherePolyhedron, packedSpherePolyhedronIndex);
        this.workSpherePolyhedron.setToSymmetry();
        this.workAddedSpherePolyhedrion.minkowskiAdd(this.workSpherePolyhedron);
        this.findSpherePolyhedronOrObjectCenters(packedSpherePolyhedronIndex, false);
    }

    public void findNeighboursOfObject(int packedObjectIndex) {
        this.spherePolyhedra.getObject(this.workAddedSpherePolyhedrion, packedObjectIndex);
        this.workAddedSpherePolyhedrion.setToSymmetry();
        this.findSpherePolyhedronOrObjectCenters(packedObjectIndex, true);
    }

    private void findSpherePolyhedronOrObjectCenters(int index, boolean findObjectIndexes) {
        double characteristicSize = this.workAddedSpherePolyhedrion.maxContainingSphereRadius();
        double delta = 1.0E-7 * characteristicSize;
        double minusAddedMinX = -(this.workAddedSpherePolyhedrion.minX() - delta);
        double minusAddedMaxX = -(this.workAddedSpherePolyhedrion.maxX() + delta);
        double minusAddedMinY = -(this.workAddedSpherePolyhedrion.minY() - delta);
        double minusAddedMaxY = -(this.workAddedSpherePolyhedrion.maxY() + delta);
        double minusAddedMinZ = -(this.workAddedSpherePolyhedrion.minZ() - delta);
        double minusAddedMaxZ = -(this.workAddedSpherePolyhedrion.maxZ() + delta);
        this.numberOfNeighbours = 0;
        int n = findObjectIndexes ? this.spherePolyhedra.numberOfObjects : this.spherePolyhedra.numberOfSpherePolyhedra;
        for (int k = 0; k < n; ++k) {
            if (index == k) continue;
            int from = findObjectIndexes ? this.spherePolyhedra.firstSpherePolyhedronIndexInObject(k) : k;
            int to = findObjectIndexes ? from + this.spherePolyhedra.numberOfElementsInObject(k) : k;
            boolean intersects = false;
            for (int i = from; i < to; ++i) {
                if (this.spherePolyhedra.minX(i) > minusAddedMinX || this.spherePolyhedra.maxX(i) < minusAddedMaxX || this.spherePolyhedra.minY(i) > minusAddedMinY || this.spherePolyhedra.maxY(i) < minusAddedMaxY || this.spherePolyhedra.minZ(i) > minusAddedMinZ || this.spherePolyhedra.maxZ(i) < minusAddedMaxZ) continue;
                this.workSum.setTo(this.workAddedSpherePolyhedrion);
                this.spherePolyhedra.getSpherePolyhedron(this.workSpherePolyhedron, i);
                this.workSum.minkowskiAdd(this.workSpherePolyhedron);
                if (!this.workSum.containsPoint(0.0, 0.0, 0.0, this.essentialIntersectionsOnly, characteristicSize)) continue;
                intersects = true;
                break;
            }
            if (!intersects) continue;
            this.ensureCapacity(this.numberOfNeighbours + 1);
            this.neighbours[this.numberOfNeighbours] = k;
            ++this.numberOfNeighbours;
        }
    }

    private void ensureCapacity(int newUnsignedNumberOfNeighbours) {
        if (SpherePolyhedraIntersectionsList.unsigned(newUnsignedNumberOfNeighbours) > (long)this.neighbours.length) {
            long newLength = Math.max(16L, Math.max(SpherePolyhedraIntersectionsList.unsigned(newUnsignedNumberOfNeighbours), Math.min(Integer.MAX_VALUE, 2L * (long)this.neighbours.length)));
            if (newLength > Integer.MAX_VALUE) {
                throw new TooLargeArrayException("Too large array required for building neighbours list: cannot allocate " + newLength + " >= 2147483647 elements");
            }
            this.neighbours = Arrays.copyOf(this.neighbours, (int)newLength);
        }
    }
}

