/*
 * Decompiled with CFR 0.152.
 */
package net.algart.model3d.spherepolyhedra.objects;

import net.algart.model3d.spherepolyhedra.objects.Generatrix;
import net.algart.model3d.spherepolyhedra.objects.GeneratrixSet;
import net.algart.model3d.spherepolyhedra.objects.TooLargeSpherePolyhedronException;

public final class GeneratrixSphere
extends Generatrix {
    final double radius;

    private GeneratrixSphere(double radius) {
        GeneratrixSphere.checkRadius(radius, false);
        this.radius = radius;
    }

    public static GeneratrixSphere newSphere(double r) throws TooLargeSpherePolyhedronException {
        return new GeneratrixSphere(r);
    }

    public double r() {
        return this.radius;
    }

    public String toString() {
        return "generatrix sphere r=" + this.radius;
    }

    @Override
    void add(GeneratrixSet.Builder builder) {
        builder.addSphere(this.radius, false);
    }

    public static void checkRadius(double radius) {
        GeneratrixSphere.checkRadius(radius, false);
    }

    static void checkRadius(double radius, boolean weakenedCheck) {
        if (Double.isNaN(radius)) {
            throw new IllegalArgumentException("NaN sphere radius " + radius);
        }
        if (radius < 0.0) {
            throw new IllegalArgumentException("Negative sphere radius " + radius);
        }
        double d = weakenedCheck ? 1.0E40 : 1.0E20;
        if (radius > d) {
            throw new TooLargeSpherePolyhedronException("Too large sphere radius " + radius + " > 1.0E20 (allowed maximum" + (weakenedCheck ? " for internal needs)" : ")"));
        }
    }
}

