/*
 * Decompiled with CFR 0.152.
 */
package net.algart.model3d.spherepolyhedra.kinds;

import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import net.algart.math.Range;

public enum RandomSizeDistribution {
    UNIFORM{

        @Override
        double nextImplementation(Random random, double average, double delta) {
            double result = average - delta + random.nextDouble() * 2.0 * delta;
            if (result < average - delta) {
                return average - delta;
            }
            if (result > average + delta) {
                return average + delta;
            }
            return result;
        }
    }
    ,
    NORMAL{

        @Override
        double nextImplementation(Random random, double average, double delta) {
            return average + random.nextGaussian() * delta;
        }
    }
    ,
    LOG_NORMAL{

        @Override
        double nextImplementation(Random random, double average, double delta) {
            return average * Math.exp(random.nextGaussian() * delta / average);
        }
    };

    private static final Range ALLOWED_RANGE;

    abstract double nextImplementation(Random var1, double var2, double var4);

    public static Optional<RandomSizeDistribution> fromName(String name) {
        for (RandomSizeDistribution value : RandomSizeDistribution.values()) {
            if (!value.name().equalsIgnoreCase(name)) continue;
            return Optional.of(value);
        }
        return Optional.empty();
    }

    public double next(Random random, double average, double delta) {
        Objects.requireNonNull(random, "Null random generator");
        if (delta < 0.0) {
            throw new IllegalArgumentException("Negative delta = " + delta);
        }
        return ALLOWED_RANGE.cut(delta == 0.0 ? average : this.nextImplementation(random, average, delta));
    }

    public double nextPositive(Random random, double average, double delta) {
        double result;
        if (average <= 0.0) {
            throw new IllegalArgumentException("Zero or negative average = " + average);
        }
        while ((result = this.next(random, average, delta)) <= 0.0) {
        }
        return result;
    }

    public double nextNonNegative(Random random, double average, double delta) {
        double result;
        if (average < 0.0) {
            throw new IllegalArgumentException("Negative average = " + average);
        }
        while ((result = this.next(random, average, delta)) < 0.0) {
        }
        return result;
    }

    static {
        ALLOWED_RANGE = Range.of((double)-1.0E18, (double)1.0E18);
    }
}

