/*
 * Decompiled with CFR 0.152.
 */
package net.algart.model3d.spherepolyhedra.kinds;

import java.util.Objects;
import java.util.Optional;
import java.util.Random;

public enum RandomAngleDistribution {
    UNIFORM{

        @Override
        public double next(Random random, double delta) {
            Objects.requireNonNull(random, "Null random generator");
            double result = -delta + random.nextDouble() * 2.0 * delta;
            if (result < -delta) {
                return -delta;
            }
            if (result > delta) {
                return delta;
            }
            return result;
        }
    }
    ,
    NORMAL{

        @Override
        public double next(Random random, double delta) {
            Objects.requireNonNull(random, "Null random generator");
            return random.nextGaussian() * delta;
        }
    };


    public abstract double next(Random var1, double var2);

    public static Optional<RandomAngleDistribution> fromName(String name) {
        for (RandomAngleDistribution value : RandomAngleDistribution.values()) {
            if (!value.name().equalsIgnoreCase(name)) continue;
            return Optional.of(value);
        }
        return Optional.empty();
    }
}

