/*
 * Decompiled with CFR 0.152.
 */
package net.algart.model3d.spherepolyhedra.kinds;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import java.util.Objects;
import java.util.Random;
import java.util.random.RandomGenerator;
import java.util.stream.Stream;
import net.algart.json.Jsons;
import net.algart.math.geometry.Orthonormal3DBasis;
import net.algart.math.geometry.StraightLine3D;
import net.algart.model3d.spherepolyhedra.kinds.RandomAngleDistribution;
import net.algart.model3d.spherepolyhedra.kinds.SpherePolyhedronKind;

public final class PreferredDirection {
    private double x = 0.0;
    private double y = 0.0;
    private double z = 1.0;
    private double normalX = 0.0;
    private double normalY = 0.0;
    private double normalZ = 1.0;
    private double angleDeviationInRadians = 0.0;
    private double angleDeviationInDegrees = 0.0;
    private RandomAngleDistribution distribution = RandomAngleDistribution.NORMAL;

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public PreferredDirection setDirection(double x, double y, double z) {
        double length = Math.sqrt(x * x + y * y + z * z);
        if (length < 1.0E-20) {
            throw new IllegalArgumentException("Zero or too short direction vector (" + x + ", " + y + ", " + z + ")");
        }
        this.x = x;
        this.y = y;
        this.z = z;
        this.normalX = x / length;
        this.normalY = y / length;
        this.normalZ = z / length;
        return this;
    }

    public PreferredDirection setDirectionAlongStraight(StraightLine3D straight) {
        return this.setDirection(straight.dx(), straight.dy(), straight.dz());
    }

    public double getNormalX() {
        return this.normalX;
    }

    public double getNormalY() {
        return this.normalY;
    }

    public double getNormalZ() {
        return this.normalZ;
    }

    public double getAngleDeviationInDegrees() {
        return this.angleDeviationInDegrees;
    }

    public PreferredDirection setAngleDeviationInDegrees(double angleDeviationInDegrees) {
        this.angleDeviationInDegrees = SpherePolyhedronKind.nonNegative(angleDeviationInDegrees, "angleDeviationInDegrees");
        this.angleDeviationInRadians = StrictMath.toRadians(angleDeviationInDegrees);
        return this;
    }

    public RandomAngleDistribution getDistribution() {
        return this.distribution;
    }

    public PreferredDirection setDistribution(RandomAngleDistribution distribution) {
        this.distribution = Objects.requireNonNull(distribution, "Null distribution");
        return this;
    }

    public final JsonObject toJson() {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("x", this.x);
        builder.add("y", this.y);
        builder.add("z", this.z);
        builder.add("angle_deviation", this.angleDeviationInDegrees);
        builder.add("distribution", this.distribution.name());
        return builder.build();
    }

    public PreferredDirection setToJson(JsonObject json) {
        Objects.requireNonNull(json, "Null json");
        this.setDirection(Jsons.reqDouble((JsonObject)json, (String)"x"), Jsons.reqDouble((JsonObject)json, (String)"y"), Jsons.reqDouble((JsonObject)json, (String)"z"));
        this.setAngleDeviationInDegrees(Jsons.reqDouble((JsonObject)json, (String)"angle_deviation"));
        String s = json.getString("distribution", RandomAngleDistribution.NORMAL.name());
        this.setDistribution(RandomAngleDistribution.fromName(s).orElseThrow(() -> Jsons.badValue((JsonObject)json, (String)"distribution", (String)s, Stream.of(RandomAngleDistribution.values()))));
        return this;
    }

    public Orthonormal3DBasis newRandomBasisAlongDirection(Random random) {
        Objects.requireNonNull(random, "Null random generator");
        Orthonormal3DBasis basis = Orthonormal3DBasis.newRandomBasis((RandomGenerator)random, (double)this.x, (double)this.y, (double)this.z);
        basis = basis.rotateKI(this.distribution.next(random, this.angleDeviationInRadians));
        return basis;
    }
}

