/*
 * Decompiled with CFR 0.152.
 */
package net.algart.model3d.spherepolyhedra.kinds;

import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import java.util.Random;
import net.algart.json.Jsons;
import net.algart.math.geometry.Orthonormal3DBasis;
import net.algart.model3d.spherepolyhedra.kinds.KindWithDirections;
import net.algart.model3d.spherepolyhedra.kinds.KindWithSizeA;
import net.algart.model3d.spherepolyhedra.objects.GeneratrixSegment;

public abstract class KindWithDirectionsAndSize
extends KindWithDirections
implements KindWithSizeA {
    double a = 1.0;
    double da = 0.0;

    @Override
    public double getA() {
        return this.a;
    }

    @Override
    public KindWithDirectionsAndSize setA(double a) {
        this.a = KindWithDirectionsAndSize.nonNegative(a, "a");
        return this;
    }

    @Override
    public double getDa() {
        return this.da;
    }

    @Override
    public KindWithDirectionsAndSize setDa(double da) {
        this.da = KindWithDirectionsAndSize.nonNegative(da, "da");
        return this;
    }

    @Override
    protected void toJsonImplementation(JsonObjectBuilder builder) {
        super.toJsonImplementation(builder);
        builder.add("a", this.a);
        builder.add("da", this.da);
    }

    @Override
    protected void fromJsonImplementation(JsonObject json) {
        super.fromJsonImplementation(json);
        this.setA(Jsons.getDouble((JsonObject)json, (String)"a", (double)1.0));
        this.setDa(Jsons.getDouble((JsonObject)json, (String)"da", (double)0.0));
    }

    GeneratrixSegment[] make3Segments(Random random) {
        GeneratrixSegment segment3;
        GeneratrixSegment segment2;
        double side1 = this.nextPositive(random, this.a, this.da);
        double side2 = this.nextPositive(random, this.a, this.da);
        double side3 = this.nextPositive(random, this.a, this.da);
        Orthonormal3DBasis basis1 = this.directions.newRandomBasisAlongDirection(0, random);
        GeneratrixSegment segment1 = GeneratrixSegment.newSegmentAlongI(basis1, side1);
        Orthonormal3DBasis basis2 = null;
        if (this.directions.numberOfDirections() >= 2) {
            basis2 = this.directions.newRandomBasisAlongDirection(1, random);
            v0 = GeneratrixSegment.newSegmentAlongI(basis2, side2);
        } else {
            v0 = segment2 = GeneratrixSegment.newSegmentAlongJ(basis1, side2);
        }
        if (this.directions.numberOfDirections() >= 3) {
            Orthonormal3DBasis basis3 = this.directions.newRandomBasisAlongDirection(2, random);
            segment3 = GeneratrixSegment.newSegmentAlongI(basis3, side3);
        } else if (basis2 != null) {
            Orthonormal3DBasis basis3 = Orthonormal3DBasis.newBasis((double)basis1.ix(), (double)basis1.iy(), (double)basis1.iz(), (double)basis2.ix(), (double)basis2.iy(), (double)basis2.iz(), (boolean)false);
            segment3 = GeneratrixSegment.newSegmentAlongK(basis3, side3);
        } else {
            segment3 = GeneratrixSegment.newSegmentAlongK(basis1, side3);
        }
        return new GeneratrixSegment[]{segment1, segment2, segment3};
    }
}

