/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.model3d.spherepolyhedra.kinds;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Set;
import net.algart.executors.api.data.SScalar;
import net.algart.executors.modules.core.common.scalars.ScalarFilter;
import net.algart.json.Jsons;
import net.algart.model3d.spherepolyhedra.kinds.KindWithDirections;
import net.algart.model3d.spherepolyhedra.kinds.KindWithRadius;
import net.algart.model3d.spherepolyhedra.kinds.KindWithRandomDistribution;
import net.algart.model3d.spherepolyhedra.kinds.KindWithSizeA;
import net.algart.model3d.spherepolyhedra.kinds.KindWithSizeB;
import net.algart.model3d.spherepolyhedra.kinds.PreferredDirection;
import net.algart.model3d.spherepolyhedra.kinds.PreferredDirections;
import net.algart.model3d.spherepolyhedra.kinds.RandomAngleDistribution;
import net.algart.model3d.spherepolyhedra.kinds.RandomSizeDistribution;
import net.algart.model3d.spherepolyhedra.kinds.SphereCrossKind;
import net.algart.model3d.spherepolyhedra.kinds.SpherePolyhedronKind;
import net.algart.model3d.spherepolyhedra.kinds.SpherePolyhedronKindSet;
import net.algart.model3d.spherepolyhedra.kinds.restrictions.NeighbourIndexRequirement;
import net.algart.model3d.spherepolyhedra.kinds.restrictions.NeighbourKindSetProhibition;
import net.algart.model3d.spherepolyhedra.kinds.restrictions.NeighbourKindSetRequirement;
import net.algart.model3d.spherepolyhedra.kinds.restrictions.SpherePolyhedraNeighbourhoodPackingRestriction;
import net.algart.model3d.spherepolyhedra.kinds.restrictions.SpherePolyhedraNeighbourhoodPackingRestrictionSet;

public final class AddSpherePolyhedronKind
extends ScalarFilter {
    private SpherePolyhedronKindSet.Settings.Fraction.Mode fractionMode = SpherePolyhedronKindSet.Settings.Fraction.Mode.SUMMARY_VOLUME;
    private SpherePolyhedronKind.StandardClass kindClass = SpherePolyhedronKind.StandardClass.SPHERE;
    private String id = "S";
    private int label = 1;
    private Color color = Color.WHITE;
    private double fraction = 0.1;
    private RandomSizeDistribution distribution = RandomSizeDistribution.NORMAL;
    private double r = 1.0;
    private double dr = 0.0;
    private double a = 1.0;
    private double da = 0.0;
    private double b = 1.0;
    private double db = 0.0;
    private double rb = Double.NaN;
    private double drb = 0.0;
    private double h = 0.0;
    private double dh = 0.0;
    private SphereCrossKind.ShiftMode sphereCrossMode = SphereCrossKind.ShiftMode.RELATIVE;
    private boolean sphereCrossInRange = true;
    private int numberOfPreferredDirections = 0;
    private double preferredDirection1X = 0.0;
    private double preferredDirection1Y = 0.0;
    private double preferredDirection1Z = 1.0;
    private double preferredDirection1AngleDeviationInDegrees = 0.0;
    private RandomAngleDistribution preferredDirection1Distribution = RandomAngleDistribution.NORMAL;
    private double preferredDirection2X = 1.0;
    private double preferredDirection2Y = 0.0;
    private double preferredDirection2Z = 0.0;
    private double preferredDirection2AngleDeviationInDegrees = 0.0;
    private RandomAngleDistribution preferredDirection2Distribution = RandomAngleDistribution.NORMAL;
    private double preferredDirection3X = 0.0;
    private double preferredDirection3Y = 1.0;
    private double preferredDirection3Z = 0.0;
    private double preferredDirection3AngleDeviationInDegrees = 0.0;
    private RandomAngleDistribution preferredDirection3Distribution = RandomAngleDistribution.NORMAL;
    private String requiredNeighbourKinds = "";
    private String prohibitedNeighbourKinds = "";
    private Integer requiredNeighbourIndex = null;

    public AddSpherePolyhedronKind() {
        this.setDefaultInputScalar("kind_set");
        this.setDefaultOutputScalar("kind_set");
    }

    public SpherePolyhedronKindSet.Settings.Fraction.Mode getFractionMode() {
        return this.fractionMode;
    }

    public AddSpherePolyhedronKind setFractionMode(SpherePolyhedronKindSet.Settings.Fraction.Mode fractionMode) {
        this.fractionMode = (SpherePolyhedronKindSet.Settings.Fraction.Mode)((Object)AddSpherePolyhedronKind.nonNull((Object)((Object)fractionMode)));
        return this;
    }

    public SpherePolyhedronKind.StandardClass getKindClass() {
        return this.kindClass;
    }

    public AddSpherePolyhedronKind setKindClass(SpherePolyhedronKind.StandardClass kindClass) {
        this.kindClass = (SpherePolyhedronKind.StandardClass)((Object)AddSpherePolyhedronKind.nonNull((Object)((Object)kindClass)));
        return this;
    }

    public String getId() {
        return this.id;
    }

    public AddSpherePolyhedronKind setId(String id) {
        this.id = ((String)AddSpherePolyhedronKind.nonNull((Object)id)).trim();
        return this;
    }

    public int getLabel() {
        return this.label;
    }

    public AddSpherePolyhedronKind setLabel(int label) {
        this.label = label;
        return this;
    }

    public Color getColor() {
        return this.color;
    }

    public AddSpherePolyhedronKind setColor(Color color) {
        this.color = (Color)AddSpherePolyhedronKind.nonNull((Object)color);
        return this;
    }

    public double getFraction() {
        return this.fraction;
    }

    public AddSpherePolyhedronKind setFraction(double fraction) {
        this.fraction = AddSpherePolyhedronKind.nonNegative((double)fraction);
        return this;
    }

    public RandomSizeDistribution getDistribution() {
        return this.distribution;
    }

    public AddSpherePolyhedronKind setDistribution(RandomSizeDistribution distribution) {
        this.distribution = (RandomSizeDistribution)((Object)AddSpherePolyhedronKind.nonNull((Object)((Object)distribution)));
        return this;
    }

    public double getR() {
        return this.r;
    }

    public AddSpherePolyhedronKind setR(double r) {
        this.r = AddSpherePolyhedronKind.nonNegative((double)r);
        return this;
    }

    public double getDr() {
        return this.dr;
    }

    public AddSpherePolyhedronKind setDr(double dr) {
        this.dr = AddSpherePolyhedronKind.nonNegative((double)dr);
        return this;
    }

    public double getA() {
        return this.a;
    }

    public AddSpherePolyhedronKind setA(double a) {
        this.a = AddSpherePolyhedronKind.nonNegative((double)a);
        return this;
    }

    public double getDa() {
        return this.da;
    }

    public AddSpherePolyhedronKind setDa(double da) {
        this.da = AddSpherePolyhedronKind.nonNegative((double)da);
        return this;
    }

    public double getB() {
        return this.b;
    }

    public AddSpherePolyhedronKind setB(double b) {
        this.b = AddSpherePolyhedronKind.nonNegative((double)b);
        return this;
    }

    public double getDb() {
        return this.db;
    }

    public AddSpherePolyhedronKind setDb(double db) {
        this.db = AddSpherePolyhedronKind.nonNegative((double)db);
        return this;
    }

    public double getRb() {
        return this.rb;
    }

    public AddSpherePolyhedronKind setRb(double rb) {
        this.rb = AddSpherePolyhedronKind.nonNegative((double)rb);
        return this;
    }

    public AddSpherePolyhedronKind setRb(String rb) {
        return this.setRb(AddSpherePolyhedronKind.doubleOrDefault((String)rb, (double)Double.NaN));
    }

    public double getDrb() {
        return this.drb;
    }

    public AddSpherePolyhedronKind setDrb(double drb) {
        this.drb = AddSpherePolyhedronKind.nonNegative((double)drb);
        return this;
    }

    public double getH() {
        return this.h;
    }

    public AddSpherePolyhedronKind setH(double h) {
        this.h = AddSpherePolyhedronKind.nonNegative((double)h);
        return this;
    }

    public double getDh() {
        return this.dh;
    }

    public AddSpherePolyhedronKind setDh(double dh) {
        this.dh = AddSpherePolyhedronKind.nonNegative((double)dh);
        return this;
    }

    public SphereCrossKind.ShiftMode getSphereCrossMode() {
        return this.sphereCrossMode;
    }

    public AddSpherePolyhedronKind setSphereCrossMode(SphereCrossKind.ShiftMode sphereCrossMode) {
        this.sphereCrossMode = (SphereCrossKind.ShiftMode)((Object)AddSpherePolyhedronKind.nonNull((Object)((Object)sphereCrossMode)));
        return this;
    }

    public boolean isSphereCrossInRange() {
        return this.sphereCrossInRange;
    }

    public AddSpherePolyhedronKind setSphereCrossInRange(boolean sphereCrossInRange) {
        this.sphereCrossInRange = sphereCrossInRange;
        return this;
    }

    public int getNumberOfPreferredDirections() {
        return this.numberOfPreferredDirections;
    }

    public AddSpherePolyhedronKind setNumberOfPreferredDirections(int numberOfPreferredDirections) {
        this.numberOfPreferredDirections = AddSpherePolyhedronKind.nonNegative((int)numberOfPreferredDirections);
        return this;
    }

    public double getPreferredDirection1X() {
        return this.preferredDirection1X;
    }

    public AddSpherePolyhedronKind setPreferredDirection1X(double preferredDirection1X) {
        this.preferredDirection1X = preferredDirection1X;
        return this;
    }

    public double getPreferredDirection1Y() {
        return this.preferredDirection1Y;
    }

    public AddSpherePolyhedronKind setPreferredDirection1Y(double preferredDirection1Y) {
        this.preferredDirection1Y = preferredDirection1Y;
        return this;
    }

    public double getPreferredDirection1Z() {
        return this.preferredDirection1Z;
    }

    public AddSpherePolyhedronKind setPreferredDirection1Z(double preferredDirection1Z) {
        this.preferredDirection1Z = preferredDirection1Z;
        return this;
    }

    public double getPreferredDirection1AngleDeviationInDegrees() {
        return this.preferredDirection1AngleDeviationInDegrees;
    }

    public AddSpherePolyhedronKind setPreferredDirection1AngleDeviationInDegrees(double preferredDirection1AngleDeviationInDegrees) {
        this.preferredDirection1AngleDeviationInDegrees = AddSpherePolyhedronKind.nonNegative((double)preferredDirection1AngleDeviationInDegrees);
        return this;
    }

    public RandomAngleDistribution getPreferredDirection1Distribution() {
        return this.preferredDirection1Distribution;
    }

    public AddSpherePolyhedronKind setPreferredDirection1Distribution(RandomAngleDistribution preferredDirection1Distribution) {
        this.preferredDirection1Distribution = (RandomAngleDistribution)((Object)AddSpherePolyhedronKind.nonNull((Object)((Object)preferredDirection1Distribution)));
        return this;
    }

    public double getPreferredDirection2X() {
        return this.preferredDirection2X;
    }

    public AddSpherePolyhedronKind setPreferredDirection2X(double preferredDirection2X) {
        this.preferredDirection2X = preferredDirection2X;
        return this;
    }

    public double getPreferredDirection2Y() {
        return this.preferredDirection2Y;
    }

    public AddSpherePolyhedronKind setPreferredDirection2Y(double preferredDirection2Y) {
        this.preferredDirection2Y = preferredDirection2Y;
        return this;
    }

    public double getPreferredDirection2Z() {
        return this.preferredDirection2Z;
    }

    public AddSpherePolyhedronKind setPreferredDirection2Z(double preferredDirection2Z) {
        this.preferredDirection2Z = preferredDirection2Z;
        return this;
    }

    public double getPreferredDirection2AngleDeviationInDegrees() {
        return this.preferredDirection2AngleDeviationInDegrees;
    }

    public AddSpherePolyhedronKind setPreferredDirection2AngleDeviationInDegrees(double preferredDirection2AngleDeviationInDegrees) {
        this.preferredDirection2AngleDeviationInDegrees = AddSpherePolyhedronKind.nonNegative((double)preferredDirection2AngleDeviationInDegrees);
        return this;
    }

    public RandomAngleDistribution getPreferredDirection2Distribution() {
        return this.preferredDirection2Distribution;
    }

    public AddSpherePolyhedronKind setPreferredDirection2Distribution(RandomAngleDistribution preferredDirection2Distribution) {
        this.preferredDirection2Distribution = (RandomAngleDistribution)((Object)AddSpherePolyhedronKind.nonNull((Object)((Object)preferredDirection2Distribution)));
        return this;
    }

    public double getPreferredDirection3X() {
        return this.preferredDirection3X;
    }

    public AddSpherePolyhedronKind setPreferredDirection3X(double preferredDirection3X) {
        this.preferredDirection3X = preferredDirection3X;
        return this;
    }

    public double getPreferredDirection3Y() {
        return this.preferredDirection3Y;
    }

    public AddSpherePolyhedronKind setPreferredDirection3Y(double preferredDirection3Y) {
        this.preferredDirection3Y = preferredDirection3Y;
        return this;
    }

    public double getPreferredDirection3Z() {
        return this.preferredDirection3Z;
    }

    public AddSpherePolyhedronKind setPreferredDirection3Z(double preferredDirection3Z) {
        this.preferredDirection3Z = preferredDirection3Z;
        return this;
    }

    public double getPreferredDirection3AngleDeviationInDegrees() {
        return this.preferredDirection3AngleDeviationInDegrees;
    }

    public AddSpherePolyhedronKind setPreferredDirection3AngleDeviationInDegrees(double preferredDirection3AngleDeviationInDegrees) {
        this.preferredDirection3AngleDeviationInDegrees = AddSpherePolyhedronKind.nonNegative((double)preferredDirection3AngleDeviationInDegrees);
        return this;
    }

    public RandomAngleDistribution getPreferredDirection3Distribution() {
        return this.preferredDirection3Distribution;
    }

    public AddSpherePolyhedronKind setPreferredDirection3Distribution(RandomAngleDistribution preferredDirection3Distribution) {
        this.preferredDirection3Distribution = (RandomAngleDistribution)((Object)AddSpherePolyhedronKind.nonNull((Object)((Object)preferredDirection3Distribution)));
        return this;
    }

    public String getRequiredNeighbourKinds() {
        return this.requiredNeighbourKinds;
    }

    public AddSpherePolyhedronKind setRequiredNeighbourKinds(String requiredNeighbourKinds) {
        this.requiredNeighbourKinds = ((String)AddSpherePolyhedronKind.nonNull((Object)requiredNeighbourKinds)).trim();
        return this;
    }

    public String getProhibitedNeighbourKinds() {
        return this.prohibitedNeighbourKinds;
    }

    public AddSpherePolyhedronKind setProhibitedNeighbourKinds(String prohibitedNeighbourKinds) {
        this.prohibitedNeighbourKinds = ((String)AddSpherePolyhedronKind.nonNull((Object)prohibitedNeighbourKinds)).trim();
        return this;
    }

    public Integer getRequiredNeighbourIndex() {
        return this.requiredNeighbourIndex;
    }

    public AddSpherePolyhedronKind setRequiredNeighbourIndex(Integer requiredNeighbourIndex) {
        this.requiredNeighbourIndex = requiredNeighbourIndex;
        return this;
    }

    public AddSpherePolyhedronKind setRequiredNeighbourIndex(String requiredNeighbourIndex) {
        return this.setRequiredNeighbourIndex(AddSpherePolyhedronKind.intOrNull((String)requiredNeighbourIndex));
    }

    public SScalar process(SScalar source) {
        SpherePolyhedronKindSet kindSet;
        if (source.isInitialized()) {
            kindSet = SpherePolyhedronKindSet.of(Jsons.toJson((String)source.getValue()), false);
        } else {
            kindSet = SpherePolyhedronKindSet.newEmpty();
            kindSet.settings().getFraction().setMode(this.fractionMode);
        }
        ArrayList<SpherePolyhedronKind> kinds = new ArrayList<SpherePolyhedronKind>(kindSet.allKinds());
        kinds.add(this.newKind());
        kindSet = SpherePolyhedronKindSet.of(kinds, kindSet.settings(), false);
        return SScalar.of((Object)kindSet.toJsonString());
    }

    public KindWithRandomDistribution newKind() {
        Set<Long> prohibitedKindIds;
        KindWithRandomDistribution kind = this.kindClass.newKind();
        long numericId = SpherePolyhedronKind.friendlyStringToId(this.id);
        if (numericId < 0L) {
            throw new IllegalArgumentException("Invalid id \"" + this.id + "\": it is system and is not allowed here");
        }
        kind.setId(numericId);
        kind.setLabel(this.label);
        kind.setColor(this.color);
        kind.setFraction(this.fraction);
        kind.setDistribution(this.distribution);
        if (kind instanceof KindWithRadius) {
            ((KindWithRadius)((Object)kind)).setR(this.r);
            ((KindWithRadius)((Object)kind)).setDr(this.dr);
        }
        if (kind instanceof KindWithSizeA) {
            ((KindWithSizeA)((Object)kind)).setA(this.a);
            ((KindWithSizeA)((Object)kind)).setDa(this.da);
        }
        if (kind instanceof KindWithSizeB) {
            ((KindWithSizeB)((Object)kind)).setB(this.b);
            ((KindWithSizeB)((Object)kind)).setDb(this.db);
        }
        if (kind instanceof SphereCrossKind) {
            ((SphereCrossKind)kind).setRb(this.rb);
            ((SphereCrossKind)kind).setDrb(this.drb);
            ((SphereCrossKind)kind).setH(this.h);
            ((SphereCrossKind)kind).setDh(this.dh);
            ((SphereCrossKind)kind).setMode(this.sphereCrossMode);
            ((SphereCrossKind)kind).setInRange(this.sphereCrossInRange);
        }
        if (kind instanceof KindWithDirections && this.numberOfPreferredDirections > 0) {
            ArrayList<PreferredDirection> directions = new ArrayList<PreferredDirection>();
            directions.add(new PreferredDirection().setDirection(this.preferredDirection1X, this.preferredDirection1Y, this.preferredDirection1Z).setDistribution(this.preferredDirection1Distribution).setAngleDeviationInDegrees(this.preferredDirection1AngleDeviationInDegrees));
            if (this.numberOfPreferredDirections >= 2) {
                directions.add(new PreferredDirection().setDirection(this.preferredDirection2X, this.preferredDirection2Y, this.preferredDirection2Z).setDistribution(this.preferredDirection2Distribution).setAngleDeviationInDegrees(this.preferredDirection2AngleDeviationInDegrees));
            }
            if (this.numberOfPreferredDirections >= 3) {
                directions.add(new PreferredDirection().setDirection(this.preferredDirection3X, this.preferredDirection3Y, this.preferredDirection3Z).setDistribution(this.preferredDirection3Distribution).setAngleDeviationInDegrees(this.preferredDirection3AngleDeviationInDegrees));
            }
            ((KindWithDirections)kind).setDirections(new PreferredDirections().setDirections(directions));
        }
        ArrayList<SpherePolyhedraNeighbourhoodPackingRestriction> restrictions = new ArrayList<SpherePolyhedraNeighbourhoodPackingRestriction>();
        Set<Long> requiredKindIds = SpherePolyhedronKind.splitKindIds(this.requiredNeighbourKinds);
        if (!requiredKindIds.isEmpty()) {
            restrictions.add(new NeighbourKindSetRequirement().setMinimalNumberOfRequiredNeighbours(1).setRequiredNeighbourKindSet(requiredKindIds));
        }
        if (!(prohibitedKindIds = SpherePolyhedronKind.splitKindIds(this.prohibitedNeighbourKinds)).isEmpty()) {
            restrictions.add(new NeighbourKindSetProhibition().setMaximalNumberOfProhibitedNeighbours(1).setProhibitedNeighbourKindSet(prohibitedKindIds));
        }
        if (this.requiredNeighbourIndex != null) {
            restrictions.add(new NeighbourIndexRequirement().setRequiredNeighbourIndex(this.requiredNeighbourIndex));
        }
        kind.setRestrictionSet(SpherePolyhedraNeighbourhoodPackingRestrictionSet.of(restrictions));
        return kind;
    }

    protected boolean allowUninitializedInput() {
        return true;
    }
}

