/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.model3d.spherepolyhedra.drawing;

final class Orthonormal4DBasis {
    public static final double MIN_ALLOWED_LENGTH = 1.0E-100;
    public static final Orthonormal4DBasis DEFAULT = new Orthonormal4DBasis(1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
    private final double ix;
    private final double iy;
    private final double iz;
    private final double it;
    private final double jx;
    private final double jy;
    private final double jz;
    private final double jt;
    private final double kx;
    private final double ky;
    private final double kz;
    private final double kt;
    private final double lx;
    private final double ly;
    private final double lz;
    private final double lt;

    private Orthonormal4DBasis(double ix, double iy, double iz, double it, double jx, double jy, double jz, double jt, double kx, double ky, double kz, double kt, double lx, double ly, double lz, double lt) {
        this.ix = ix;
        this.iy = iy;
        this.iz = iz;
        this.it = it;
        this.jx = jx;
        this.jy = jy;
        this.jz = jz;
        this.jt = jt;
        this.kx = kx;
        this.ky = ky;
        this.kz = kz;
        this.kt = kt;
        this.lx = lx;
        this.ly = ly;
        this.lz = lz;
        this.lt = lt;
    }

    public double x(double i, double j, double k, double l) {
        return i * this.ix + j * this.jx + k * this.kx + l * this.lx;
    }

    public double y(double i, double j, double k, double l) {
        return i * this.iy + j * this.jy + k * this.ky + l * this.ly;
    }

    public double z(double i, double j, double k, double l) {
        return i * this.iz + j * this.jz + k * this.kz + l * this.lz;
    }

    public double t(double i, double j, double k, double l) {
        return i * this.it + j * this.jt + k * this.kt + l * this.lt;
    }

    public Orthonormal4DBasis rotateIJ(double angle) {
        if (angle == 0.0) {
            return this;
        }
        double cRot = Math.cos(angle);
        double sRot = Math.sin(angle);
        double newIx = cRot * this.ix + sRot * this.jx;
        double newIy = cRot * this.iy + sRot * this.jy;
        double newIz = cRot * this.iz + sRot * this.jz;
        double newIt = cRot * this.it + sRot * this.jt;
        double newJx = -sRot * this.ix + cRot * this.jx;
        double newJy = -sRot * this.iy + cRot * this.jy;
        double newJz = -sRot * this.iz + cRot * this.jz;
        double newJt = -sRot * this.it + cRot * this.jt;
        return new Orthonormal4DBasis(newIx, newIy, newIz, newIt, newJx, newJy, newJz, newJt, this.kx, this.ky, this.kz, this.kt, this.lx, this.ly, this.lz, this.lt);
    }

    public Orthonormal4DBasis rotateJK(double angle) {
        if (angle == 0.0) {
            return this;
        }
        double cRot = Math.cos(angle);
        double sRot = Math.sin(angle);
        double newJx = cRot * this.jx + sRot * this.kx;
        double newJy = cRot * this.jy + sRot * this.ky;
        double newJz = cRot * this.jz + sRot * this.kz;
        double newJt = cRot * this.jt + sRot * this.kt;
        double newKx = -sRot * this.jx + cRot * this.kx;
        double newKy = -sRot * this.jy + cRot * this.ky;
        double newKz = -sRot * this.jz + cRot * this.kz;
        double newKt = -sRot * this.jt + cRot * this.kt;
        return new Orthonormal4DBasis(this.ix, this.iy, this.iz, this.it, newJx, newJy, newJz, newJt, newKx, newKy, newKz, newKt, this.lx, this.ly, this.lz, this.lt);
    }

    public Orthonormal4DBasis rotateKL(double angle) {
        if (angle == 0.0) {
            return this;
        }
        double cRot = Math.cos(angle);
        double sRot = Math.sin(angle);
        double newKx = cRot * this.kx + sRot * this.lx;
        double newKy = cRot * this.ky + sRot * this.ly;
        double newKz = cRot * this.kz + sRot * this.lz;
        double newKt = cRot * this.kt + sRot * this.lt;
        double newLx = -sRot * this.kx + cRot * this.lx;
        double newLy = -sRot * this.ky + cRot * this.ly;
        double newLz = -sRot * this.kz + cRot * this.lz;
        double newLt = -sRot * this.kt + cRot * this.lt;
        return new Orthonormal4DBasis(this.ix, this.iy, this.iz, this.it, this.jx, this.jy, this.jz, this.jt, newKx, newKy, newKz, newKt, newLx, newLy, newLz, newLt);
    }

    public Orthonormal4DBasis rotateLI(double angle) {
        if (angle == 0.0) {
            return this;
        }
        double cRot = Math.cos(angle);
        double sRot = Math.sin(angle);
        double newLx = cRot * this.lx + sRot * this.ix;
        double newLy = cRot * this.ly + sRot * this.iy;
        double newLz = cRot * this.lz + sRot * this.iz;
        double newLt = cRot * this.lt + sRot * this.it;
        double newIx = -sRot * this.lx + cRot * this.ix;
        double newIy = -sRot * this.ly + cRot * this.iy;
        double newIz = -sRot * this.lz + cRot * this.iz;
        double newIt = -sRot * this.lt + cRot * this.it;
        return new Orthonormal4DBasis(newIx, newIy, newIz, newIt, this.jx, this.jy, this.jz, this.jt, this.kx, this.ky, this.kz, this.kt, newLx, newLy, newLz, newLt);
    }

    public Orthonormal4DBasis rotateIK(double angle) {
        if (angle == 0.0) {
            return this;
        }
        double cRot = Math.cos(angle);
        double sRot = Math.sin(angle);
        double newIx = cRot * this.ix + sRot * this.kx;
        double newIy = cRot * this.iy + sRot * this.ky;
        double newIz = cRot * this.iz + sRot * this.kz;
        double newIt = cRot * this.it + sRot * this.kt;
        double newKx = -sRot * this.ix + cRot * this.kx;
        double newKy = -sRot * this.iy + cRot * this.ky;
        double newKz = -sRot * this.iz + cRot * this.kz;
        double newKt = -sRot * this.it + cRot * this.kt;
        return new Orthonormal4DBasis(newIx, newIy, newIz, newIt, this.jx, this.jy, this.jz, this.jt, newKx, newKy, newKz, newKt, this.lx, this.ly, this.lz, this.lt);
    }

    public Orthonormal4DBasis rotateJL(double angle) {
        if (angle == 0.0) {
            return this;
        }
        double cRot = Math.cos(angle);
        double sRot = Math.sin(angle);
        double newJx = cRot * this.jx + sRot * this.lx;
        double newJy = cRot * this.jy + sRot * this.ly;
        double newJz = cRot * this.jz + sRot * this.lz;
        double newJt = cRot * this.jt + sRot * this.lt;
        double newLx = -sRot * this.jx + cRot * this.lx;
        double newLy = -sRot * this.jy + cRot * this.ly;
        double newLz = -sRot * this.jz + cRot * this.lz;
        double newLt = -sRot * this.jt + cRot * this.lt;
        return new Orthonormal4DBasis(this.ix, this.iy, this.iz, this.it, newJx, newJy, newJz, newJt, this.kx, this.ky, this.kz, this.kt, newLx, newLy, newLz, newLt);
    }
}

