/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.morphology;

import java.util.LinkedHashSet;
import java.util.Random;
import net.algart.executors.modules.cv.matrices.morphology.PatternSpecificationParser;
import net.algart.math.IRange;
import net.algart.math.patterns.Pattern;
import net.algart.math.patterns.Patterns;

public final class SubtractingPatternsTest {
    private static Pattern randomRectangularPatter(int dimCount, int size, Random rnd) {
        IRange[] sides = new IRange[dimCount];
        for (int k = 0; k < dimCount; ++k) {
            long min = rnd.nextInt(size) - size / 2;
            sides[k] = IRange.of((long)min, (long)(rnd.nextInt(size) + size / 2));
        }
        return Patterns.newRectangularIntegerPattern((IRange[])sides);
    }

    private static Pattern simpleSubtract(Pattern pattern1, Pattern pattern2) {
        LinkedHashSet points = new LinkedHashSet(pattern1.roundedPoints());
        points.removeAll(pattern2.roundedPoints());
        return points.isEmpty() ? null : Patterns.newIntegerPattern(points);
    }

    public static void main(String[] args) {
        Random rnd = new Random(135L);
        for (int dimCount = 1; dimCount < 5; ++dimCount) {
            System.out.printf("Testing %d dimensions...%n", dimCount);
            int testCount = 65536 >> dimCount;
            for (int test = 0; test < testCount; ++test) {
                Pattern subtract;
                Pattern pattern2;
                Pattern pattern1;
                Pattern simpleSubtract;
                if (test % 100 == 0) {
                    System.out.printf("%d / %d\r", test, testCount);
                }
                if ((simpleSubtract = SubtractingPatternsTest.simpleSubtract(pattern1 = SubtractingPatternsTest.randomRectangularPatter(dimCount, 8, rnd), pattern2 = SubtractingPatternsTest.randomRectangularPatter(dimCount, 5, rnd))) != null && !(subtract = PatternSpecificationParser.subtract((Pattern)pattern1, (Pattern)pattern2)).points().equals(simpleSubtract.points())) {
                    throw new AssertionError((Object)("Unequal results for " + String.valueOf(pattern1) + " and " + String.valueOf(pattern2) + ":\n" + String.valueOf(subtract) + " instead of\n" + String.valueOf(simpleSubtract)));
                }
            }
        }
        System.out.printf("\rO'k                %n", new Object[0]);
    }
}

