/*
 * Decompiled with CFR 0.152.
 */
package net.algart.maps.pyramids.io.formats.sources.svs.metadata;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.algart.json.Jsons;
import net.algart.maps.pyramids.io.formats.sources.svs.SVSPlanePyramidSource;
import net.algart.maps.pyramids.io.formats.sources.svs.metadata.EmptyImageDescription;
import net.algart.maps.pyramids.io.formats.sources.svs.metadata.SVSAdditionalCombiningInfo;
import net.algart.maps.pyramids.io.formats.sources.svs.metadata.SVSAttribute;
import net.algart.maps.pyramids.io.formats.sources.svs.metadata.StandardSVSImageDescription;
import net.algart.matrices.tiff.TiffException;

public abstract class SVSImageDescription {
    final List<String> text = new ArrayList<String>();
    final Map<String, SVSAttribute> attributes = new LinkedHashMap<String, SVSAttribute>();

    SVSImageDescription() {
    }

    public static SVSImageDescription of(String imageDescriptionTagValue) {
        StandardSVSImageDescription result = new StandardSVSImageDescription(imageDescriptionTagValue);
        if (((SVSImageDescription)result).isImportant()) {
            return result;
        }
        return new EmptyImageDescription(imageDescriptionTagValue);
    }

    public final List<String> getText() {
        return Collections.unmodifiableList(this.text);
    }

    public final Map<String, SVSAttribute> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public abstract String subFormatTitle();

    public abstract Set<String> importantAttributeNames();

    public abstract List<String> importantTextAttributes();

    public abstract boolean isImportant();

    public boolean isPixelSizeSupported() {
        return false;
    }

    public double pixelSize() throws TiffException {
        throw new UnsupportedOperationException();
    }

    public boolean isMagnificationSupported() {
        return false;
    }

    public double magnification() throws TiffException {
        throw new UnsupportedOperationException();
    }

    public boolean isGeometrySupported() {
        return false;
    }

    public double imageOnSlideLeftInMicronsAxisRightward() throws TiffException {
        throw new UnsupportedOperationException();
    }

    public double imageOnSlideTopInMicronsAxisUpward() throws TiffException {
        throw new UnsupportedOperationException();
    }

    public boolean correctCombiningInfoUsingFoundBorder(SVSAdditionalCombiningInfo additionalCombiningInfo, SVSPlanePyramidSource source, long borderLeftTopX, long borderLeftTopY) {
        return false;
    }

    public final JsonObject toJson() {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("text", (JsonValue)Json.createArrayBuilder(this.text).build());
        JsonObjectBuilder attributesBuilder = Json.createObjectBuilder();
        for (SVSAttribute attribute : this.attributes.values()) {
            attributesBuilder.add(attribute.getName(), attribute.getValue());
        }
        builder.add("attributes", (JsonValue)attributesBuilder.build());
        if (this.isPixelSizeSupported()) {
            try {
                Jsons.addDouble((JsonObjectBuilder)builder, (String)"pixelSize", (double)this.pixelSize());
            }
            catch (TiffException e) {
                builder.add("pixelSize", "format error: " + String.valueOf((Object)e));
            }
        }
        return builder.build();
    }

    public String toString() {
        return Jsons.toPrettyString((JsonObject)this.toJson());
    }
}

