/*
 * Decompiled with CFR 0.152.
 */
package net.algart.maps.pyramids.io.formats.sources.svs;

import java.awt.Color;
import java.io.IOError;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.maps.pyramids.io.api.AbstractPlanePyramidSource;
import net.algart.maps.pyramids.io.api.PlanePyramidSource;
import net.algart.maps.pyramids.io.api.PlanePyramidTools;
import net.algart.maps.pyramids.io.api.sources.RotatingPlanePyramidSource;
import net.algart.maps.pyramids.io.formats.sources.svs.SVSIFDClassifier;
import net.algart.maps.pyramids.io.formats.sources.svs.metadata.SVSAdditionalCombiningInfo;
import net.algart.maps.pyramids.io.formats.sources.svs.metadata.SVSImageDescription;
import net.algart.math.IPoint;
import net.algart.math.IRectangularArea;
import net.algart.math.Point;
import net.algart.math.RectangularArea;
import net.algart.matrices.tiff.TiffException;
import net.algart.matrices.tiff.TiffIFD;
import net.algart.matrices.tiff.TiffReader;
import net.algart.matrices.tiff.TiffSampleType;
import net.algart.matrices.tiff.pyramids.TiffPyramidMetadata;
import net.algart.matrices.tiff.tags.SvsDescription;
import net.algart.matrices.tiff.tags.TagCompression;
import net.algart.matrices.tiff.tags.TagDescription;
import net.algart.matrices.tiff.tiles.TiffMap;
import net.algart.matrices.tiff.tiles.TiffReadMap;

public final class SVSPlanePyramidSource
extends AbstractPlanePyramidSource
implements PlanePyramidSource {
    private static final boolean ENABLE_VIRTUAL_LAYERS = true;
    private static final int SVS_IFD_THUMBNAIL_INDEX = 1;
    private static final int COMBINING_LITTLE_GAP = 3;
    public static final byte TIFF_FILLER = -16;
    private static final System.Logger LOG = System.getLogger(SVSPlanePyramidSource.class.getName());
    private final Path svsFile;
    private final SVSIFDClassifier ifdClassifier;
    private final TiffPyramidMetadata pyramidMetadata;
    private final List<SVSImageDescription> imageDescriptions;
    private final SVSImageDescription mainImageDescription;
    private final boolean geometrySupported;
    private final boolean combineWithWholeSlide;
    private final boolean virtualLayers;
    private final boolean moticFormat;
    private final int numberOfActualResolutions;
    private final int actualCompression;
    private final int compression;
    private final int numberOfResolutions;
    private final List<long[]> dimensions;
    private final long dimX;
    private final long dimY;
    private final Class<?> elementType;
    private final int bandCount;
    private final Double pixelSizeInMicrons;
    private final Double magnification;
    private final RectangularArea metricWholeSlide;
    private final RectangularArea metricPyramid;
    private final IRectangularArea pixelWholeSlide;
    private final IRectangularArea pixelPyramidAtWholeSlide;
    private final double zeroLevelPixelSize;
    private final LargeDataHolder largeData = new LargeDataHolder();
    private volatile Color dataBorderColor = Color.GRAY;
    private volatile int dataBorderWidth = 0;

    public SVSPlanePyramidSource(Path svsFile) throws IOException {
        this(svsFile, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVSPlanePyramidSource(Path svsFile, boolean combineWithWholeSlideRequest, SVSAdditionalCombiningInfo additionalCombiningInfo) throws IOException {
        Objects.requireNonNull(svsFile, "Null svsFile");
        long t1 = System.nanoTime();
        this.svsFile = svsFile;
        this.largeData.init();
        boolean success = false;
        try {
            int k;
            long levelDimY;
            long levelDimX;
            int ifdCount = this.largeData.maps.size();
            TiffMap map0 = (TiffMap)this.largeData.maps.get(0);
            this.bandCount = map0.numberOfChannels();
            assert (this.bandCount > 0);
            this.elementType = map0.elementType();
            long imageDimX = map0.dimX();
            long imageDimY = map0.dimY();
            this.pyramidMetadata = TiffPyramidMetadata.ofMaps(this.largeData.maps);
            this.imageDescriptions = new ArrayList<SVSImageDescription>();
            for (int k2 = 0; k2 < ifdCount; ++k2) {
                String description = this.largeData.maps.get(k2).description().description();
                this.imageDescriptions.add(SVSImageDescription.of(description));
            }
            this.mainImageDescription = SVSPlanePyramidSource.findMainImageDescription(this.imageDescriptions);
            if (this.mainImageDescription != null) {
                this.pixelSizeInMicrons = this.mainImageDescription.isPixelSizeSupported() ? Double.valueOf(this.mainImageDescription.pixelSize()) : null;
                this.magnification = this.mainImageDescription.isMagnificationSupported() ? Double.valueOf(this.mainImageDescription.magnification()) : null;
            } else {
                this.pixelSizeInMicrons = null;
                this.magnification = null;
            }
            this.moticFormat = SVSPlanePyramidSource.detectMotic(this.largeData.maps, this.mainImageDescription);
            this.ifdClassifier = new SVSIFDClassifier(this.largeData.maps);
            LOG.log(System.Logger.Level.DEBUG, () -> "SVS reader classified IFDs: " + String.valueOf(this.ifdClassifier));
            TiffMap mapMacro = this.ifdClassifier.hasMacro() ? (TiffMap)this.largeData.maps.get(this.ifdClassifier.getMacroIndex()) : null;
            long ifdMacroWidth = mapMacro == null ? -1L : (long)mapMacro.dimX();
            long ifdMacroHeight = mapMacro == null ? -1L : (long)mapMacro.dimY();
            Double slideWidthInMicrons = additionalCombiningInfo == null ? null : additionalCombiningInfo.getSlideWidthInMicrons();
            Double slideHeightInMicrons = additionalCombiningInfo == null ? null : additionalCombiningInfo.getSlideHeightInMicrons();
            this.geometrySupported = this.mainImageDescription != null && this.mainImageDescription.isGeometrySupported() && (slideWidthInMicrons != null || slideHeightInMicrons != null);
            boolean bl = this.combineWithWholeSlide = combineWithWholeSlideRequest && mapMacro != null && this.geometrySupported && mapMacro.elementType() == this.elementType && mapMacro.numberOfChannels() == this.bandCount;
            if (this.combineWithWholeSlide) {
                this.zeroLevelPixelSize = this.mainImageDescription.pixelSize();
                double slideWidth = slideWidthInMicrons != null ? slideWidthInMicrons : (double)Math.round(slideHeightInMicrons * (double)ifdMacroWidth / (double)ifdMacroHeight);
                double slideHeight = slideHeightInMicrons != null ? slideHeightInMicrons : (double)Math.round(slideWidthInMicrons * (double)ifdMacroHeight / (double)ifdMacroWidth);
                this.metricWholeSlide = RectangularArea.of((Point)Point.of((double)0.0, (double)0.0), (Point)Point.of((double)slideWidth, (double)slideHeight));
                double imageWidth = (double)imageDimX * this.zeroLevelPixelSize;
                double imageHeight = (double)imageDimY * this.zeroLevelPixelSize;
                double metricLeft = this.mainImageDescription.imageOnSlideLeftInMicronsAxisRightward();
                double metricTop = slideHeight - this.mainImageDescription.imageOnSlideTopInMicronsAxisUpward();
                this.metricPyramid = RectangularArea.of((Point)Point.of((double)metricLeft, (double)metricTop), (Point)Point.of((double)(metricLeft + imageWidth), (double)(metricTop + imageHeight)));
                this.pixelWholeSlide = IRectangularArea.of((IPoint)IPoint.of((long)0L, (long)0L), (IPoint)IPoint.of((long)(ifdMacroWidth - 1L), (long)(ifdMacroHeight - 1L)));
                long pixelLeft = Math.round((double)ifdMacroWidth * metricLeft / slideWidth);
                long pixelTop = Math.round((double)ifdMacroHeight * metricTop / slideHeight);
                this.pixelPyramidAtWholeSlide = IRectangularArea.of((IPoint)IPoint.of((long)pixelLeft, (long)pixelTop), (IPoint)IPoint.of((long)Math.max(pixelLeft, Math.round((double)ifdMacroWidth * (metricLeft + imageWidth) / slideWidth) - 1L), (long)Math.max(pixelTop, Math.round((double)ifdMacroHeight * (metricTop + imageHeight) / slideHeight) - 1L)));
                levelDimX = (long)((double)imageDimX * this.metricWholeSlide.size(0) / this.metricPyramid.size(0));
                levelDimY = (long)((double)imageDimY * this.metricWholeSlide.size(1) / this.metricPyramid.size(1));
            } else {
                this.zeroLevelPixelSize = Double.NaN;
                this.metricWholeSlide = null;
                this.metricPyramid = null;
                this.pixelWholeSlide = null;
                this.pixelPyramidAtWholeSlide = null;
                levelDimX = imageDimX;
                levelDimY = imageDimY;
            }
            this.dimX = levelDimX;
            this.dimY = levelDimY;
            if (this.dimX > Integer.MAX_VALUE || this.dimY > Integer.MAX_VALUE) {
                throw new TiffException("Too large image " + this.dimX + "x" + this.dimY);
            }
            LOG.log(System.Logger.Level.DEBUG, () -> String.format(Locale.US, "SVS reader opens image %s: %s[%dx%d]%n  IFD #0/%d %dx%d, %s-endian, %d bands%n  combineWithWholeSlide mode: %s (%s); geometrySupported: %s%n  whole slide area %s (microns);%n  pyramid area %s (microns);%n  SVS reader checks IFD #0: IFD compression method: %s; description:%n%s", svsFile, this.elementType, this.dimX, this.dimY, ifdCount, imageDimX, imageDimY, this.largeData.tiffReader.isLittleEndian() ? "little" : "big", this.bandCount, this.combineWithWholeSlide, combineWithWholeSlideRequest ? "requested" : "NOT requested", this.geometrySupported, this.metricWholeSlide, this.metricPyramid, SVSIFDClassifier.compressionToString(map0), this.printedDescription(0)));
            ArrayList<long[]> actualDimensions = new ArrayList<long[]>();
            actualDimensions.add(new long[]{this.bandCount, this.dimX, this.dimY});
            int actualCompression = 0;
            long pyramidLevelDimX = imageDimX;
            long pyramidLevelDimY = imageDimY;
            for (k = 1; k < ifdCount; ++k) {
                int index = k;
                TiffMap map = (TiffMap)this.largeData.maps.get(k);
                if (this.ifdClassifier.isSpecial(k)) {
                    LOG.log(System.Logger.Level.DEBUG, () -> String.format("  SVS reader skips special IFD #%d/%d: %s, IFD compression method: %s", index, ifdCount, SVSIFDClassifier.sizesToString(map), SVSIFDClassifier.compressionToString(map)));
                    continue;
                }
                long newPyramidLevelDimX = map.dimX();
                long newPyramidLevelDimY = map.dimY();
                if (actualCompression == 0) {
                    actualCompression = PlanePyramidTools.findCompression(new long[]{this.bandCount, pyramidLevelDimX, pyramidLevelDimY}, new long[]{this.bandCount, newPyramidLevelDimX, newPyramidLevelDimY});
                    if (actualCompression == 0) {
                        throw new IllegalArgumentException("Cannot find suitable compression for first two levels " + levelDimX + "x" + levelDimY + " and " + newPyramidLevelDimX + "x" + newPyramidLevelDimY);
                    }
                    int ac = actualCompression;
                    LOG.log(System.Logger.Level.DEBUG, () -> String.format("SVS reader automatically detected compression %d", ac));
                }
                if (this.combineWithWholeSlide) {
                    levelDimX /= (long)actualCompression;
                    levelDimY /= (long)actualCompression;
                } else {
                    levelDimX = newPyramidLevelDimX;
                    levelDimY = newPyramidLevelDimY;
                }
                if (LOG.isLoggable(System.Logger.Level.DEBUG)) {
                    LOG.log(System.Logger.Level.DEBUG, String.format("  SVS reader checks IFD #%d/%d: %dx%d, IFD %dx%d; IFD compression method: %s; description: %s", k, ifdCount, levelDimX, levelDimY, newPyramidLevelDimX, newPyramidLevelDimY, SVSIFDClassifier.compressionToString(map), this.printedDescription(k)));
                }
                if (!PlanePyramidTools.isDimensionsRelationCorrect(new long[]{this.bandCount, pyramidLevelDimX, pyramidLevelDimY}, new long[]{this.bandCount, newPyramidLevelDimX, newPyramidLevelDimY}, actualCompression)) {
                    int remaining = ifdCount - k;
                    LOG.log(System.Logger.Level.DEBUG, () -> String.format("SVS reader found incorrect compression; skipping following %d IFDs", remaining));
                    for (int i = k; i < ifdCount; ++i) {
                        int skippedIndex = i;
                        TiffMap skippedMap = (TiffMap)this.largeData.maps.get(i);
                        if (this.ifdClassifier.isSpecial(i)) {
                            LOG.log(System.Logger.Level.DEBUG, () -> String.format("  SVS reader skips special IFD #%d/%d: %s, IFD compression method: %s", skippedIndex, ifdCount, SVSIFDClassifier.sizesToString(skippedMap), SVSIFDClassifier.compressionToString(skippedMap)));
                            continue;
                        }
                        LOG.log(System.Logger.Level.DEBUG, () -> String.format("  SVS reader skips unknown%s IFD #%d/%d: %s; IFD compression method: %s; description:%n%s", this.ifdClassifier.isUnknownSpecial(skippedIndex) ? " (probably special)" : "", skippedIndex, ifdCount, SVSIFDClassifier.sizesToString(skippedMap), SVSIFDClassifier.compressionToString(skippedMap), this.printedDescription(skippedIndex)));
                    }
                    break;
                }
                Class elementType = map.elementType();
                if (elementType != this.elementType) {
                    throw new TiffException("Invalid element types: \"" + String.valueOf(elementType) + "\" instead of \"" + String.valueOf(this.elementType) + "\" (image description " + map.description().description("N/A") + ")");
                }
                if (map.numberOfChannels() != this.bandCount) {
                    throw new TiffException("Invalid number of samples per pixel: " + map.numberOfChannels() + " instead of " + this.bandCount + " (image description " + map.description().description("N/A") + ")");
                }
                actualDimensions.add(new long[]{this.bandCount, levelDimX, levelDimY});
                pyramidLevelDimX = newPyramidLevelDimX;
                pyramidLevelDimY = newPyramidLevelDimY;
            }
            this.actualCompression = actualCompression == 0 ? 2 : actualCompression;
            this.numberOfActualResolutions = actualDimensions.size();
            boolean bl2 = this.virtualLayers = this.combineWithWholeSlide && (this.actualCompression & this.actualCompression - 1) == 0;
            if (this.virtualLayers) {
                this.compression = 2;
                this.numberOfResolutions = PlanePyramidTools.numberOfResolutions(this.dimX, this.dimY, this.compression, 256L);
                assert (this.numberOfResolutions >= 1);
                this.dimensions = new ArrayList<long[]>();
                levelDimX = this.dimX;
                levelDimY = this.dimY;
                for (k = 0; k < this.numberOfResolutions; ++k) {
                    if (LOG.isLoggable(System.Logger.Level.DEBUG)) {
                        LOG.log(System.Logger.Level.DEBUG, String.format("SVS reader adds layer #%d %s%d): %dx%d", k, SVSPlanePyramidSource.dimensionsContains(actualDimensions, levelDimX, levelDimY) ? "(actual layer " : "(virtual, nearest actual is ", this.resolutionLevelToActualResolutionLevel(k), levelDimX, levelDimY));
                    }
                    this.dimensions.add(new long[]{this.bandCount, levelDimX, levelDimY});
                    levelDimX /= 2L;
                    levelDimY /= 2L;
                }
            } else {
                LOG.log(System.Logger.Level.DEBUG, "SVS reader does not create virtual layers");
                this.compression = this.actualCompression;
                this.numberOfResolutions = this.numberOfActualResolutions;
                this.dimensions = actualDimensions;
            }
            long t2 = System.nanoTime();
            LOG.log(System.Logger.Level.DEBUG, () -> String.format("SVS reader found %d layers with correct inter-layer compression among %d total IFDs; thumbnail %s, label %s, macro %s", this.numberOfActualResolutions, ifdCount, this.ifdClassifier.hasThumbnail() ? "found in IFD #" + this.ifdClassifier.getThumbnailIndex() : "NOT found", this.ifdClassifier.hasLabel() ? "found in IFD #" + this.ifdClassifier.getLabelIndex() : "NOT found", this.ifdClassifier.hasMacro() ? "found in IFD #" + this.ifdClassifier.getMacroIndex() : "NOT found"));
            LOG.log(System.Logger.Level.DEBUG, () -> String.format(Locale.US, "SVS reader instantiating %s: %.3f ms", this, (double)(t2 - t1) * 1.0E-6));
            success = true;
        }
        finally {
            if (!success) {
                this.largeData.freeResources();
            }
        }
    }

    public Color getDataBorderColor() {
        return this.dataBorderColor;
    }

    public void setDataBorderColor(Color dataBorderColor) {
        if (dataBorderColor == null) {
            throw new NullPointerException("Null dataBorderColor");
        }
        this.dataBorderColor = dataBorderColor;
    }

    public int getDataBorderWidth() {
        return this.dataBorderWidth;
    }

    public void setDataBorderWidth(int dataBorderWidth) {
        if (dataBorderWidth < 0) {
            throw new IllegalArgumentException("Negative dataBorderWidth");
        }
        this.dataBorderWidth = dataBorderWidth;
    }

    public Path getSvsFile() {
        return this.svsFile;
    }

    public SVSIFDClassifier getIfdClassifier() {
        return this.ifdClassifier;
    }

    public long getDimX() {
        return this.dimX;
    }

    public long getDimY() {
        return this.dimY;
    }

    public boolean isCombineWithWholeSlide() {
        return this.combineWithWholeSlide;
    }

    public boolean isGeometrySupported() {
        return this.geometrySupported;
    }

    public TiffPyramidMetadata pyramidMetadata() {
        return this.pyramidMetadata;
    }

    public SVSImageDescription mainImageDescription() {
        return this.mainImageDescription;
    }

    public RectangularArea metricWholeSlide() {
        return this.metricWholeSlide;
    }

    public RectangularArea metricPyramid() {
        return this.metricPyramid;
    }

    public IRectangularArea pixelWholeSlide() {
        return this.pixelWholeSlide;
    }

    public IRectangularArea pixelPyramidAtWholeSlide() {
        return this.pixelPyramidAtWholeSlide;
    }

    public boolean isMoticFormat() {
        return this.moticFormat;
    }

    public RotatingPlanePyramidSource.RotationMode recommendedRotation(PlanePyramidSource.SpecialImageKind kind) {
        if (this.moticFormat) {
            return kind == PlanePyramidSource.SpecialImageKind.LABEL_ONLY_IMAGE ? RotatingPlanePyramidSource.RotationMode.CLOCKWISE_270 : RotatingPlanePyramidSource.RotationMode.CLOCKWISE_90;
        }
        return RotatingPlanePyramidSource.RotationMode.NONE;
    }

    @Override
    public int numberOfResolutions() {
        return this.numberOfResolutions;
    }

    @Override
    public int compression() {
        return this.compression;
    }

    @Override
    public int bandCount() {
        return this.bandCount;
    }

    @Override
    public long[] dimensions(int resolutionLevel) {
        this.checkResolutionLevel(resolutionLevel);
        return (long[])this.dimensions.get(resolutionLevel).clone();
    }

    @Override
    public long dim(int resolutionLevel, int index) {
        this.checkResolutionLevel(resolutionLevel);
        return this.dimensions.get(resolutionLevel)[index];
    }

    @Override
    public boolean isElementTypeSupported() {
        return true;
    }

    @Override
    public Class<?> elementType() throws UnsupportedOperationException {
        return this.elementType;
    }

    @Override
    public OptionalDouble pixelSizeInMicrons() {
        return this.pixelSizeInMicrons == null ? OptionalDouble.empty() : OptionalDouble.of(this.pixelSizeInMicrons);
    }

    @Override
    public OptionalDouble magnification() {
        return this.magnification == null ? OptionalDouble.empty() : OptionalDouble.of(this.magnification);
    }

    @Override
    public List<IRectangularArea> zeroLevelActualRectangles() {
        return this.combineWithWholeSlide ? Collections.singletonList(this.metricPyramidForCombiningAtLevel(0)) : null;
    }

    @Override
    public boolean isSpecialMatrixSupported(PlanePyramidSource.SpecialImageKind kind) {
        return this.ifdClassifier.isSpecialMatrixSupported(kind);
    }

    @Override
    public Optional<Matrix<? extends PArray>> readSpecialMatrix(PlanePyramidSource.SpecialImageKind kind) {
        Objects.requireNonNull(kind, "Null image kind");
        this.largeData.writeLock.lock();
        try {
            this.largeData.init();
            OptionalInt ifdIndex = this.ifdClassifier.getSpecialKindIndex(kind);
            if (ifdIndex.isEmpty()) {
                LOG.log(System.Logger.Level.DEBUG, () -> String.format("SVS reader cannot read special image %s: it is not supported", new Object[]{kind}));
                Optional<Matrix<? extends PArray>> optional = super.readSpecialMatrix(kind);
                return optional;
            }
            int i = ifdIndex.getAsInt();
            LOG.log(System.Logger.Level.DEBUG, () -> String.format("SVS reading special image %s (IFD #%d)", new Object[]{kind, i}));
            TiffIFD ifd = this.largeData.maps.get(i).ifd();
            int width = ifd.getImageDimX();
            int height = ifd.getImageDimY();
            assert (width > 0 && height > 0);
            Optional<Matrix<? extends PArray>> optional = Optional.of(this.readData(i, 0, 0, width, height));
            return optional;
        }
        catch (TiffException e) {
            throw new IOError(PlanePyramidTools.rmiSafeWrapper((Exception)((Object)e)));
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        finally {
            this.largeData.writeLock.unlock();
        }
    }

    @Override
    public Optional<String> metadata() {
        return Optional.of(this.pyramidMetadata.toString());
    }

    @Override
    public void loadResources() {
        this.largeData.writeLock.lock();
        try {
            this.largeData.init();
        }
        catch (TiffException e) {
            throw new IOError(PlanePyramidTools.rmiSafeWrapper((Exception)((Object)e)));
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        finally {
            this.largeData.writeLock.unlock();
        }
        super.loadResources();
    }

    @Override
    public void freeResources(PlanePyramidSource.FlushMode flushMode) {
        super.freeResources(flushMode);
        this.largeData.writeLock.lock();
        try {
            this.largeData.freeResources();
        }
        finally {
            this.largeData.writeLock.unlock();
        }
    }

    public String toString() {
        return "SVS plane pyramid source for file " + String.valueOf(this.svsFile);
    }

    @Override
    protected Matrix<? extends PArray> readLittleSubMatrix(int resolutionLevel, long fromX, long fromY, long toX, long toY) {
        long[] dim = this.dimensions(resolutionLevel);
        long dimX = dim[1];
        long dimY = dim[2];
        assert (dimX <= Integer.MAX_VALUE);
        assert (dimY <= Integer.MAX_VALUE);
        if (fromX < 0L || fromY < 0L || fromX > toX || fromY > toY || toX > dimX || toY > dimY) {
            throw new IndexOutOfBoundsException("Illegal fromX/fromY/toX/toY: must be in ranges 0.." + dimX + ", 0.." + dimY + ", fromX<=toX, fromY<=toY");
        }
        int sizeX = (int)(toX - fromX);
        int sizeY = (int)(toY - fromY);
        assert ((long)sizeX == toX - fromX);
        assert ((long)sizeY == toY - fromY);
        assert (fromX == (long)((int)fromX));
        assert (fromY == (long)((int)fromY));
        if (sizeX == 0 || sizeY == 0) {
            return this.newResultMatrix(toX - fromX, toY - fromY);
        }
        IRectangularArea requiredArea = IRectangularArea.of((IPoint)IPoint.of((long)fromX, (long)fromY), (IPoint)IPoint.of((long)(toX - 1L), (long)(toY - 1L)));
        if (this.combineWithWholeSlide) {
            this.largeData.initWholeSlideSynchronously();
        }
        Lock lock = this.largeData.readLock;
        lock.lock();
        if (!this.largeData.initialized()) {
            lock.unlock();
            LOG.log(System.Logger.Level.DEBUG, () -> String.format("%n%nSVS reader switches to exclusive lock%n%n", new Object[0]));
            lock = this.largeData.writeLock;
            lock.lock();
        }
        try {
            this.largeData.init();
            LOG.log(System.Logger.Level.DEBUG, () -> String.format("SVS reading %d..%d x %d..%d (%dx%d), level %d from %s", fromX, toX, fromY, toY, toX - fromX, toY - fromY, resolutionLevel, this.svsFile));
            if (this.combineWithWholeSlide) {
                Matrix subMatrixAtWholeSlide;
                Matrix<? extends PArray> m;
                IRectangularArea actualArea = this.metricPyramidForCombiningAtLevel(resolutionLevel);
                IRectangularArea borderedArea = this.expandByBorder(actualArea);
                boolean combiningNotNecessary = actualArea.contains(requiredArea);
                LOG.log(System.Logger.Level.TRACE, () -> String.format(" Actual area %s, combining%s necessary", actualArea, combiningNotNecessary ? "NOT " : ""));
                if (combiningNotNecessary) {
                    Matrix<? extends PArray> matrix = this.readAndCompressDataFromLevel(resolutionLevel, (int)(fromX - actualArea.min(0)), (int)(fromY - actualArea.min(1)), sizeX, sizeY);
                    return matrix;
                }
                IRectangularArea intersection = actualArea.intersection(requiredArea);
                IRectangularArea borderedIntersection = borderedArea.intersection(requiredArea);
                boolean skipCoarseData = this.isSkipCoarseData();
                if (skipCoarseData && borderedIntersection == null) {
                    LOG.log(System.Logger.Level.DEBUG, "SVS skipping data");
                    Matrix<? extends PArray> matrix = this.constantMatrixSkippingFiller(this.elementType(), sizeX, sizeY);
                    return matrix;
                }
                Matrix result = this.newResultMatrix(sizeX, sizeY);
                Matrix<? extends PArray> wholeSlide = this.largeData.wholeSlidePyramid.get(0);
                for (int k = 1; k < this.largeData.wholeSlidePyramid.size() && (m = this.largeData.wholeSlidePyramid.get(k)).dim(1) >= dimX && m.dim(2) >= dimY; ++k) {
                    wholeSlide = m;
                }
                double scaleX = (double)wholeSlide.dim(1) / (double)dimX;
                double scaleY = (double)wholeSlide.dim(2) / (double)dimY;
                long fromXAtWholeSlide = Math.round((double)fromX * scaleX);
                long fromYAtWholeSlide = Math.round((double)fromY * scaleY);
                long toXAtWholeSlide = Math.round((double)toX * scaleX);
                long toYAtWholeSlide = Math.round((double)toY * scaleY);
                if (skipCoarseData) {
                    this.fillBySkippingFiller(result, false);
                } else {
                    subMatrixAtWholeSlide = wholeSlide.subMatrix(0L, fromXAtWholeSlide, fromYAtWholeSlide, (long)this.bandCount, toXAtWholeSlide, toYAtWholeSlide);
                    Matrices.resize(null, (Matrices.ResizingMethod)Matrices.ResizingMethod.AVERAGING, (Matrix)result, (Matrix)subMatrixAtWholeSlide);
                }
                if (borderedIntersection == null) {
                    subMatrixAtWholeSlide = result;
                    return subMatrixAtWholeSlide;
                }
                if (this.dataBorderWidth > 0) {
                    PlanePyramidTools.fillMatrix((Matrix<? extends UpdatablePArray>)result, borderedIntersection.min(0) - requiredArea.min(0), borderedIntersection.min(1) - requiredArea.min(1), borderedIntersection.max(0) + 1L - requiredArea.min(0), borderedIntersection.max(1) + 1L - requiredArea.min(1), this.dataBorderColor);
                }
                if (intersection == null) {
                    subMatrixAtWholeSlide = result;
                    return subMatrixAtWholeSlide;
                }
                Matrix<? extends PArray> actual = this.readAndCompressDataFromLevel(resolutionLevel, (int)(intersection.min(0) - actualArea.min(0)), (int)(intersection.min(1) - actualArea.min(1)), (int)intersection.size(0), (int)intersection.size(1));
                LOG.log(System.Logger.Level.DEBUG, () -> String.format("SVS combining (level %d): %d..%d x %d..%d (%d x %d) from whole slide image with actual image %s (intersection %d x %d)", resolutionLevel, fromXAtWholeSlide, toXAtWholeSlide, fromYAtWholeSlide, toYAtWholeSlide, toXAtWholeSlide - fromXAtWholeSlide, toYAtWholeSlide - fromYAtWholeSlide, actualArea, intersection.size(0), intersection.size(1)));
                assert (requiredArea.size(0) == (long)sizeX);
                assert (requiredArea.size(1) == (long)sizeY);
                ((UpdatablePArray)result.subMatr(0L, intersection.min(0) - requiredArea.min(0), intersection.min(1) - requiredArea.min(1), (long)this.bandCount, intersection.size(0), intersection.size(1)).array()).copy(actual.array());
                Matrix matrix = result;
                return matrix;
            }
            Matrix<? extends PArray> actualArea = this.readAndCompressDataFromLevel(resolutionLevel, (int)fromX, (int)fromY, sizeX, sizeY);
            return actualArea;
        }
        catch (TiffException e) {
            throw new IOError(PlanePyramidTools.rmiSafeWrapper((Exception)((Object)e)));
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        finally {
            lock.unlock();
        }
    }

    private static boolean detectMotic(List<? extends TiffMap> maps, SVSImageDescription mainImageDescription) throws TiffException {
        if (mainImageDescription != null && mainImageDescription.isGeometrySupported()) {
            return false;
        }
        int numberOfLZW = 0;
        for (int ifdIndex = 0; ifdIndex < maps.size(); ++ifdIndex) {
            TiffIFD ifd = maps.get(ifdIndex).ifd();
            if (!SVSIFDClassifier.isSmallImage(ifd) || ifdIndex == 1 || ifd.getCompressionCode() != TagCompression.LZW.code()) continue;
            ++numberOfLZW;
        }
        return numberOfLZW == 2;
    }

    private static SVSImageDescription findMainImageDescription(List<SVSImageDescription> imageDescriptions) {
        for (SVSImageDescription description : imageDescriptions) {
            if (!description.isImportant()) continue;
            return description;
        }
        return null;
    }

    private static boolean dimensionsContains(List<long[]> dimensions, long levelDimX, long levelDimY) {
        for (long[] dim : dimensions) {
            if (dim[1] != levelDimX || dim[2] != levelDimY) continue;
            return true;
        }
        return false;
    }

    private Matrix<? extends PArray> readAndCompressDataFromLevel(int resolutionLevel, int fromX, int fromY, int sizeX, int sizeY) throws IOException {
        int actualResolutionLevel = this.resolutionLevelToActualResolutionLevel(resolutionLevel);
        long requiredCompression = this.compression(resolutionLevel);
        long requiredActualCompression = this.actualCompression(actualResolutionLevel);
        long additionalCompression = requiredCompression / requiredActualCompression;
        assert (additionalCompression == (long)((int)additionalCompression));
        int ifdIndex = actualResolutionLevel < 1 ? actualResolutionLevel : actualResolutionLevel + 1;
        int actualSizeX = sizeX * (int)additionalCompression;
        int actualSizeY = sizeY * (int)additionalCompression;
        int actualFromY = fromY * (int)additionalCompression;
        int actualFromX = fromX * (int)additionalCompression;
        Matrix<? extends PArray> actualMatrix = this.readData(ifdIndex, actualFromX, actualFromY, actualSizeX, actualSizeY);
        if (additionalCompression == 1L) {
            return actualMatrix;
        }
        Matrix<UpdatablePArray> result = this.newResultMatrix(sizeX, sizeY);
        Matrices.resize(null, (Matrices.ResizingMethod)Matrices.ResizingMethod.AVERAGING, result, actualMatrix);
        return result;
    }

    private Matrix<? extends PArray> readData(int ifdIndex, int fromX, int fromY, int sizeX, int sizeY) throws IOException {
        TiffReadMap map = this.largeData.maps.get(ifdIndex);
        map.checkPixelCompatibility(this.bandCount, TiffSampleType.of(this.elementType, (boolean)false));
        return map.readInterleavedMatrix(fromX, fromY, sizeX, sizeY);
    }

    private int resolutionLevelToActualResolutionLevel(int resolutionLevel) {
        int result;
        long requiredCompression = this.compression(resolutionLevel);
        long currentCompression = 1L;
        for (result = 0; result < this.numberOfActualResolutions && currentCompression <= requiredCompression; ++result, currentCompression *= (long)this.actualCompression) {
        }
        return result - 1;
    }

    private long compression(int resolutionLevel) {
        long result = 1L;
        for (int k = 0; k < resolutionLevel; ++k) {
            result *= (long)this.compression;
        }
        return result;
    }

    private long actualCompression(int actualResolutionLevel) {
        long result = 1L;
        for (int k = 0; k < actualResolutionLevel; ++k) {
            result *= (long)this.actualCompression;
        }
        return result;
    }

    private void checkResolutionLevel(int resolutionLevel) {
        if (resolutionLevel < 0) {
            throw new IllegalArgumentException("Negative resolution level = " + resolutionLevel);
        }
        if (resolutionLevel >= this.dimensions.size()) {
            throw new IndexOutOfBoundsException("Invalid resolution level " + resolutionLevel + ": must be < " + this.dimensions.size() + " (number of resolutions)");
        }
    }

    private IRectangularArea metricPyramidForCombiningAtLevel(int resolutionLevel) {
        double pixelSize = this.zeroLevelPixelSize * (double)this.compression(resolutionLevel);
        IPoint min = this.metricPyramid.min().subtract(this.metricWholeSlide.min()).multiply(1.0 / pixelSize).toRoundedPoint();
        IPoint max = this.metricPyramid.max().subtract(this.metricWholeSlide.min()).multiply(1.0 / pixelSize).toRoundedPoint();
        min = min.addToAllCoordinates(3L);
        max = max.addToAllCoordinates(-4L);
        max = max.max(min);
        return IRectangularArea.of((IPoint)min, (IPoint)max);
    }

    private IRectangularArea expandByBorder(IRectangularArea area) {
        return IRectangularArea.of((IPoint)area.min().addToAllCoordinates((long)(-this.dataBorderWidth)), (IPoint)area.max().addToAllCoordinates((long)this.dataBorderWidth));
    }

    private String printedDescription(int index) {
        String result;
        StringBuilder sb = new StringBuilder();
        TagDescription imageDescription = this.pyramidMetadata.description(index);
        String name = imageDescription.formatName();
        if (name != null) {
            sb.append(String.format("    [%s]%n", name));
        }
        if (imageDescription instanceof SvsDescription) {
            SvsDescription svs = (SvsDescription)imageDescription;
            for (String line : svs.raw()) {
                sb.append(String.format("    %s%n", line));
            }
        }
        return (result = sb.toString()).endsWith("%n") ? result.substring(0, result.length() - 2) : result;
    }

    private class LargeDataHolder {
        private TiffReader tiffReader = null;
        private List<TiffReadMap> maps = null;
        private List<Matrix<? extends PArray>> wholeSlidePyramid = null;
        private final Lock readLock;
        private final Lock writeLock;

        private LargeDataHolder() {
            ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
            this.writeLock = readWriteLock.writeLock();
            this.readLock = readWriteLock.readLock();
        }

        synchronized boolean initialized() {
            return this.tiffReader != null;
        }

        private synchronized void init() throws IOException {
            if (this.tiffReader == null) {
                long t1 = System.nanoTime();
                this.tiffReader = new TiffReader(SVSPlanePyramidSource.this.svsFile).setByteFiller((byte)-16).setCaching(true);
                this.maps = this.tiffReader.allMaps();
                long t2 = System.nanoTime();
                LOG.log(System.Logger.Level.DEBUG, String.format(Locale.US, "SVS parser opens file %s: %.3f ms", SVSPlanePyramidSource.this.svsFile, (double)(t2 - t1) * 1.0E-6));
            }
        }

        private synchronized void freeResources() {
            try {
                if (this.tiffReader != null) {
                    long t1 = System.nanoTime();
                    this.tiffReader.close();
                    long t2 = System.nanoTime();
                    LOG.log(System.Logger.Level.DEBUG, () -> String.format(Locale.US, "SVS parser closes file %s: %.3f ms", SVSPlanePyramidSource.this.svsFile, (double)(t2 - t1) * 1.0E-6));
                    this.tiffReader = null;
                    this.maps = null;
                }
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        private synchronized void initWholeSlideSynchronously() {
            if (this.wholeSlidePyramid == null) {
                Matrix<? extends PArray> wholeSlide = SVSPlanePyramidSource.this.readSpecialMatrix(PlanePyramidSource.SpecialImageKind.WHOLE_SLIDE).orElseThrow(() -> new AssertionError((Object)"Initialization of whole slide must not be called if WHOLE_SLIDE is not available"));
                this.wholeSlidePyramid = PlanePyramidTools.buildPyramid(wholeSlide);
            }
        }
    }
}

