/*
 * Decompiled with CFR 0.152.
 */
package net.algart.maps.pyramids.io.api;

import java.io.IOException;
import net.algart.maps.pyramids.io.api.PlanePyramidSource;

public interface PlanePyramidSourceFactory
extends AutoCloseable {
    public PlanePyramidSource newPlanePyramidSource(String var1, String var2, String var3) throws IOException;

    @Override
    default public void close() {
    }

    public static class Unsupported
    implements PlanePyramidSourceFactory {
        public static final Unsupported INSTANCE = new Unsupported();

        @Override
        public PlanePyramidSource newPlanePyramidSource(String pyramidPath, String pyramidConfiguration, String renderingConfiguration) {
            throw new UnsupportedOperationException("No suitable plane pyramid source factory for " + pyramidPath);
        }

        public String toString() {
            return "Unsupported (a factory that cannot create any plane pyramid source)";
        }
    }
}

