/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.maps.tiff;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonValue;
import java.io.IOError;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import net.algart.executors.api.Executor;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.modules.maps.tiff.AbstractTiffOperation;
import net.algart.json.Jsons;
import net.algart.matrices.tiff.TiffIFD;
import net.algart.matrices.tiff.TiffOpenMode;
import net.algart.matrices.tiff.TiffReader;

public final class TiffInfo
extends AbstractTiffOperation
implements ReadOnlyExecutionInput {
    public static final String OUTPUT_ALL_IFDS = "all_ifds";
    public static final String OUTPUT_PRETTY_ALL_IFDS = "pretty_all_ifds";
    private boolean tiffRequired = true;
    private int ifdIndex = 0;

    public TiffInfo() {
        this.useVisibleResultParameter();
        this.setDefaultOutputScalar(OUTPUT_PRETTY_ALL_IFDS);
        this.addOutputScalar("valid");
        this.addOutputScalar("number_of_images");
        this.addOutputScalar("ifd");
        this.addOutputScalar("pretty_ifd");
        this.addOutputScalar("file_size");
        this.addOutputScalar("file_size");
    }

    public boolean isTiffRequired() {
        return this.tiffRequired;
    }

    public TiffInfo setTiffRequired(boolean tiffRequired) {
        this.tiffRequired = tiffRequired;
        return this;
    }

    public int getIfdIndex() {
        return this.ifdIndex;
    }

    public TiffInfo setIfdIndex(int ifdIndex) {
        this.ifdIndex = TiffInfo.nonNegative((int)ifdIndex);
        return this;
    }

    public void process() {
        this.testTiff(this.completeFilePath());
    }

    public void testTiff(Path path) {
        this.getScalar("valid").setTo(false);
        try {
            if (this.skipIfMissingFileOrThrow(path)) {
                return;
            }
            try (TiffReader reader = new TiffReader(path, TiffOpenMode.ofRequireTiff((boolean)this.tiffRequired));){
                this.fillOutputFileInformation(path);
                TiffInfo.fillReadingOutputInformation((Executor)this, reader, this.ifdIndex);
                List ifds = reader.allIFDs();
                this.setOutputScalarIfNecessary(OUTPUT_ALL_IFDS, () -> Jsons.toPrettyString((JsonArray)TiffInfo.allIFDJson(ifds)));
                this.setOutputScalarIfNecessary(OUTPUT_PRETTY_ALL_IFDS, () -> TiffInfo.allIFDPrettyInfo(ifds));
            }
        }
        catch (IOException e) {
            this.getScalar("valid").setTo(false);
            if (this.tiffRequired) {
                throw new IOError(e);
            }
            LOG.log(System.Logger.Level.INFO, "IGNORING EXCEPTION while analysing TIFF information for " + String.valueOf(path) + ", IFD #" + this.ifdIndex + ":\n      " + String.valueOf(e));
            this.setOutputScalar("pretty_ifd", e.toString());
            this.setOutputScalar(OUTPUT_PRETTY_ALL_IFDS, e.toString());
        }
    }

    public static JsonArray allIFDJson(List<TiffIFD> allIFDs) {
        Objects.requireNonNull(allIFDs, "Null allIFDs");
        JsonArrayBuilder builder = Json.createArrayBuilder();
        for (TiffIFD ifd : allIFDs) {
            builder.add((JsonValue)Jsons.toJson((String)ifd.toString(TiffIFD.StringFormat.JSON)));
        }
        return builder.build();
    }

    public static String allIFDPrettyInfo(List<TiffIFD> allIFDs) {
        Objects.requireNonNull(allIFDs, "Null allIFDs");
        StringBuilder sb = new StringBuilder();
        int n = allIFDs.size();
        for (int k = 0; k < n; ++k) {
            if (k > 0) {
                sb.append("%n".formatted(new Object[0]));
            }
            sb.append(TiffInfo.ifdInfo(allIFDs.get(k), k, n));
        }
        return sb.toString();
    }

    public static String ifdInfo(TiffIFD ifd, int ifdIndex, int ifdCount) {
        Objects.requireNonNull(ifd, "Null IFD");
        return "IFD #%d/%d: %s%n".formatted(ifdIndex, ifdCount, ifd.toString(TiffIFD.StringFormat.DETAILED));
    }
}

