/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.maps.tiff;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import net.algart.executors.api.Executor;
import net.algart.executors.api.data.SScalar;
import net.algart.executors.modules.core.common.io.FileOperation;
import net.algart.executors.modules.maps.LongTimeOpeningMode;
import net.algart.matrices.tiff.TiffIFD;
import net.algart.matrices.tiff.TiffReader;
import net.algart.matrices.tiff.TiffWriter;
import net.algart.matrices.tiff.tiles.TiffWriteMap;

public abstract class AbstractTiffOperation
extends FileOperation {
    public static final String INPUT_CLOSE_FILE = "close_file";
    public static final String OUTPUT_VALID = "valid";
    public static final String OUTPUT_IFD_INDEX = "ifd_index";
    public static final String OUTPUT_NUMBER_OF_IMAGES = "number_of_images";
    public static final String OUTPUT_IMAGE_DIM_X = "image_dim_x";
    public static final String OUTPUT_IMAGE_DIM_Y = "image_dim_y";
    public static final String OUTPUT_IFD = "ifd";
    public static final String OUTPUT_PRETTY_IFD = "pretty_ifd";
    public static final String OUTPUT_FILE_SIZE = "file_size";
    public static final String OUTPUT_STORED_TILES_COUNT = "stored_tiles_count";
    public static final String OUTPUT_STORED_TILES_MEMORY = "stored_tiles_memory";
    public static final String OUTPUT_CLOSED = "closed";

    public AbstractTiffOperation() {
        this.addFileOperationPorts();
    }

    public static boolean needToClose(Executor executor, LongTimeOpeningMode openingMode) {
        Objects.requireNonNull(executor, "Null executor");
        Objects.requireNonNull(openingMode, "Null openingMode");
        if (openingMode.isCloseAfterExecute()) {
            return true;
        }
        SScalar scalar = executor.getInputScalar(INPUT_CLOSE_FILE, true);
        return scalar.toJavaLikeBoolean(false);
    }

    public static void fillReadingOutputInformation(Executor e, TiffReader reader, int ifdIndex) throws IOException {
        Objects.requireNonNull(e, "Null executor");
        Objects.requireNonNull(reader, "Null reader");
        e.setOutputScalar(OUTPUT_VALID, reader.isValidTiff());
        e.removeOutputData(OUTPUT_IMAGE_DIM_X);
        e.removeOutputData(OUTPUT_IMAGE_DIM_Y);
        e.removeOutputData(OUTPUT_FILE_SIZE);
        e.setOutputScalar(OUTPUT_IFD_INDEX, ifdIndex);
        List ifds = reader.allIFDs();
        e.setOutputScalar(OUTPUT_NUMBER_OF_IMAGES, ifds.size());
        if (ifdIndex < ifds.size()) {
            TiffIFD ifd = (TiffIFD)ifds.get(ifdIndex);
            e.setOutputScalar(OUTPUT_IMAGE_DIM_X, ifd.getImageDimX());
            e.setOutputScalar(OUTPUT_IMAGE_DIM_Y, ifd.getImageDimY());
            e.setOutputScalarIfNecessary(OUTPUT_IFD, () -> ifd.toString(TiffIFD.StringFormat.JSON));
            e.setOutputScalarIfNecessary(OUTPUT_PRETTY_IFD, () -> ifd.toString(TiffIFD.StringFormat.DETAILED));
        }
        e.setOutputScalar(OUTPUT_FILE_SIZE, reader.fileLength());
    }

    public static void fillWritingOutputInformation(Executor e, TiffWriteMap map) throws IOException {
        TiffWriter writer = map.owner();
        Objects.requireNonNull(e, "Null executor");
        Objects.requireNonNull(map, "Null map");
        e.setOutputScalar(OUTPUT_NUMBER_OF_IMAGES, writer.numberOfExistingImages());
        e.setOutputScalar(OUTPUT_IMAGE_DIM_X, map.dimX());
        e.setOutputScalar(OUTPUT_IMAGE_DIM_Y, map.dimY());
        e.setOutputScalarIfNecessary(OUTPUT_IFD, () -> map.ifd().toString(TiffIFD.StringFormat.JSON));
        e.setOutputScalarIfNecessary(OUTPUT_PRETTY_IFD, () -> map.ifd().toString(TiffIFD.StringFormat.DETAILED));
        e.setOutputScalar(OUTPUT_FILE_SIZE, writer.fileLength());
        if (e.isOutputNecessary(OUTPUT_STORED_TILES_COUNT) || e.isOutputNecessary(OUTPUT_STORED_TILES_MEMORY)) {
            long count = map.tiles().stream().filter(t -> !t.isEmpty()).count();
            e.getScalar(OUTPUT_STORED_TILES_COUNT).setTo(count);
            e.getScalar(OUTPUT_STORED_TILES_MEMORY).setTo(count * (long)map.tileSizeInBytes());
        }
    }
}

