/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.maps.pyramids.io;

import java.io.IOError;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SMat;
import net.algart.executors.api.data.SScalar;
import net.algart.executors.modules.maps.LongTimeOpeningMode;
import net.algart.executors.modules.maps.pyramids.io.AbstractImagePyramidOperation;
import net.algart.executors.modules.maps.pyramids.io.DiagonalDirectionOnMap;
import net.algart.executors.modules.maps.pyramids.io.GridEqualizer;
import net.algart.executors.modules.maps.pyramids.io.ImagePyramidLevelRois;
import net.algart.executors.modules.maps.pyramids.io.ImagePyramidMetadataJson;
import net.algart.executors.modules.maps.pyramids.io.ScanningMapSequence;
import net.algart.maps.pyramids.io.api.PlanePyramidSource;
import net.algart.math.IPoint;
import net.algart.math.IRectangularArea;
import net.algart.multimatrix.MultiMatrix;
import net.algart.multimatrix.MultiMatrix2D;

public final class ReadImagePyramid
extends AbstractImagePyramidOperation
implements ReadOnlyExecutionInput {
    public static final String INPUT_FILE_LIST = "file_list";
    public static final String OUTPUT_DIM_X = "dim_x";
    public static final String OUTPUT_DIM_Y = "dim_y";
    public static final String OUTPUT_NUMBER_OF_PYRAMIDS = "number_of_pyramids";
    public static final String OUTPUT_RECTANGLE = "rectangle";
    public static final String OUTPUT_RECOMMENDED_EXPANSION = "recommended_expansion";
    public static final String OUTPUT_CURRENT_PYRAMID_INDEX = "current_pyramid_index";
    public static final String OUTPUT_CURRENT_ROI_INDEX = "current_roi_index";
    public static final String OUTPUT_CURRENT_X_INDEX = "current_x_index";
    public static final String OUTPUT_CURRENT_Y_INDEX = "current_y_index";
    public static final String OUTPUT_CURRENT_FRAME_INDEX = "current_frame_index";
    public static final String OUTPUT_CURRENT_METADATA_ROI_CONTOURS = "current_metadata_roi_contours";
    public static final String OUTPUT_FIRST_IN_ROI = "first_in_roi";
    public static final String OUTPUT_LAST_IN_ROI = "last_in_roi";
    public static final String OUTPUT_FIRST_IN_PYRAMID = "first_in_pyramid";
    public static final String OUTPUT_LAST_IN_PYRAMID = "last_in_pyramid";
    public static final String OUTPUT_LAST = "last";
    public static final String OUTPUT_CLOSED = "closed";
    private LongTimeOpeningMode openingMode = LongTimeOpeningMode.OPEN_ON_RESET_AND_FIRST_CALL;
    private boolean closeAfterLast = true;
    private boolean wholeROI = false;
    private long startX = 0L;
    private long startY = 0L;
    private long sizeX = 1L;
    private long sizeY = 1L;
    private SizeUnit sizeUnit = SizeUnit.PIXEL;
    private boolean equalizeGrid = false;
    private PlanePyramidSource.SpecialImageKind specialImageKind = PlanePyramidSource.SpecialImageKind.NONE;
    private volatile List<Path> fileList = null;
    private volatile boolean fileListSpecified = false;
    private int currentFileIndex = 0;
    private volatile PlanePyramidSource planePyramidSource = null;
    private volatile MultiMatrix2D specialMatrix = null;
    private volatile ImagePyramidLevelRois selectedLevelRois = null;
    private volatile boolean pyramidOpened = false;
    private volatile List<IRectangularArea> roiRectangles = null;
    private volatile long currentFrameIndex = 0L;
    private volatile long currentFrameLowIndex = 0L;
    private volatile long currentFrameHighIndex = 0L;
    private volatile int currentRoiIndex = 0;
    private volatile boolean firstInRoi = false;
    private volatile boolean lastInRoi = false;
    private volatile boolean firstInPyramid = false;
    private volatile boolean lastInPyramid = false;
    private volatile boolean last = false;
    private volatile int selectedResolutionLevel;
    private volatile AbstractImagePyramidOperation.ScanningSequence selectedScanningSequence;
    private volatile boolean selectedWholeROI;
    private volatile long selectedSizeX;
    private volatile long selectedSizeY;
    private final Object lock = new Object();

    public ReadImagePyramid() {
        this.useVisibleResultParameter();
        this.addInputMat(DEFAULT_INPUT_PORT);
        this.addInputScalar(INPUT_FILE_LIST);
        this.addOutputMat(DEFAULT_OUTPUT_PORT);
        this.addOutputMat("special_image");
        this.addOutputScalar("number_of_levels");
        this.addOutputScalar("level_dim_x");
        this.addOutputScalar("level_dim_y");
        this.addOutputScalar(OUTPUT_DIM_X);
        this.addOutputScalar(OUTPUT_DIM_Y);
        this.addOutputNumbers(OUTPUT_RECTANGLE);
        this.addOutputScalar(OUTPUT_NUMBER_OF_PYRAMIDS);
        this.addOutputScalar("number_of_frames");
        this.addOutputScalar("frames_per_series");
        this.addOutputScalar(OUTPUT_RECOMMENDED_EXPANSION);
        this.addOutputScalar("recommended_number_of_frames_in_buffer");
        this.addOutputScalar("builtin_metadata");
        this.addOutputScalar("metadata");
        this.addOutputNumbers("metadata_roi_rectangles");
        this.addOutputNumbers("metadata_roi_contours");
        this.addOutputScalar(OUTPUT_CURRENT_PYRAMID_INDEX);
        this.addOutputScalar(OUTPUT_CURRENT_ROI_INDEX);
        this.addOutputScalar(OUTPUT_CURRENT_X_INDEX);
        this.addOutputScalar(OUTPUT_CURRENT_Y_INDEX);
        this.addOutputScalar(OUTPUT_CURRENT_FRAME_INDEX);
        this.addOutputNumbers(OUTPUT_CURRENT_METADATA_ROI_CONTOURS);
        this.addOutputScalar(OUTPUT_FIRST_IN_ROI);
        this.addOutputScalar(OUTPUT_LAST_IN_ROI);
        this.addOutputScalar(OUTPUT_FIRST_IN_PYRAMID);
        this.addOutputScalar(OUTPUT_LAST_IN_PYRAMID);
        this.addOutputScalar(OUTPUT_LAST);
        this.addOutputScalar(OUTPUT_CLOSED);
    }

    public LongTimeOpeningMode getOpeningMode() {
        return this.openingMode;
    }

    public ReadImagePyramid setOpeningMode(LongTimeOpeningMode openingMode) {
        this.openingMode = (LongTimeOpeningMode)((Object)ReadImagePyramid.nonNull((Object)((Object)openingMode)));
        return this;
    }

    public boolean isCloseAfterLast() {
        return this.closeAfterLast;
    }

    public ReadImagePyramid setCloseAfterLast(boolean closeAfterLast) {
        this.closeAfterLast = closeAfterLast;
        return this;
    }

    public boolean isWholeROI() {
        return this.wholeROI;
    }

    public ReadImagePyramid setWholeROI(boolean wholeROI) {
        this.wholeROI = wholeROI;
        return this;
    }

    public long getStartX() {
        return this.startX;
    }

    public ReadImagePyramid setStartX(long startX) {
        this.startX = startX;
        return this;
    }

    public long getStartY() {
        return this.startY;
    }

    public ReadImagePyramid setStartY(long startY) {
        this.startY = startY;
        return this;
    }

    public long getSizeX() {
        return this.sizeX;
    }

    public ReadImagePyramid setSizeX(long sizeX) {
        this.sizeX = ReadImagePyramid.nonNegative((long)sizeX);
        return this;
    }

    public long getSizeY() {
        return this.sizeY;
    }

    public ReadImagePyramid setSizeY(long sizeY) {
        this.sizeY = ReadImagePyramid.nonNegative((long)sizeY);
        return this;
    }

    public SizeUnit getSizeUnit() {
        return this.sizeUnit;
    }

    public ReadImagePyramid setSizeUnit(SizeUnit sizeUnit) {
        this.sizeUnit = (SizeUnit)((Object)ReadImagePyramid.nonNull((Object)((Object)sizeUnit)));
        return this;
    }

    public SizeUnit sizeUnit() {
        SizeUnit result = this.sizeUnit;
        if (this.planePyramidSource == null) {
            throw new IllegalStateException("Cannot use size unit: plane pyramid source is not initialized");
        }
        if (result == SizeUnit.PIXEL_OF_SPECIAL_IMAGE && this.specialMatrix == null) {
            throw new IllegalArgumentException("No requested special image, so we cannot use size unit, based on its pixels");
        }
        return result;
    }

    public boolean isEqualizeGrid() {
        return this.equalizeGrid;
    }

    public ReadImagePyramid setEqualizeGrid(boolean equalizeGrid) {
        this.equalizeGrid = equalizeGrid;
        return this;
    }

    public PlanePyramidSource.SpecialImageKind getSpecialImageKind() {
        return this.specialImageKind;
    }

    public ReadImagePyramid setSpecialImageKind(PlanePyramidSource.SpecialImageKind specialImageKind) {
        this.specialImageKind = (PlanePyramidSource.SpecialImageKind)((Object)ReadImagePyramid.nonNull((Object)((Object)specialImageKind)));
        return this;
    }

    public void initialize() {
        if (this.openingMode.isClosePreviousOnReset()) {
            this.closePyramid(false);
        }
        this.clearFileList();
    }

    public void process() {
        SMat input = this.getInputMat(this.defaultInputPortName(), true);
        if (input.isInitialized()) {
            ReadImagePyramid.logDebug(() -> "Copying " + String.valueOf(input));
            this.getMat().setTo(input);
        } else {
            this.initializeFileList();
            MultiMatrix multiMatrix = this.readNextPyramid(this.isOutputNecessary(DEFAULT_OUTPUT_PORT));
            if (multiMatrix != null) {
                this.getMat().setTo(multiMatrix);
            } else {
                this.getMat().remove();
            }
        }
    }

    public void clearFileList() {
        this.fileList = null;
        this.currentFileIndex = 0;
    }

    public void initializeFileList() {
        if (this.fileList == null) {
            String inputFileList = this.getInputScalar(INPUT_FILE_LIST, true).getValue();
            boolean bl = this.fileListSpecified = inputFileList != null;
            if (inputFileList != null) {
                List lines = SScalar.splitJsonOrTrimmedLines((String)inputFileList);
                if (lines.isEmpty()) {
                    throw new IllegalArgumentException("Empty file list is passed");
                }
                this.fileList = lines.stream().map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
            } else {
                this.fileList = List.of(this.completeFilePath());
            }
            this.currentFileIndex = 0;
        }
    }

    public MultiMatrix readNextPyramid(boolean doActualReading) {
        int n = this.fileList.size();
        assert (this.currentFileIndex < n) : "invalid index in file list: " + this.currentFileIndex + " >= " + n;
        MultiMatrix result = this.readPyramid(this.fileList.get(this.currentFileIndex), doActualReading);
        this.getScalar(OUTPUT_NUMBER_OF_PYRAMIDS).setTo(n);
        this.getScalar(OUTPUT_CURRENT_PYRAMID_INDEX).setTo(this.currentFileIndex);
        if (this.fileListSpecified && this.lastInPyramid) {
            ++this.currentFileIndex;
            boolean bl = this.last = this.currentFileIndex >= n;
            if (this.last) {
                this.currentFileIndex = 0;
            }
            this.getScalar(OUTPUT_LAST).setTo(this.last);
        }
        return result;
    }

    public MultiMatrix readPyramid(Path path) {
        return this.readPyramid(path, true);
    }

    public MultiMatrix readPyramid(Path path, boolean doActualReading) {
        if (this.openingMode.isClosePreviousOnExecute()) {
            this.closePyramid(false);
        }
        try {
            boolean close;
            DiagonalDirectionOnMap recommendedFrameExpansion;
            ScanningMapSequence mapSequence;
            this.openPyramid(path);
            this.checkSelectedGeometry();
            boolean wholeROI = this.selectedWholeROI;
            long sizeX = this.selectedSizeX;
            long sizeY = this.selectedSizeY;
            if (!wholeROI) {
                this.checkFrameSize(sizeX, sizeY);
            }
            ScanningMapSequence scanningMapSequence = mapSequence = wholeROI ? null : this.selectedScanningSequence.mapSequence(this.selectedLevelRois);
            if (mapSequence != null && this.roiRectangles.isEmpty()) {
                int m = this.getMinimalAnalyzedSize();
                throw new IllegalStateException("There are no " + (String)(m == 0 ? "non-empty ROIs" : "ROIs greater than " + m + "x" + m) + " at level " + this.selectedResolutionLevel + " (" + this.selectedLevelRois.levelDimX() + "x" + this.selectedLevelRois.levelDimY() + ") of the pyramid " + String.valueOf(path));
            }
            IRectangularArea actualRoi = mapSequence != null ? this.roiRectangles.get(this.currentRoiIndex) : this.selectedLevelRois.inputRoiOrWholeLevel();
            IRectangularArea area = this.findAreaToRead(mapSequence, actualRoi);
            MultiMatrix result = doActualReading ? ReadImagePyramid.readSource(this.planePyramidSource, this.selectedResolutionLevel, area) : null;
            this.getScalar(OUTPUT_DIM_X).setTo(result == null ? 0L : result.dim(0));
            this.getScalar(OUTPUT_DIM_Y).setTo(result == null ? 0L : result.dim(1));
            if (this.specialMatrix != null) {
                this.getMat("special_image").setTo((MultiMatrix)this.specialMatrix);
            } else {
                this.getMat("special_image").remove();
            }
            this.getScalar("number_of_frames").setTo(this.selectedLevelRois.totalNumberOfFrames(sizeX, sizeY, wholeROI));
            this.getNumbers(OUTPUT_RECTANGLE).setTo(area);
            long framesPerSeries = this.selectedLevelRois.framesPerSeries(mapSequence, sizeX, sizeY, wholeROI);
            if (mapSequence != null) {
                long roiDimX = actualRoi.sizeX();
                long roiDimY = actualRoi.sizeY();
                recommendedFrameExpansion = mapSequence.recommendedFrameExpansion(this.currentFrameLowIndex, this.currentFrameHighIndex, sizeX, sizeY, roiDimX, roiDimY);
                this.getScalar(OUTPUT_CURRENT_ROI_INDEX).setTo(this.currentRoiIndex);
                this.getScalar(OUTPUT_CURRENT_X_INDEX).setTo(mapSequence.xFrameIndex(this.currentFrameLowIndex, this.currentFrameHighIndex, sizeX, sizeY, roiDimX, roiDimY));
                this.getScalar(OUTPUT_CURRENT_Y_INDEX).setTo(mapSequence.yFrameIndex(this.currentFrameLowIndex, this.currentFrameHighIndex, sizeX, sizeY, roiDimX, roiDimY));
                this.getScalar(OUTPUT_CURRENT_FRAME_INDEX).setTo(this.currentFrameIndex);
                if (this.isOutputNecessary(OUTPUT_CURRENT_METADATA_ROI_CONTOURS)) {
                    this.getNumbers(OUTPUT_CURRENT_METADATA_ROI_CONTOURS).setTo(this.selectedLevelRois.roiContours(this.currentRoiIndex));
                }
                this.getScalar("frames_per_series").setTo(framesPerSeries);
                this.firstInRoi = this.currentFrameLowIndex == 0L && this.currentFrameHighIndex == 0L;
                this.firstInPyramid = this.firstInRoi && this.currentRoiIndex == 0;
                this.nextSequentialIndex(mapSequence, sizeX, sizeY, roiDimX, roiDimY);
                this.lastInRoi = this.currentFrameLowIndex == 0L && this.currentFrameHighIndex == 0L;
                this.last = this.lastInPyramid = this.lastInRoi && this.currentRoiIndex == 0;
            } else {
                recommendedFrameExpansion = DiagonalDirectionOnMap.LEFT_UP;
                this.lastInRoi = true;
                this.firstInRoi = true;
                this.lastInPyramid = true;
                this.firstInPyramid = true;
                this.last = area.maxX() >= this.selectedLevelRois.inputMaxX() && area.maxY() >= this.selectedLevelRois.inputMaxY();
            }
            this.getScalar(OUTPUT_RECOMMENDED_EXPANSION).setTo((Object)recommendedFrameExpansion);
            this.fillOutputNumberOfStoredFrames(framesPerSeries, wholeROI);
            this.getScalar(OUTPUT_FIRST_IN_ROI).setTo(this.firstInRoi);
            this.getScalar(OUTPUT_LAST_IN_ROI).setTo(this.lastInRoi);
            this.getScalar(OUTPUT_FIRST_IN_PYRAMID).setTo(this.firstInPyramid);
            this.getScalar(OUTPUT_LAST_IN_PYRAMID).setTo(this.lastInPyramid);
            this.getScalar(OUTPUT_LAST).setTo(this.last);
            boolean bl = close = this.openingMode.isCloseAfterExecute() || this.lastInPyramid && this.closeAfterLast;
            if (close) {
                this.closePyramid(false);
            }
            this.getScalar(OUTPUT_CLOSED).setTo(close);
            return result;
        }
        catch (IOError | RuntimeException e) {
            this.closePyramid(true);
            this.closeSourceFactory();
            throw e;
        }
    }

    public long pixelStartX() {
        return this.sizeUnit().scaleX(this, this.startX, false);
    }

    public long pixelStartY() {
        return this.sizeUnit().scaleY(this, this.startY, false);
    }

    public long pixelSizeX() {
        return this.sizeUnit().scaleX(this, this.sizeX, true);
    }

    public long pixelSizeY() {
        return this.sizeUnit().scaleY(this, this.sizeY, true);
    }

    public boolean isFirstInRoi() {
        return this.firstInRoi;
    }

    public boolean isLastInRoi() {
        return this.lastInRoi;
    }

    public boolean isFirstInPyramid() {
        return this.firstInPyramid;
    }

    public boolean isLastInPyramid() {
        return this.lastInPyramid;
    }

    public boolean isLast() {
        return this.last;
    }

    @Override
    public void close() {
        super.close();
        this.closePyramid(true);
    }

    public void openPyramid(Path path) {
        Objects.requireNonNull(path, "Null path");
        if (!this.pyramidOpened) {
            try {
                ReadImagePyramid.logDebug(() -> "Opening " + String.valueOf(path));
                this.pyramidOpened = true;
                this.planePyramidSource = this.newPlanePyramidSource(path);
                this.specialMatrix = ReadImagePyramid.readSpecialMatrix(this.planePyramidSource, this.specialImageKind);
                ImagePyramidMetadataJson metadataJson = this.readMetadataOrNull(path);
                this.selectGeometry();
                this.selectedLevelRois = this.newLevelRois(this.planePyramidSource, metadataJson);
                this.roiRectangles = this.selectedLevelRois.roiRectangles();
                this.currentFrameIndex = 0L;
                this.currentFrameHighIndex = 0L;
                this.currentFrameLowIndex = 0L;
                this.currentRoiIndex = 0;
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }
        this.fillOutputFileInformation(path);
        this.fillOutputInformation(this.planePyramidSource, this.selectedLevelRois);
    }

    private void closePyramid(boolean longTermResources) {
        boolean pyramidOpened = this.pyramidOpened;
        PlanePyramidSource planePyramidSource = this.planePyramidSource;
        if (pyramidOpened || longTermResources) {
            if (planePyramidSource != null) {
                if (longTermResources) {
                    ReadImagePyramid.logInfo(() -> "Closing " + String.valueOf(planePyramidSource) + " (also long-term resources)");
                    planePyramidSource.freeResources(PlanePyramidSource.FlushMode.FLUSH_LONG_TERM_RESOURCES);
                } else {
                    ReadImagePyramid.logDebug(() -> "Closing " + String.valueOf(planePyramidSource));
                    planePyramidSource.freeResources(PlanePyramidSource.FlushMode.STANDARD);
                }
            }
            this.selectedLevelRois = null;
            this.pyramidOpened = false;
        }
    }

    private void selectGeometry() {
        if (this.resolutionLevel >= this.planePyramidSource.numberOfResolutions()) {
            throw new IllegalArgumentException("Too big index of resolution level " + this.resolutionLevel + ": there are only " + this.planePyramidSource.numberOfResolutions() + " resolutions");
        }
        if (!(this.wholeROI || this.sizeX != 0L && this.sizeY != 0L)) {
            throw new IllegalStateException("Zero " + (this.sizeX == 0L ? "x" : "y") + "-size (zero values are allowed only if the flag \"Read whole ROI\" is set)");
        }
        this.selectedResolutionLevel = this.resolutionLevel;
        this.selectedScanningSequence = this.getScanningSequence();
        this.selectedWholeROI = this.wholeROI;
        this.selectedSizeX = this.pixelSizeX();
        this.selectedSizeY = this.pixelSizeY();
    }

    private void checkSelectedGeometry() {
        if (this.resolutionLevel != this.selectedResolutionLevel) {
            throw new IllegalStateException("Illegal change of resolution level: " + this.resolutionLevel + " != " + this.selectedResolutionLevel + " (it must NOT be changed before closing current pyramid)");
        }
        if (this.getScanningSequence() != this.selectedScanningSequence) {
            throw new IllegalStateException("Illegal change of scanning sequence: " + String.valueOf((Object)this.getScanningSequence()) + " != " + String.valueOf((Object)this.selectedScanningSequence) + " (it must NOT be changed before closing current pyramid)");
        }
        if (this.pixelSizeX() != this.selectedSizeX || this.pixelSizeY() != this.selectedSizeY) {
            throw new IllegalStateException("Illegal change of frame size: " + this.pixelSizeX() + "x" + this.pixelSizeY() + " != " + this.selectedSizeX + "x" + this.selectedSizeY + " (it must NOT be changed before closing current pyramid)");
        }
        if (this.wholeROI != this.selectedWholeROI) {
            throw new IllegalStateException("Illegal change of read-whole-ROI flag: " + this.wholeROI + " != " + this.selectedWholeROI + " (it must NOT be changed before closing current pyramid)");
        }
    }

    private IRectangularArea findAreaToRead(ScanningMapSequence mapSequence, IRectangularArea actualRoi) {
        IRectangularArea area;
        if (this.wholeROI) {
            assert (mapSequence == null);
            return this.selectedLevelRois.inputRoiOrWholeLevel();
        }
        long sizeX = this.selectedSizeX;
        long sizeY = this.selectedSizeY;
        assert (sizeX > 0L);
        assert (sizeY > 0L);
        if (mapSequence != null) {
            sizeX = Math.min(sizeX, actualRoi.sizeX());
            sizeY = Math.min(sizeY, actualRoi.sizeY());
            if (this.equalizeGrid) {
                sizeX = GridEqualizer.equalizeGrid(actualRoi.sizeX(), sizeX);
                sizeY = GridEqualizer.equalizeGrid(actualRoi.sizeY(), sizeY);
            }
            IPoint start = mapSequence.framePosition(this.currentFrameLowIndex, this.currentFrameHighIndex, sizeX, sizeY, actualRoi.sizeX(), actualRoi.sizeY()).addExact(actualRoi.min());
            long endX = Math.min(start.x() + sizeX - 1L, actualRoi.maxX());
            long endY = Math.min(start.y() + sizeY - 1L, actualRoi.maxY());
            if (endX < start.x() || endY < start.y()) {
                throw new AssertionError((Object)("Empty area to read " + String.valueOf(start) + "..(" + endX + ", " + endY + ") inside " + String.valueOf(actualRoi)));
            }
            area = IRectangularArea.of((long)start.x(), (long)start.y(), (long)endX, (long)endY);
        } else {
            long startX = this.pixelStartX();
            long startY = this.pixelStartY();
            area = IRectangularArea.of((long)startX, (long)startY, (long)(startX + sizeX - 1L), (long)(startY + sizeY - 1L));
        }
        IRectangularArea result = area.intersection(this.selectedLevelRois.wholeLevel());
        if (result == null) {
            throw new IllegalArgumentException("Empty area cannot be read from pyramid: " + String.valueOf(area) + " is fully outside the pyramid layer " + String.valueOf(this.selectedLevelRois.wholeLevel()));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nextSequentialIndex(ScanningMapSequence mapSequence, long sizeX, long sizeY, long roiDimX, long roiDimY) {
        assert (mapSequence != null);
        long lowFrameCount = mapSequence.lowFrameCount(sizeX, sizeY, roiDimX, roiDimY);
        long highFrameCount = mapSequence.highFrameCount(sizeX, sizeY, roiDimX, roiDimY);
        Object object = this.lock;
        synchronized (object) {
            ++this.currentFrameIndex;
            ++this.currentFrameLowIndex;
            if (this.currentFrameLowIndex >= lowFrameCount) {
                this.currentFrameLowIndex = 0L;
                ++this.currentFrameHighIndex;
                if (this.currentFrameHighIndex >= highFrameCount) {
                    this.currentFrameHighIndex = 0L;
                    ++this.currentRoiIndex;
                    if (this.currentRoiIndex >= this.roiRectangles.size()) {
                        this.currentRoiIndex = 0;
                        this.currentFrameIndex = 0L;
                    }
                }
            }
        }
    }

    public static enum SizeUnit {
        PIXEL{

            @Override
            long scaleX(ReadImagePyramid e, long x, boolean forSize) {
                return x;
            }

            @Override
            long scaleY(ReadImagePyramid e, long y, boolean forSize) {
                return y;
            }
        }
        ,
        PIXEL_OF_SPECIAL_IMAGE{

            @Override
            long scaleX(ReadImagePyramid e, long x, boolean forSize) {
                x = Math.round((double)x / (double)(e.specialMatrix.dimX() - 1L) * (double)(e.planePyramidSource.width(e.resolutionLevel) - 1L));
                return forSize ? Math.max(x, 1L) : x;
            }

            @Override
            long scaleY(ReadImagePyramid e, long y, boolean forSize) {
                y = Math.round((double)y / (double)(e.specialMatrix.dimY() - 1L) * (double)(e.planePyramidSource.height(e.resolutionLevel) - 1L));
                return forSize ? Math.max(y, 1L) : y;
            }
        };


        abstract long scaleX(ReadImagePyramid var1, long var2, boolean var4);

        abstract long scaleY(ReadImagePyramid var1, long var2, boolean var4);
    }
}

