/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.maps.pyramids.io;

import jakarta.json.Json;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.script.ScriptEngine;
import net.algart.arrays.Arrays;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.executors.api.Executor;
import net.algart.executors.api.graalvm.js.scriptengine.JavaScriptContextContainer;
import net.algart.executors.modules.core.common.io.FileOperation;
import net.algart.executors.modules.maps.pyramids.io.ImagePyramidFormatKind;
import net.algart.executors.modules.maps.pyramids.io.ImagePyramidLevelRois;
import net.algart.executors.modules.maps.pyramids.io.ImagePyramidMetadataJson;
import net.algart.executors.modules.maps.pyramids.io.ScanningMapSequence;
import net.algart.executors.modules.maps.pyramids.io.SimpleFormula;
import net.algart.io.MatrixIO;
import net.algart.maps.pyramids.io.api.PlanePyramidSource;
import net.algart.maps.pyramids.io.api.PlanePyramidSourceFactory;
import net.algart.math.IRectangularArea;
import net.algart.multimatrix.MultiMatrix;
import net.algart.multimatrix.MultiMatrix2D;

public abstract class AbstractImagePyramidOperation
extends FileOperation {
    public static final String INPUT_PYRAMID_CONFIGURATION = "pyramid_configuration";
    public static final String INPUT_RENDERING_CONFIGURATION = "rendering_configuration";
    public static final String INPUT_ROI = "roi";
    public static final String OUTPUT_SPECIAL_IMAGE = "special_image";
    public static final String OUTPUT_NUMBER_OF_LEVELS = "number_of_levels";
    public static final String OUTPUT_LEVEL_DIM_X = "level_dim_x";
    public static final String OUTPUT_LEVEL_DIM_Y = "level_dim_y";
    public static final String OUTPUT_NUMBER_OF_FRAMES = "number_of_frames";
    public static final String OUTPUT_FRAMES_PER_SERIES = "frames_per_series";
    public static final String OUTPUT_RECOMMENDED_NUMBER_OF_FRAMES_IN_BUFFER = "recommended_number_of_frames_in_buffer";
    public static final String OUTPUT_BUILTIN_METADATA = "builtin_metadata";
    public static final String OUTPUT_METADATA = "metadata";
    public static final String OUTPUT_METADATA_ROI_RECTANGLES = "metadata_roi_rectangles";
    public static final String OUTPUT_METADATA_ROI_CONTOURS = "metadata_roi_contours";
    public static final String METADATA_FILE_SUFFIX = ".meta";
    private ImagePyramidFormatKind planePyramidFormat = ImagePyramidFormatKind.AUTO_DETECT_BY_EXTENSION;
    private String customPlanePyramidSourceFactoryClass = "";
    int resolutionLevel = 0;
    private ScanningSequence scanningSequence = ScanningSequence.NONE;
    private SimpleFormula recommendedNumberOfStoredFrames;
    private String recommendedNumberOfStoredFramesP = "";
    private boolean useMetadata = true;
    private boolean useInputROI = true;
    private boolean nonIntersectingRectanglesRequired = false;
    private int minimalAnalyzedSize = 0;
    private final ScriptEngine context;
    private PlanePyramidSourceFactory sourceFactory = PlanePyramidSourceFactory.Unsupported.INSTANCE;
    private final Object lock = new Object();

    public AbstractImagePyramidOperation() {
        this.addFileOperationPorts();
        this.addInputScalar(INPUT_PYRAMID_CONFIGURATION);
        this.addInputScalar(INPUT_RENDERING_CONFIGURATION);
        this.addInputNumbers(INPUT_ROI);
        this.context = JavaScriptContextContainer.getInstance().getLocalContext();
        this.recommendedNumberOfStoredFrames = new SimpleFormula(this.context, "1");
    }

    public final ImagePyramidFormatKind getPlanePyramidFormat() {
        return this.planePyramidFormat;
    }

    public final AbstractImagePyramidOperation setPlanePyramidFormat(ImagePyramidFormatKind planePyramidFormat) {
        this.planePyramidFormat = (ImagePyramidFormatKind)((Object)AbstractImagePyramidOperation.nonNull((Object)((Object)planePyramidFormat)));
        return this;
    }

    public final String getCustomPlanePyramidSourceFactoryClass() {
        return this.customPlanePyramidSourceFactoryClass;
    }

    public final AbstractImagePyramidOperation setCustomPlanePyramidSourceFactoryClass(String customPlanePyramidSourceFactoryClass) {
        this.customPlanePyramidSourceFactoryClass = (String)AbstractImagePyramidOperation.nonNull((Object)customPlanePyramidSourceFactoryClass);
        return this;
    }

    public final int getResolutionLevel() {
        return this.resolutionLevel;
    }

    public final AbstractImagePyramidOperation setResolutionLevel(int resolutionLevel) {
        this.resolutionLevel = AbstractImagePyramidOperation.nonNegative((int)resolutionLevel);
        return this;
    }

    public final ScanningSequence getScanningSequence() {
        return this.scanningSequence;
    }

    public final AbstractImagePyramidOperation setScanningSequence(ScanningSequence scanningSequence) {
        this.scanningSequence = (ScanningSequence)((Object)AbstractImagePyramidOperation.nonNull((Object)((Object)scanningSequence)));
        return this;
    }

    public final String getRecommendedNumberOfStoredFrames() {
        return this.recommendedNumberOfStoredFrames.formula();
    }

    public final AbstractImagePyramidOperation setRecommendedNumberOfStoredFrames(String recommendedNumberOfStoredFrames) {
        this.recommendedNumberOfStoredFrames = new SimpleFormula(this.context, AbstractImagePyramidOperation.nonEmpty((String)recommendedNumberOfStoredFrames));
        return this;
    }

    public final String getRecommendedNumberOfStoredFramesP() {
        return this.recommendedNumberOfStoredFramesP;
    }

    public final AbstractImagePyramidOperation setRecommendedNumberOfStoredFramesP(String recommendedNumberOfStoredFramesP) {
        this.recommendedNumberOfStoredFramesP = (String)AbstractImagePyramidOperation.nonNull((Object)recommendedNumberOfStoredFramesP);
        return this;
    }

    public final boolean isUseMetadata() {
        return this.useMetadata;
    }

    public final AbstractImagePyramidOperation setUseMetadata(boolean useMetadata) {
        this.useMetadata = useMetadata;
        return this;
    }

    public final boolean isUseInputROI() {
        return this.useInputROI;
    }

    public final AbstractImagePyramidOperation setUseInputROI(boolean useInputROI) {
        this.useInputROI = useInputROI;
        return this;
    }

    public final boolean isNonIntersectingRectanglesRequired() {
        return this.nonIntersectingRectanglesRequired;
    }

    public final AbstractImagePyramidOperation setNonIntersectingRectanglesRequired(boolean nonIntersectingRectanglesRequired) {
        this.nonIntersectingRectanglesRequired = nonIntersectingRectanglesRequired;
        return this;
    }

    public int getMinimalAnalyzedSize() {
        return this.minimalAnalyzedSize;
    }

    public AbstractImagePyramidOperation setMinimalAnalyzedSize(int minimalAnalyzedSize) {
        this.minimalAnalyzedSize = AbstractImagePyramidOperation.nonNegative((int)minimalAnalyzedSize);
        return this;
    }

    public void close() {
        super.close();
        this.closeSourceFactory();
    }

    public static MultiMatrix readSource(PlanePyramidSource source, int resolutionLevel, IRectangularArea area) {
        long fromX = area.minX();
        long fromY = area.minY();
        long toX = area.maxX() + 1L;
        long toY = area.maxY() + 1L;
        Matrix<? extends PArray> matrix = source.readSubMatrix(resolutionLevel, fromX, fromY, toX, toY);
        return MultiMatrix.of2DRGBA((List)Matrices.separate(matrix));
    }

    public static MultiMatrix2D readSpecialMatrix(PlanePyramidSource planePyramidSource, PlanePyramidSource.SpecialImageKind specialImageKind) {
        Optional<Matrix<? extends PArray>> matrix = planePyramidSource.readSpecialMatrix(specialImageKind);
        return matrix.map(m -> MultiMatrix.of2DRGBA((List)Matrices.separate((Matrix)m))).orElse(null);
    }

    public ImagePyramidMetadataJson readMetadataOrNull(Path planePyramidPath) throws IOException {
        if (!this.useMetadata) {
            return null;
        }
        Path metadataFile = Paths.get(String.valueOf(planePyramidPath) + METADATA_FILE_SUFFIX, new String[0]);
        return Files.exists(metadataFile, new LinkOption[0]) ? ImagePyramidMetadataJson.read(metadataFile) : null;
    }

    public PlanePyramidSource newPlanePyramidSource(Path planePyramidPath) throws IOException {
        Objects.requireNonNull(planePyramidPath, "Null path");
        String emptyJson = Json.createObjectBuilder().build().toString();
        String pyramidConfiguration = this.getInputScalar(INPUT_PYRAMID_CONFIGURATION, true).getValueOrDefault(emptyJson);
        String rendererConfiguration = this.getInputScalar(INPUT_RENDERING_CONFIGURATION, true).getValueOrDefault(emptyJson);
        if (!Files.exists(planePyramidPath, new LinkOption[0])) {
            throw new FileNotFoundException("Pyramid file/folder \"" + String.valueOf(planePyramidPath) + "\" not found");
        }
        this.resetPlanePyramidSourceFactory(planePyramidPath);
        return this.sourceFactory.newPlanePyramidSource(planePyramidPath.toAbsolutePath().toString(), pyramidConfiguration, rendererConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resetPlanePyramidSourceFactory(Path path) {
        Object object = this.lock;
        synchronized (object) {
            Object newFactoryObject;
            ImagePyramidFormatKind format = this.planePyramidFormat;
            String result = this.customPlanePyramidSourceFactoryClass.trim();
            String className = AbstractImagePyramidOperation.sourceFactoryClassName(path, format, result);
            assert (className != null && !className.isEmpty()) : "empty result of planePyramidSourceFactoryClassName: " + className;
            if (className.equals(this.sourceFactory.getClass().getName())) {
                return;
            }
            try {
                newFactoryObject = Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Plane pyramid source factory class not found: " + className, e);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalArgumentException("Invalid plane pyramid source factory class " + className + ": " + e.getMessage(), e);
            }
            if (!(newFactoryObject instanceof PlanePyramidSourceFactory)) {
                throw new IllegalArgumentException("Class  " + className + " is not a plane pyramid source factory");
            }
            PlanePyramidSourceFactory newFactory = (PlanePyramidSourceFactory)newFactoryObject;
            this.closeSourceFactory();
            this.sourceFactory = newFactory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void closeSourceFactory() {
        Object object = this.lock;
        synchronized (object) {
            this.sourceFactory.close();
            this.sourceFactory = PlanePyramidSourceFactory.Unsupported.INSTANCE;
        }
    }

    public static String sourceFactoryClassName(Path path, ImagePyramidFormatKind format, String customClassName) {
        Objects.requireNonNull(path, "Null path");
        if (format.isAutoDetection()) {
            format = ImagePyramidFormatKind.ofExtension(MatrixIO.extension((String)path.toString(), null));
        }
        if (format.hasFactory()) {
            return format.getFactoryClassName();
        }
        if (customClassName.isEmpty()) {
            throw new IllegalArgumentException("Custom factory class must be specified");
        }
        return customClassName;
    }

    public ImagePyramidLevelRois newLevelRois(PlanePyramidSource source, ImagePyramidMetadataJson metadataJson) {
        return this.newLevelRois(source, this.getInputNumbers(INPUT_ROI, true).toIRectangularArea(), metadataJson);
    }

    public ImagePyramidLevelRois newLevelRois(PlanePyramidSource source, IRectangularArea inputRoi, ImagePyramidMetadataJson metadataJson) {
        Objects.requireNonNull(source, "Null source");
        return new ImagePyramidLevelRois(source, this.resolutionLevel).setMetadataJson(metadataJson).setInputRoi((IRectangularArea)(this.useInputROI ? inputRoi : null)).setNonIntersectingRectanglesRequired(this.nonIntersectingRectanglesRequired).setMinimalROISize(this.minimalAnalyzedSize);
    }

    public void checkFrameSize(long sizeX, long sizeY) {
        if (sizeX < (long)this.minimalAnalyzedSize || sizeY < (long)this.minimalAnalyzedSize) {
            throw new IllegalArgumentException("Frame sizes " + sizeX + "x" + sizeY + " are too small: they must not be less than the minimal analyzed size " + this.minimalAnalyzedSize + "x" + this.minimalAnalyzedSize);
        }
    }

    public int recommendedNumberOfStoredFrames(long numberOfFramesPerSeries) {
        this.recommendedNumberOfStoredFrames.putVariable("m", numberOfFramesPerSeries);
        this.recommendedNumberOfStoredFrames.putVariable("p", AbstractImagePyramidOperation.parseNumberIfPossible(this.recommendedNumberOfStoredFramesP));
        this.recommendedNumberOfStoredFrames.putVariable("snake", this.scanningSequence.snake());
        int result = Arrays.round32((double)this.recommendedNumberOfStoredFrames.evalDouble());
        if (result <= 0) {
            throw new IllegalArgumentException("Number of stored frames must be positive, but it is " + result);
        }
        return result;
    }

    public void fillOutputNumberOfStoredFrames(long numberOfFramesPerSeries, boolean singleFrameMode) {
        this.getScalar(OUTPUT_RECOMMENDED_NUMBER_OF_FRAMES_IN_BUFFER).setTo(singleFrameMode ? 1 : this.recommendedNumberOfStoredFrames(numberOfFramesPerSeries));
    }

    public void fillOutputInformation(PlanePyramidSource source, ImagePyramidLevelRois levelRois) {
        AbstractImagePyramidOperation.fillOutputInformation((Executor)this, source, levelRois);
    }

    public String translateLegacyParameterAlias(String name) {
        return name.equals("requireNonIntersectingRectangles") ? "nonIntersectingRectanglesRequired" : name;
    }

    public static void fillOutputInformation(Executor executor, PlanePyramidSource source, ImagePyramidLevelRois levelRois) {
        Objects.requireNonNull(executor, "Null executor");
        Objects.requireNonNull(levelRois, "Null levelRois");
        executor.setOutputScalar(OUTPUT_NUMBER_OF_LEVELS, levelRois.numberOfResolutions());
        executor.setOutputScalar(OUTPUT_LEVEL_DIM_X, levelRois.levelDimX());
        executor.setOutputScalar(OUTPUT_LEVEL_DIM_Y, levelRois.levelDimY());
        if (source != null && executor.isOutputNecessary(OUTPUT_BUILTIN_METADATA)) {
            executor.getScalar(OUTPUT_BUILTIN_METADATA).setTo(source.metadata());
        }
        ImagePyramidMetadataJson metadataJson = levelRois.metadataJson();
        executor.setOutputScalarIfNecessary(OUTPUT_METADATA, () -> metadataJson == null ? null : metadataJson.jsonString());
        if (executor.isOutputNecessary(OUTPUT_METADATA_ROI_RECTANGLES)) {
            executor.getNumbers(OUTPUT_METADATA_ROI_RECTANGLES).setToArray((Object)levelRois.allRoiCentersAndSizes(), 4);
        }
        if (executor.isOutputNecessary(OUTPUT_METADATA_ROI_CONTOURS)) {
            executor.getNumbers(OUTPUT_METADATA_ROI_CONTOURS).setTo(levelRois.allRoiContours());
        }
    }

    private static Object parseNumberIfPossible(String s) {
        try {
            return Integer.valueOf(s);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Double.valueOf(s);
            }
            catch (NumberFormatException numberFormatException2) {
                return s;
            }
        }
    }

    public static enum ScanningSequence {
        NONE(null, false),
        ROWS_LEFT_TO_RIGHT(ScanningMapSequence.ROWS_LEFT_TO_RIGHT, false),
        ROWS_BY_SNAKE(ScanningMapSequence.ROWS_BY_SNAKE, true),
        COLUMNS_TOP_TO_BOTTOM(ScanningMapSequence.COLUMNS_TOP_TO_BOTTOM, false),
        COLUMNS_BY_SNAKE(ScanningMapSequence.COLUMNS_BY_SNAKE, true),
        SHORTEST_SIDE(null, false){

            @Override
            public ScanningMapSequence mapSequence(long totalDimX, long totalDimY) {
                return totalDimX <= totalDimY ? ScanningMapSequence.ROWS_LEFT_TO_RIGHT : ScanningMapSequence.COLUMNS_TOP_TO_BOTTOM;
            }
        }
        ,
        SHORTEST_SIDE_BY_SNAKE(null, true){

            @Override
            public ScanningMapSequence mapSequence(long totalDimX, long totalDimY) {
                return totalDimX >= totalDimY ? ScanningMapSequence.ROWS_BY_SNAKE : ScanningMapSequence.COLUMNS_BY_SNAKE;
            }
        };

        private final ScanningMapSequence mapSequence;
        private final boolean snake;

        private ScanningSequence(ScanningMapSequence mapSequence, boolean snake) {
            this.mapSequence = mapSequence;
            this.snake = snake;
        }

        public ScanningMapSequence mapSequence(long totalDimX, long totalDimY) {
            return this.mapSequence;
        }

        public final ScanningMapSequence mapSequence(ImagePyramidLevelRois levelRois) {
            return this.mapSequence(levelRois.inputDimX(), levelRois.inputDimY());
        }

        public boolean isUsingSpecifiedCoordinates() {
            return this.mapSequence == null;
        }

        public boolean isUsingRoi() {
            return !this.isUsingSpecifiedCoordinates();
        }

        public boolean snake() {
            return this.snake;
        }
    }
}

