/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.maps.frames.joints;

import java.util.BitSet;
import java.util.Objects;
import java.util.stream.IntStream;
import net.algart.arrays.Array;
import net.algart.arrays.Arrays;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.MutableIntArray;
import net.algart.arrays.SimpleMemoryModel;
import net.algart.arrays.TooLargeArrayException;
import net.algart.executors.modules.maps.frames.buffers.FrameObjectStitcher;
import net.algart.executors.modules.maps.frames.buffers.MapBuffer;
import net.algart.executors.modules.maps.frames.joints.DynamicDisjointSet;
import net.algart.executors.modules.maps.frames.joints.QuickLabelsSet;
import net.algart.multimatrix.MultiMatrix;

public final class ObjectPairs {
    private static final int MAX_NUMBER_OF_PAIRS = 0x3FFFFFFF;
    private final MutableIntArray pairs = Arrays.SMM.newEmptyIntArray();
    private final DynamicDisjointSet dynamicDisjointSet = DynamicDisjointSet.newInstance();

    private ObjectPairs() {
    }

    public static ObjectPairs newInstance() {
        return new ObjectPairs();
    }

    public DynamicDisjointSet dynamicDisjointSet() {
        return this.dynamicDisjointSet;
    }

    public static ObjectPairs of(int[] pairsArray) {
        Objects.requireNonNull(pairsArray, "Null pairs array");
        if (pairsArray.length % 2 != 0) {
            throw new IllegalArgumentException("Odd length of pairs array: " + pairsArray.length);
        }
        ObjectPairs result = new ObjectPairs();
        for (int k = 0; k < pairsArray.length; k += 2) {
            result.addPair(pairsArray[k], pairsArray[k + 1]);
        }
        return result;
    }

    public int numberOfPairs() {
        return (int)this.pairs.length() >> 1;
    }

    public void addPair(int object1, int object2) {
        if (object1 < 0) {
            throw new IllegalArgumentException("Negative object1 index");
        }
        if (object2 < 0) {
            throw new IllegalArgumentException("Negative object2 index");
        }
        if (this.pairs.length() >= 0x7FFFFFFEL) {
            throw new TooLargeArrayException("Cannot store more than 1073741823 pairs");
        }
        if (object1 != object2) {
            this.pairs.pushInt(object1);
            this.pairs.pushInt(object2);
            this.dynamicDisjointSet.jointObjects(object1, object2);
        }
    }

    public void clear() {
        this.pairs.length(0L);
        this.dynamicDisjointSet.clear();
    }

    public int object1(int pairIndex) {
        return this.pairs.getInt(2L * (long)pairIndex);
    }

    public int object2(int pairIndex) {
        return this.pairs.getInt(2L * (long)pairIndex + 1L);
    }

    public int reindexedObject(int pairIndex) {
        int result = this.reindex(this.object1(pairIndex));
        assert (result == this.reindex(this.object2(pairIndex))) : "Objects in the pair must have identical base in disjoint set";
        return result;
    }

    public int[] pairsArray() {
        return this.pairs.toJavaArray();
    }

    public ObjectPairs resolveAllBases() {
        this.dynamicDisjointSet.resolveAllBases();
        return this;
    }

    public int[] reindexTable() {
        this.resolveAllBases();
        return this.dynamicDisjointSet.parent();
    }

    public int reindex(int objectIndex) {
        if (objectIndex < 0) {
            throw new IllegalArgumentException("Objects must be represented by zero or negative integers, but we try to reindex " + objectIndex);
        }
        if (objectIndex >= this.dynamicDisjointSet.count) {
            return objectIndex;
        }
        return this.dynamicDisjointSet.findBase(objectIndex);
    }

    public int quickReindex(int objectIndex) {
        return this.dynamicDisjointSet.parentOrThis(objectIndex);
    }

    public QuickLabelsSet reindex(QuickLabelsSet labelsSet) {
        return labelsSet.reindex(this.dynamicDisjointSet);
    }

    public BitSet reindexByAnd(BitSet bitSet) {
        int reindexed;
        int k;
        BitSet result = (BitSet)bitSet.clone();
        int n = result.length();
        for (k = 0; k < n; ++k) {
            if (result.get(k) || (reindexed = this.reindex(k)) == k) continue;
            result.clear(reindexed);
        }
        for (k = 0; k < n; ++k) {
            reindexed = this.reindex(k);
            if (reindexed == k || result.get(reindexed)) continue;
            result.clear(k);
        }
        return result;
    }

    public MapBuffer.Frame reindex(MapBuffer.Frame labels, boolean quickCallAfterResolveAllBases) {
        Objects.requireNonNull(labels, "Null labels");
        return labels.matrix(this.reindex(labels.matrix(), quickCallAfterResolveAllBases));
    }

    public MultiMatrix reindex(MultiMatrix labelsMatrix, boolean quickCallAfterResolveAllBases) {
        Objects.requireNonNull(labelsMatrix, "Null labels");
        FrameObjectStitcher.checkLabels(labelsMatrix);
        int[] labels = labelsMatrix.channel(0).toInt();
        int[] result = new int[labels.length];
        if (quickCallAfterResolveAllBases) {
            IntStream.range(0, labels.length + 255 >>> 8).parallel().forEach(block -> {
                int i;
                int to = (int)Math.min((long)i + 256L, (long)labels.length);
                for (i = block << 8; i < to; ++i) {
                    result[i] = this.dynamicDisjointSet.parentOrThis(labels[i]);
                }
            });
        } else {
            for (int i = 0; i < labels.length; ++i) {
                result[i] = this.reindex(labels[i]);
            }
        }
        return MultiMatrix.of2DMono((Matrix)Matrices.matrix((Array)SimpleMemoryModel.asUpdatableIntArray((int[])result), (long[])labelsMatrix.dimensions()));
    }

    public String toString() {
        return "object pairs: " + this.pairs.length() / 2L + " pairs among " + this.dynamicDisjointSet.count() + " objects";
    }
}

