/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.maps.frames.buffers;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.algart.arrays.Array;
import net.algart.arrays.Arrays;
import net.algart.arrays.JArrays;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.PFixedArray;
import net.algart.arrays.SimpleMemoryModel;
import net.algart.arrays.TooLargeArrayException;
import net.algart.executors.modules.maps.frames.buffers.MapBuffer;
import net.algart.executors.modules.maps.frames.buffers.ReindexerAndRetainer;
import net.algart.executors.modules.maps.frames.graph.MinimalCostLinkingOnStraight;
import net.algart.executors.modules.maps.frames.graph.ShortestPathFinder;
import net.algart.executors.modules.maps.frames.joints.ObjectPairs;
import net.algart.executors.modules.maps.frames.joints.QuickLabelsSet;
import net.algart.math.IPoint;
import net.algart.math.IRange;
import net.algart.math.IRectangularArea;
import net.algart.math.Range;
import net.algart.multimatrix.MultiMatrix;
import net.algart.multimatrix.MultiMatrix2D;

public final class FrameObjectStitcher {
    public static final int BACKGROUND_LABEL = 0;
    private static final boolean EARLY_REINDEX = false;
    private final MapBuffer map;
    private final ObjectPairs objectPairs;
    private final BitSet partialObjects;
    private boolean jointingAutoCrop = false;
    private JointingTooLargeObjects jointingTooLargeObjects = JointingTooLargeObjects.SKIP;
    private long timeInitializing;
    private long timeReadLargeArea;
    private long timeResolveAllBases;
    private long timeReindex;
    private long timeAnalyseCompleted;
    private long timeBoundaryLabelSet;
    private long timeCheckLabelSet;
    private long timeRetainOnlyCompleted;
    private IRectangularArea reducedLargeArea;

    private FrameObjectStitcher(MapBuffer map, BitSet partialObjects) {
        this.map = Objects.requireNonNull(map, "Null map");
        this.objectPairs = map.objectPairs();
        this.partialObjects = partialObjects;
    }

    public static FrameObjectStitcher getInstance(MapBuffer map, BitSet partialObject) {
        return new FrameObjectStitcher(map, partialObject);
    }

    public boolean isJointingAutoCrop() {
        return this.jointingAutoCrop;
    }

    public FrameObjectStitcher setJointingAutoCrop(boolean jointingAutoCrop) {
        this.jointingAutoCrop = jointingAutoCrop;
        return this;
    }

    public JointingTooLargeObjects getJointingTooLargeObjects() {
        return this.jointingTooLargeObjects;
    }

    public FrameObjectStitcher setJointingTooLargeObjects(JointingTooLargeObjects jointingTooLargeObjects) {
        this.jointingTooLargeObjects = Objects.requireNonNull(jointingTooLargeObjects, "Null tooLargeObjectProcessing");
        return this;
    }

    public MapBuffer map() {
        return this.map;
    }

    public void correlate(MapBuffer.Frame frame) {
        this.correlate(frame, true);
    }

    public void correlate(MapBuffer.Frame frame, boolean checkNonNegativeLabels) {
        Objects.requireNonNull(frame, "Null frame");
        this.map.checkFrameCompatibility(frame);
        FrameObjectStitcher.checkLabels(frame.matrix(), checkNonNegativeLabels);
        for (Side side : Side.values()) {
            new SideStitcher(frame, side).readPixelsAndFindCorrelations();
        }
    }

    public MapBuffer.Frame jointCompletedObjectsOfLastFrame(IPoint expansion) {
        Objects.requireNonNull(expansion, "Null expansion");
        long t1 = System.nanoTime();
        MapBuffer.Frame small = this.map.reqLastFrame();
        FrameObjectStitcher.checkLabels(small.matrix(), false);
        IRectangularArea smallArea = small.position();
        IRectangularArea largeArea = smallArea.dilate(expansion);
        if (largeArea.sizeX() > Integer.MAX_VALUE || largeArea.sizeY() > Integer.MAX_VALUE || largeArea.sizeX() * largeArea.sizeY() > Integer.MAX_VALUE) {
            throw new TooLargeArrayException("The expanded ares " + String.valueOf(largeArea) + " is too large for jointing: it contains >2147483647 elements");
        }
        AtomicReference<IRectangularArea> reducedLargeArea = new AtomicReference<IRectangularArea>(largeArea);
        List<IRectangularArea> boundary = this.jointingTooLargeObjects.internalBoundary(this.map, reducedLargeArea);
        List<MapBuffer.Frame> largeAreaFrames = this.map.allIntersecting(reducedLargeArea.get());
        long t2 = System.nanoTime();
        this.timeInitializing = t2 - t1;
        this.reducedLargeArea = reducedLargeArea.get();
        Object largeRawData = null;
        long t3 = System.nanoTime();
        this.timeReadLargeArea = t3 - t2;
        this.objectPairs.resolveAllBases();
        long t4 = System.nanoTime();
        this.timeResolveAllBases = t4 - t3;
        long t5 = t4;
        Object reindexedLarge = null;
        this.timeReindex = t5 - t4;
        QuickLabelsSet reindexedBoundaryLabelSet = this.buildBoundaryLabelSet(largeAreaFrames, boundary);
        long t6 = System.nanoTime();
        this.timeBoundaryLabelSet = t6 - t5;
        QuickLabelsSet reindexedCompleted = this.analyseCompleted(small, reindexedBoundaryLabelSet);
        long t7 = System.nanoTime();
        this.timeAnalyseCompleted = t7 - t6;
        int min = reindexedCompleted.min();
        int max = reindexedCompleted.max();
        for (int k = min; k <= max; ++k) {
            assert (!reindexedCompleted.get(k) || !reindexedBoundaryLabelSet.get(k));
        }
        long t8 = System.nanoTime();
        this.timeCheckLabelSet = t8 - t7;
        MapBuffer.Frame result = ReindexerAndRetainer.newInstance(reducedLargeArea.get(), largeAreaFrames, smallArea, this.objectPairs.dynamicDisjointSet(), reindexedCompleted, reindexedBoundaryLabelSet, this.jointingAutoCrop).reindexAndRetainCompleted();
        long t9 = System.nanoTime();
        this.timeRetainOnlyCompleted = t9 - t8;
        return result;
    }

    public String jointTimeInfo() {
        return String.format(Locale.US, "%.3f ms initializing (%dx%d)%s + %.3f resolving disjoint set bases%s + %.3f ms build boundary + %.3f ms analyse completed + %.3f ms check label set + %.3f ms retain completed", (double)this.timeInitializing * 1.0E-6, this.reducedLargeArea.sizeX(), this.reducedLargeArea.sizeY(), "", (double)this.timeResolveAllBases * 1.0E-6, "", (double)this.timeBoundaryLabelSet * 1.0E-6, (double)this.timeAnalyseCompleted * 1.0E-6, (double)this.timeCheckLabelSet * 1.0E-6, (double)this.timeRetainOnlyCompleted * 1.0E-6);
    }

    public static void checkLabels(MultiMatrix matrix) {
        FrameObjectStitcher.checkLabels(matrix, false);
    }

    private QuickLabelsSet analyseCompleted(MapBuffer.Frame smallFrame, QuickLabelsSet reindexedBoundaryWithOutside) {
        int k;
        QuickLabelsSet resultReindexedCompleted = QuickLabelsSet.newEmptyInstance();
        Side[] sides = Side.values();
        SideStitcher[] sideStitchers = new SideStitcher[sides.length];
        for (k = 0; k < sides.length; ++k) {
            sideStitchers[k] = new SideStitcher(smallFrame, sides[k]);
            sideStitchers[k].readPixels();
            sideStitchers[k].prepareCompleted(resultReindexedCompleted);
        }
        resultReindexedCompleted.prepareToUse();
        for (k = 0; k < sides.length; ++k) {
            sideStitchers[k].findPartialAndCompleted(resultReindexedCompleted, reindexedBoundaryWithOutside);
        }
        return resultReindexedCompleted;
    }

    private QuickLabelsSet buildBoundaryLabelSet(MapBuffer.Frame largeRawData, Collection<IRectangularArea> boundary) {
        int k;
        long p;
        int step;
        int length;
        Matrix matrix = largeRawData.matrix().channel(0);
        for (IRectangularArea area : boundary) {
            assert (area.coordCount() == 2);
            assert (area.sizeX() == 1L || area.sizeY() == 1L) : "invalid internalBoundary() method";
        }
        QuickLabelsSet result = QuickLabelsSet.newEmptyInstance();
        IPoint origin = largeRawData.position().min();
        PFixedArray array = (PFixedArray)matrix.array();
        for (IRectangularArea area : boundary) {
            length = (int)(area.sizeX() * area.sizeY());
            step = area.sizeX() == 1L ? (int)matrix.dimX() : 1;
            p = matrix.index(area.min().subtract(origin).coordinates());
            k = 0;
            while (k < length) {
                result.expand(this.objectPairs.quickReindex(array.getInt(p)));
                ++k;
                p += (long)step;
            }
        }
        result.prepareToUse();
        for (IRectangularArea area : boundary) {
            length = (int)(area.sizeX() * area.sizeY());
            step = area.sizeX() == 1L ? (int)matrix.dimX() : 1;
            p = matrix.index(area.min().subtract(origin).coordinates());
            k = 0;
            while (k < length) {
                result.set(this.objectPairs.quickReindex(array.getInt(p)));
                ++k;
                p += (long)step;
            }
        }
        return result;
    }

    private QuickLabelsSet buildBoundaryLabelSet(List<MapBuffer.Frame> frames, Collection<IRectangularArea> boundary) {
        int[] labels;
        ArrayList<int[]> labelsList = new ArrayList<int[]>();
        for (IRectangularArea area : boundary) {
            assert (area.coordCount() == 2);
            assert (area.sizeX() == 1L || area.sizeY() == 1L) : "invalid internalBoundary() method";
            labels = this.map.readLabelsReindexedByObjectPairs(frames, area, true);
            labelsList.add(labels);
        }
        QuickLabelsSet result = QuickLabelsSet.newEmptyInstance();
        Iterator iterator = labelsList.iterator();
        while (iterator.hasNext()) {
            for (int label : labels = (int[])iterator.next()) {
                result.expand(label);
            }
        }
        result.prepareToUse();
        iterator = labelsList.iterator();
        while (iterator.hasNext()) {
            for (int label : labels = (int[])iterator.next()) {
                result.set(label);
            }
        }
        return result;
    }

    private MapBuffer.Frame retainCompleted(MapBuffer.Frame reindexedLargeFrame, IRectangularArea smallFrameArea, QuickLabelsSet reindexedCompleted, QuickLabelsSet reindexedBoundaryWithOutside) {
        int[] maxNonZeroX;
        int[] minNonZeroX;
        FrameObjectStitcher.checkLabels(reindexedLargeFrame.matrix());
        MultiMatrix2D matrix = reindexedLargeFrame.matrix().asMultiMatrix2D();
        int dimX = (int)matrix.dimX();
        int dimY = (int)matrix.dimY();
        int[] labels = matrix.channel(0).toInt();
        int smallMinX = (int)(smallFrameArea.min(0) - reindexedLargeFrame.position().min(0));
        int smallMinY = (int)(smallFrameArea.min(1) - reindexedLargeFrame.position().min(1));
        int smallMaxX = (int)(smallFrameArea.max(0) - reindexedLargeFrame.position().min(0));
        int smallMaxY = (int)(smallFrameArea.max(1) - reindexedLargeFrame.position().min(1));
        assert (smallMinX >= 0);
        assert (smallMinY >= 0);
        assert (smallMaxX < dimX);
        assert (smallMaxY < dimY);
        if (this.jointingAutoCrop) {
            minNonZeroX = new int[dimY];
            maxNonZeroX = new int[dimY];
        } else {
            maxNonZeroX = null;
            minNonZeroX = null;
        }
        if (this.jointingAutoCrop) {
            IntStream.range(0, dimY).parallel().forEach(y -> {
                boolean insideSmallFrameByY = y >= smallMinY && y <= smallMaxY;
                int disp = y * dimX;
                int minX = Integer.MAX_VALUE;
                int maxX = Integer.MIN_VALUE;
                if (insideSmallFrameByY) {
                    int x = 0;
                    while (x < dimX) {
                        boolean insideSmallFrame = x >= smallMinX && x <= smallMaxX;
                        int label = labels[disp];
                        if (!insideSmallFrame && !reindexedCompleted.get(label) || reindexedBoundaryWithOutside.get(label)) {
                            labels[disp] = 0;
                            label = 0;
                        }
                        if (label != 0) {
                            if (minX == Integer.MAX_VALUE) {
                                minX = x;
                            }
                            maxX = x;
                        }
                        ++x;
                        ++disp;
                    }
                } else {
                    int x = 0;
                    while (x < dimX) {
                        int label = labels[disp];
                        if (!reindexedCompleted.get(label) || reindexedBoundaryWithOutside.get(label)) {
                            labels[disp] = 0;
                            label = 0;
                        }
                        if (label != 0) {
                            if (minX == Integer.MAX_VALUE) {
                                minX = x;
                            }
                            maxX = x;
                        }
                        ++x;
                        ++disp;
                    }
                }
                minNonZeroX[y] = minX;
                maxNonZeroX[y] = maxX;
            });
        } else {
            IntStream.range(0, dimY).parallel().forEach(y -> {
                boolean insideSmallFrameByY = y >= smallMinY && y <= smallMaxY;
                int disp = y * dimX;
                if (insideSmallFrameByY) {
                    int x = 0;
                    while (x < dimX) {
                        boolean insideSmallFrame = x >= smallMinX && x <= smallMaxX;
                        int label = labels[disp];
                        if (!insideSmallFrame && !reindexedCompleted.get(label) || reindexedBoundaryWithOutside.get(label)) {
                            labels[disp] = 0;
                        }
                        ++x;
                        ++disp;
                    }
                } else {
                    int x = 0;
                    while (x < dimX) {
                        int label = labels[disp];
                        if (!reindexedCompleted.get(label) || reindexedBoundaryWithOutside.get(label)) {
                            labels[disp] = 0;
                        }
                        ++x;
                        ++disp;
                    }
                }
            });
        }
        MapBuffer.Frame result = reindexedLargeFrame.matrix((MultiMatrix)MultiMatrix.of2DMono((Matrix)SimpleMemoryModel.asMatrix((Object)labels, (long[])matrix.dimensions())));
        return this.jointingAutoCrop ? ReindexerAndRetainer.crop(result, minNonZeroX, maxNonZeroX) : result;
    }

    private MapBuffer.Frame reindexAndRetainCompleted(MapBuffer.Frame largeFrame, IRectangularArea smallFrameArea, QuickLabelsSet reindexedCompleted, QuickLabelsSet reindexedBoundaryWithOutside) {
        int[] maxNonZeroX;
        int[] minNonZeroX;
        FrameObjectStitcher.checkLabels(largeFrame.matrix());
        MultiMatrix2D matrix = largeFrame.matrix().asMultiMatrix2D();
        int dimX = (int)matrix.dimX();
        int dimY = (int)matrix.dimY();
        int[] labels = matrix.channel(0).toInt();
        int[] result = new int[labels.length];
        int smallMinX = (int)(smallFrameArea.min(0) - largeFrame.position().min(0));
        int smallMinY = (int)(smallFrameArea.min(1) - largeFrame.position().min(1));
        int smallMaxX = (int)(smallFrameArea.max(0) - largeFrame.position().min(0));
        int smallMaxY = (int)(smallFrameArea.max(1) - largeFrame.position().min(1));
        assert (smallMinX >= 0);
        assert (smallMinY >= 0);
        assert (smallMaxX < dimX);
        assert (smallMaxY < dimY);
        if (this.jointingAutoCrop) {
            minNonZeroX = new int[dimY];
            maxNonZeroX = new int[dimY];
        } else {
            maxNonZeroX = null;
            minNonZeroX = null;
        }
        if (this.jointingAutoCrop) {
            IntStream.range(0, dimY).parallel().forEach(y -> {
                boolean insideSmallFrameByY = y >= smallMinY && y <= smallMaxY;
                int disp = y * dimX;
                int minX = Integer.MAX_VALUE;
                int maxX = Integer.MIN_VALUE;
                if (insideSmallFrameByY) {
                    int x = 0;
                    while (x < dimX) {
                        boolean insideSmallFrame = x >= smallMinX && x <= smallMaxX;
                        int label = this.objectPairs.quickReindex(labels[disp]);
                        if (!insideSmallFrame && !reindexedCompleted.get(label) || reindexedBoundaryWithOutside.get(label)) {
                            label = 0;
                        } else {
                            result[disp] = label;
                        }
                        if (label != 0) {
                            if (minX == Integer.MAX_VALUE) {
                                minX = x;
                            }
                            maxX = x;
                        }
                        ++x;
                        ++disp;
                    }
                } else {
                    int x = 0;
                    while (x < dimX) {
                        int label = this.objectPairs.quickReindex(labels[disp]);
                        if (!reindexedCompleted.get(label) || reindexedBoundaryWithOutside.get(label)) {
                            label = 0;
                        } else {
                            result[disp] = label;
                        }
                        if (label != 0) {
                            if (minX == Integer.MAX_VALUE) {
                                minX = x;
                            }
                            maxX = x;
                        }
                        ++x;
                        ++disp;
                    }
                }
                minNonZeroX[y] = minX;
                maxNonZeroX[y] = maxX;
            });
        } else {
            IntStream.range(0, dimY).parallel().forEach(y -> {
                boolean insideSmallFrameByY = y >= smallMinY && y <= smallMaxY;
                int disp = y * dimX;
                if (insideSmallFrameByY) {
                    int x = 0;
                    while (x < dimX) {
                        boolean insideSmallFrame = x >= smallMinX && x <= smallMaxX;
                        int label = this.objectPairs.quickReindex(labels[disp]);
                        if ((insideSmallFrame || reindexedCompleted.get(label)) && !reindexedBoundaryWithOutside.get(label)) {
                            result[disp] = label;
                        }
                        ++x;
                        ++disp;
                    }
                } else {
                    int x = 0;
                    while (x < dimX) {
                        int label = this.objectPairs.quickReindex(labels[disp]);
                        if (reindexedCompleted.get(label) && !reindexedBoundaryWithOutside.get(label)) {
                            result[disp] = label;
                        }
                        ++x;
                        ++disp;
                    }
                }
            });
        }
        MapBuffer.Frame resultFrame = largeFrame.matrix((MultiMatrix)MultiMatrix.of2DMono((Matrix)Matrices.matrix((Array)SimpleMemoryModel.asUpdatableIntArray((int[])result), (long[])matrix.dimensions())));
        return this.jointingAutoCrop ? ReindexerAndRetainer.crop(resultFrame, minNonZeroX, maxNonZeroX) : resultFrame;
    }

    private static void checkLabels(MultiMatrix matrix, boolean checkNonNegative) {
        Range range;
        if (!matrix.isMono() || matrix.isFloatingPoint() || matrix.bitsPerElement() > 32) {
            throw new IllegalArgumentException("Objects must be represented by 1-channel integer matrix with <=32 bits/element, but we have " + String.valueOf(matrix));
        }
        if (matrix.dimCount() != 2) {
            throw new IllegalArgumentException("Objects must be represented by 2-dimensional matrix (multidimensional matrices are not supported by this stitcher), but we have " + String.valueOf(matrix));
        }
        if (matrix.size() == 0L) {
            throw new IllegalArgumentException("Zero-size matrix cannot be stored as a frame: " + String.valueOf(matrix));
        }
        if (matrix.dim(0) > Integer.MAX_VALUE || matrix.dim(1) > Integer.MAX_VALUE) {
            throw new TooLargeArrayException("Matrices with sizes >2147483647 are not supported by object stitcher, but we have " + String.valueOf(matrix));
        }
        if (checkNonNegative && (range = Arrays.rangeOf((PArray)matrix.channelArray(0))).min() < 0.0) {
            throw new IllegalArgumentException("Objects must be represented by zero or negative integers, but range of values is " + String.valueOf(range) + " (matrix " + String.valueOf(matrix) + ")");
        }
    }

    private static int numberOfChanges(int[] labels) {
        int count = 2;
        for (int k = 1; k < labels.length; ++k) {
            if (labels[k] == labels[k - 1]) continue;
            ++count;
        }
        return count;
    }

    private static void allChanges(int[] labels, double[] changePositions, int[] labelToRight) {
        assert (labels.length > 0) : "int[0] labels should be checked before calling this method";
        changePositions[0] = 0.0;
        labelToRight[0] = labels[0];
        int count = 1;
        for (int k = 1; k < labels.length; ++k) {
            if (labels[k] == labels[k - 1]) continue;
            changePositions[count] = k;
            labelToRight[count] = labels[k];
            ++count;
        }
        changePositions[count] = labels.length;
        labelToRight[count] = -1;
    }

    public static enum JointingTooLargeObjects {
        SKIP{

            @Override
            List<IRectangularArea> internalBoundary(MapBuffer map, AtomicReference<IRectangularArea> largeRef) {
                List intersections = largeRef.get().intersection(map.allPositions());
                IRectangularArea reducedLarge = IRectangularArea.minimalContainingArea((Collection)intersections);
                assert (reducedLarge != null) : "expanded rectangle must intersect, at least, the last frame";
                largeRef.set(reducedLarge);
                return MapBuffer.internalBoundary(intersections, true);
            }
        }
        ,
        RETAIN_LAST_PART{

            @Override
            List<IRectangularArea> internalBoundary(MapBuffer map, AtomicReference<IRectangularArea> largeRef) {
                IRectangularArea large = largeRef.get();
                IRectangularArea dilatedLarge = large.dilate(1L);
                Collection allFrames = map.allPositions().stream().filter(area -> area.intersects(dilatedLarge)).collect(Collectors.toList());
                IRectangularArea containing = IRectangularArea.minimalContainingArea((Collection)allFrames);
                assert (containing != null) : "expanded rectangle must intersect, at least, the last frame";
                IRectangularArea reducedLarge = large.intersection(containing);
                largeRef.set(reducedLarge);
                List<IRectangularArea> boundary = MapBuffer.internalBoundary(allFrames, true);
                return reducedLarge.intersection(boundary);
            }
        };


        abstract List<IRectangularArea> internalBoundary(MapBuffer var1, AtomicReference<IRectangularArea> var2);

        public List<IRectangularArea> internalBoundary(MapBuffer map, IRectangularArea large) {
            return this.internalBoundary(map, new AtomicReference<IRectangularArea>(large));
        }
    }

    public static enum Side {
        X_MINUS(0, true, false){

            @Override
            public long coordinate(IRectangularArea rectangularArea) {
                return rectangularArea.min(0);
            }

            @Override
            public IRange secondCoordinateRange(IRectangularArea rectangularArea) {
                return rectangularArea.range(1);
            }

            @Override
            public Side oppositeSide() {
                return X_PLUS;
            }

            @Override
            public long indexInMatrixAlongSide(Matrix<?> matrix, long indexAlongSide) {
                return matrix.index(0L, indexAlongSide);
            }
        }
        ,
        Y_MINUS(1, true, true){

            @Override
            public long coordinate(IRectangularArea rectangularArea) {
                return rectangularArea.min(1);
            }

            @Override
            public IRange secondCoordinateRange(IRectangularArea rectangularArea) {
                return rectangularArea.range(0);
            }

            @Override
            public Side oppositeSide() {
                return Y_PLUS;
            }

            @Override
            public long indexInMatrixAlongSide(Matrix<?> matrix, long indexAlongSide) {
                return matrix.index(indexAlongSide, 0L);
            }
        }
        ,
        X_PLUS(0, false, false){

            @Override
            public long coordinate(IRectangularArea rectangularArea) {
                return rectangularArea.max(0);
            }

            @Override
            public IRange secondCoordinateRange(IRectangularArea rectangularArea) {
                return rectangularArea.range(1);
            }

            @Override
            public Side oppositeSide() {
                return X_MINUS;
            }

            @Override
            public long indexInMatrixAlongSide(Matrix<?> matrix, long indexAlongSide) {
                return matrix.index(matrix.dimX() - 1L, indexAlongSide);
            }
        }
        ,
        Y_PLUS(1, false, true){

            @Override
            public long coordinate(IRectangularArea rectangularArea) {
                return rectangularArea.max(1);
            }

            @Override
            public IRange secondCoordinateRange(IRectangularArea rectangularArea) {
                return rectangularArea.range(0);
            }

            @Override
            public Side oppositeSide() {
                return Y_MINUS;
            }

            @Override
            public long indexInMatrixAlongSide(Matrix<?> matrix, long indexAlongSide) {
                return matrix.index(indexAlongSide, matrix.dimY() - 1L);
            }
        };

        private final boolean minimalCoordinate;
        private final boolean horizontal;
        private final int coordIndex;

        private Side(int coordIndex, boolean minimalCoordinate, boolean horizontal) {
            this.minimalCoordinate = minimalCoordinate;
            this.coordIndex = coordIndex;
            this.horizontal = horizontal;
        }

        public boolean isMinimalCoordinate() {
            return this.minimalCoordinate;
        }

        public boolean isHorizontal() {
            return this.horizontal;
        }

        public boolean isVertical() {
            return !this.horizontal;
        }

        public int coordIndex() {
            return this.coordIndex;
        }

        public int secondCoordIndex() {
            return 1 - this.coordIndex;
        }

        public abstract long coordinate(IRectangularArea var1);

        public abstract IRange secondCoordinateRange(IRectangularArea var1);

        public abstract Side oppositeSide();

        public abstract long indexInMatrixAlongSide(Matrix<?> var1, long var2);
    }

    private class SideStitcher {
        private static final int NO_LABEL = -1;
        private final MapBuffer.Frame frame;
        private final Side side;
        private final Matrix<? extends PArray> frameMatrix;
        private final int length;
        private final int[] frameLabels;
        private final int[] adjacentLabels;

        SideStitcher(MapBuffer.Frame frame, Side side) {
            this.frame = Objects.requireNonNull(frame, "Null frame");
            this.side = Objects.requireNonNull(side, "Null side");
            this.frameMatrix = frame.matrix().channel(0);
            FrameObjectStitcher.checkLabels(frame.matrix());
            this.length = (int)this.frameMatrix.dim(side.secondCoordIndex());
            assert ((long)this.length == this.frameMatrix.dim(side.secondCoordIndex())) : "matrix sizes were not checked by checkLabels";
            this.frameLabels = new int[this.length];
            this.adjacentLabels = new int[this.length];
            JArrays.fill((int[])this.adjacentLabels, (int)-1);
        }

        void readPixelsAndFindCorrelations() {
            if (this.length == 0) {
                return;
            }
            if (!this.readPixels()) {
                return;
            }
            double[] framePositions = new double[FrameObjectStitcher.numberOfChanges(this.frameLabels)];
            int[] frameLabelToRight = new int[framePositions.length];
            FrameObjectStitcher.allChanges(this.frameLabels, framePositions, frameLabelToRight);
            double[] adjacentPositions = new double[FrameObjectStitcher.numberOfChanges(this.adjacentLabels)];
            int[] adjacentLabelToRight = new int[adjacentPositions.length];
            FrameObjectStitcher.allChanges(this.adjacentLabels, adjacentPositions, adjacentLabelToRight);
            MinimalCostLinkingOnStraight linking = MinimalCostLinkingOnStraight.newInstance(ShortestPathFinder.Algorithm.FOR_SORTED_ACYCLIC, framePositions, adjacentPositions);
            linking.findBestLinks();
            this.findPairs(frameLabelToRight, adjacentLabelToRight, linking);
        }

        boolean readPixels() {
            List<MapBuffer.Frame> adjacentFrames = this.findAdjacentFrames();
            this.readFrameLabelsAlongFrameSide();
            this.readAdjacentLabelsAlongFrameSide(adjacentFrames);
            return !adjacentFrames.isEmpty();
        }

        void prepareCompleted(QuickLabelsSet resultReindexedCompleted) {
            for (int k = 0; k < this.length; ++k) {
                int adjacentLabel = this.adjacentLabels[k];
                if (adjacentLabel == -1) continue;
                resultReindexedCompleted.expand(FrameObjectStitcher.this.objectPairs.quickReindex(adjacentLabel));
            }
        }

        void findPartialAndCompleted(QuickLabelsSet resultReindexedCompleted, QuickLabelsSet reindexedBoundaryWithOutside) {
            for (int k = 0; k < this.length; ++k) {
                int adjacentReindexed;
                int frameLabel = this.frameLabels[k];
                int adjacentLabel = this.adjacentLabels[k];
                int frameReindexed = FrameObjectStitcher.this.objectPairs.quickReindex(frameLabel);
                if (adjacentLabel != -1 && !reindexedBoundaryWithOutside.get(adjacentReindexed = FrameObjectStitcher.this.objectPairs.quickReindex(adjacentLabel))) {
                    resultReindexedCompleted.set(adjacentReindexed);
                    FrameObjectStitcher.this.partialObjects.clear(adjacentLabel);
                }
                if (frameLabel == 0 || !reindexedBoundaryWithOutside.get(frameReindexed)) continue;
                FrameObjectStitcher.this.partialObjects.set(frameLabel);
            }
        }

        private List<MapBuffer.Frame> findAdjacentFrames() {
            FrameObjectStitcher.checkLabels(this.frame.matrix());
            FrameObjectStitcher.this.map.checkFrameCompatibility(this.frame);
            long sideCoordinate = this.side.coordinate(this.frame.position());
            return this.side.isMinimalCoordinate() ? FrameObjectStitcher.this.map.allFramesWithMaxCoordinate(this.side.coordIndex(), sideCoordinate - 1L) : FrameObjectStitcher.this.map.allFramesWithMinCoordinate(this.side.coordIndex(), sideCoordinate + 1L);
        }

        private void readFrameLabelsAlongFrameSide() {
            assert (this.frameLabels.length == this.length);
            Matrix frameMatrix = this.frame.matrix().channel(0);
            assert (frameMatrix.array() instanceof PFixedArray) : "matrix type was not checked by checkLabels";
            PFixedArray frameArray = (PFixedArray)frameMatrix.array();
            for (int k = 0; k < this.length; ++k) {
                this.frameLabels[k] = frameArray.getInt(this.side.indexInMatrixAlongSide(frameMatrix, k));
                assert (this.frameLabels[k] >= 0) : "frame was not checked by checkLabels with checkNonNegative flag";
            }
        }

        private void readAdjacentLabelsAlongFrameSide(List<MapBuffer.Frame> adjacentFrames) {
            assert (this.adjacentLabels.length == this.length);
            IRange frameRange = this.side.secondCoordinateRange(this.frame.position());
            assert (frameRange.size() == (long)this.length);
            Side oppositeSide = this.side.oppositeSide();
            for (MapBuffer.Frame adjacent : adjacentFrames) {
                long max;
                FrameObjectStitcher.checkLabels(adjacent.matrix());
                Matrix adjacentMatrix = adjacent.matrix().channel(0);
                assert (adjacentMatrix.array() instanceof PFixedArray) : "matrix type was not checked by checkLabels";
                PFixedArray adjacentArray = (PFixedArray)adjacentMatrix.array();
                IRange adjacentRange = this.side.secondCoordinateRange(adjacent.position());
                long min = Math.max(frameRange.min(), adjacentRange.min());
                if (min > (max = Math.min(frameRange.max(), adjacentRange.max()))) continue;
                int fromAtFrame = (int)(min - frameRange.min());
                assert ((long)fromAtFrame == min - frameRange.min()) : "impossible overflow for " + fromAtFrame;
                int fromAtAdjacent = (int)(min - adjacentRange.min());
                assert ((long)fromAtAdjacent == min - adjacentRange.min()) : "impossible overflow for " + fromAtAdjacent;
                int n = (int)(max - min + 1L);
                assert (max - min + 1L <= (long)this.length) : "impossible overflow for " + min + ".." + max;
                for (int k = 0; k < n; ++k) {
                    int label = adjacentArray.getInt(oppositeSide.indexInMatrixAlongSide(adjacentMatrix, fromAtAdjacent + k));
                    if (label < 0) {
                        throw new IllegalArgumentException("Map contain a frame with negative label " + label + "; such frames cannot be stitched");
                    }
                    this.adjacentLabels[fromAtFrame + k] = label;
                }
            }
        }

        private void findPairs(int[] frameLabelToRight, int[] adjacentLabelToRight, MinimalCostLinkingOnStraight linking) {
            int lastSource = -1;
            int lastTarget = -1;
            int n = linking.getNumberOfLinks();
            for (int k = 0; k < n; ++k) {
                int source = linking.getSourceIndex(k);
                int target = linking.getTargetIndex(k);
                if (source != lastSource && target != lastTarget) {
                    assert (source == lastSource + 1) : "Invalid behaviour of MinimalCostLinkingOnStraight";
                    assert (target == lastTarget + 1) : "Invalid behaviour of MinimalCostLinkingOnStraight";
                    if (lastSource != -1) {
                        int frameLabel = frameLabelToRight[lastSource];
                        int adjacentLabel = adjacentLabelToRight[lastTarget];
                        assert (frameLabel >= 0) : "was not checked in readFrameLabelsAlongFrameSide??";
                        assert (adjacentLabel >= 0 || adjacentLabel == -1) : "was not checked in readAdjacentLabelsAlongFrameSide??";
                        if (frameLabel != 0 && adjacentLabel != -1 && adjacentLabel != 0) {
                            FrameObjectStitcher.this.objectPairs.addPair(frameLabel, adjacentLabel);
                        }
                    }
                }
                lastSource = source;
                lastTarget = target;
            }
        }
    }
}

