/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.maps.frames;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.UpdatablePArray;
import net.algart.executors.api.data.SScalar;
import net.algart.executors.modules.core.common.scalars.ScalarFilter;
import net.algart.executors.modules.maps.frames.buffers.FrameObjectStitcher;
import net.algart.executors.modules.maps.frames.buffers.MapBuffer;
import net.algart.executors.modules.maps.frames.buffers.MapBufferKey;
import net.algart.executors.modules.maps.frames.joints.ObjectPairs;
import net.algart.math.IPoint;
import net.algart.math.IRectangularArea;
import net.algart.multimatrix.MultiMatrix;
import net.algart.multimatrix.MultiMatrix2D;

public final class ReadFromMapBuffer
extends ScalarFilter {
    public static final String OUTPUT_DIM_X = "dim_x";
    public static final String OUTPUT_DIM_Y = "dim_y";
    public static final String EXPANDED_RECTANGLE = "expanded";
    private static final FrameObjectStitcher.JointingTooLargeObjects DEBUG_BOUNDARIES = null;
    private static final int DEBUG_BOUNDARIES_EXPANSION = 0;
    private int startX = 0;
    private int startY = 0;
    private int sizeX = 1;
    private int sizeY = 1;
    private int expansionX = 0;
    private Integer expansionY = null;
    private boolean reindexStitched = true;

    public ReadFromMapBuffer() {
        this.setDefaultInputScalar("map_buffer_id");
        this.addInputNumbers("rectangle");
        this.setDefaultOutputScalar("map_buffer_id");
        this.addOutputMat(DEFAULT_OUTPUT_PORT);
        this.addOutputNumbers(EXPANDED_RECTANGLE);
        this.addOutputScalar(OUTPUT_DIM_X);
        this.addOutputScalar(OUTPUT_DIM_Y);
        this.addOutputNumbers("containing_rectangle");
    }

    public int getStartX() {
        return this.startX;
    }

    public ReadFromMapBuffer setStartX(int startX) {
        this.startX = startX;
        return this;
    }

    public int getStartY() {
        return this.startY;
    }

    public ReadFromMapBuffer setStartY(int startY) {
        this.startY = startY;
        return this;
    }

    public int getSizeX() {
        return this.sizeX;
    }

    public ReadFromMapBuffer setSizeX(int sizeX) {
        this.sizeX = ReadFromMapBuffer.positive((int)sizeX);
        return this;
    }

    public int getSizeY() {
        return this.sizeY;
    }

    public ReadFromMapBuffer setSizeY(int sizeY) {
        this.sizeY = ReadFromMapBuffer.positive((int)sizeY);
        return this;
    }

    public int expansionX() {
        return this.expansionX;
    }

    public ReadFromMapBuffer setExpansionX(int expansionX) {
        this.expansionX = expansionX;
        return this;
    }

    public Integer expansionY() {
        return this.expansionY;
    }

    public ReadFromMapBuffer setExpansionY(Integer expansionY) {
        this.expansionY = expansionY;
        return this;
    }

    public boolean isReindexStitched() {
        return this.reindexStitched;
    }

    public ReadFromMapBuffer setReindexStitched(boolean reindexStitched) {
        this.reindexStitched = reindexStitched;
        return this;
    }

    public SScalar process(SScalar source) {
        long mapBufferId = source.toLong();
        IRectangularArea area = this.getInputNumbers("rectangle", true).toIRectangularArea();
        if (area == null) {
            area = IRectangularArea.of((long)this.startX, (long)this.startY, (long)(this.startX + this.sizeX - 1), (long)(this.startY + this.sizeY - 1));
        }
        MultiMatrix result = this.process(mapBufferId, area);
        this.getMat(DEFAULT_OUTPUT_PORT).setTo(result);
        this.getScalar(OUTPUT_DIM_X).setTo(result.dim(0));
        this.getScalar(OUTPUT_DIM_Y).setTo(result.dim(1));
        return source;
    }

    public MultiMatrix process(long mapBufferId, IRectangularArea area) {
        MapBufferKey mapBufferKey = MapBufferKey.getInstance(mapBufferId);
        MapBuffer mapBuffer = mapBufferKey.reqMapBuffer();
        ObjectPairs objectPairs = mapBuffer.objectPairs();
        boolean reindex = mapBuffer.isStitchingLabels() && this.reindexStitched;
        long t1 = System.nanoTime();
        if (reindex) {
            objectPairs.resolveAllBases();
        }
        long t2 = System.nanoTime();
        IRectangularArea expanded = mapBuffer.expandRectangleOnMap(area, IPoint.of((long)this.expansionX, (long)(this.expansionY != null ? (long)this.expansionY.intValue() : (long)this.expansionX)), false);
        MultiMatrix result = reindex ? mapBuffer.readMatrixReindexedByObjectPairs(expanded, true) : mapBuffer.readMatrix(expanded);
        long t3 = System.nanoTime();
        ReadFromMapBuffer.logDebug(() -> String.format(Locale.US, "Reading %s at %s from %s (%s): %.3f ms = %.3f ms resolving disjoint set bases + %.3f ms reading%s", result, expanded, mapBufferKey, mapBuffer, (double)(t3 - t1) * 1.0E-6, (double)(t2 - t1) * 1.0E-6, (double)(t3 - t2) * 1.0E-6, reindex ? "/reindexing" : ""));
        this.getNumbers(EXPANDED_RECTANGLE).setTo(expanded);
        if (this.isOutputNecessary("containing_rectangle")) {
            this.getNumbers("containing_rectangle").setTo(mapBuffer.containingRectangle());
        }
        if (DEBUG_BOUNDARIES != null) {
            return ReadFromMapBuffer.drawBoundary(result.asMultiMatrix2D(), expanded, mapBuffer);
        }
        return result;
    }

    public String visibleOutputPortName() {
        return DEFAULT_OUTPUT_PORT;
    }

    private static MultiMatrix2D drawBoundary(MultiMatrix2D matrix, IRectangularArea matrixArea, MapBuffer map) {
        IRectangularArea container = matrixArea.dilate(0L);
        List areas = container.intersection(map.allPositions());
        List<IRectangularArea> internal = DEBUG_BOUNDARIES.internalBoundary(map, container);
        Collection<IRectangularArea> external = MapBuffer.externalBoundary(areas, true);
        ArrayList<Matrix> result = new ArrayList<Matrix>();
        double externalFiller = matrix.maxPossibleValue();
        for (Matrix m : matrix.allChannels()) {
            long k;
            long n;
            UpdatablePArray line;
            IRectangularArea filledArea;
            Matrix r = Matrices.clone((Matrix)m);
            for (IRectangularArea area : internal) {
                filledArea = area.shiftBack(matrixArea.min());
                line = (UpdatablePArray)r.subMatrix(filledArea, Matrix.ContinuationMode.ZERO_CONSTANT).array();
                n = line.length();
                for (k = 0L; k < n; ++k) {
                    if (k % 4L != 0L && k != n - 1L) continue;
                    line.setDouble(k, 0.0);
                }
            }
            for (IRectangularArea area : external) {
                filledArea = area.shiftBack(matrixArea.min());
                line = (UpdatablePArray)r.subMatrix(filledArea, Matrix.ContinuationMode.ZERO_CONSTANT).array();
                n = line.length();
                for (k = 0L; k < n; ++k) {
                    if (k % 2L != 0L && k != n - 1L) continue;
                    line.setDouble(k, externalFiller);
                }
            }
            result.add(r);
        }
        return MultiMatrix.of2D(result);
    }
}

