/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.maps.frames;

import net.algart.executors.api.data.SNumbers;
import net.algart.executors.api.data.SScalar;
import net.algart.executors.modules.core.common.numbers.NumbersFilter;
import net.algart.executors.modules.maps.frames.buffers.MapBuffer;
import net.algart.executors.modules.maps.frames.buffers.MapBufferKey;
import net.algart.math.IPoint;
import net.algart.math.IRectangularArea;

public final class ChangeRectangleInsideMapBuffer
extends NumbersFilter {
    public static final String EXPANDED = "expanded";
    public static final String RECTANGLE = "rectangle";
    public static final String DIM_X = "dim_x";
    public static final String DIM_Y = "dim_y";
    public static final String RELATIVE_RECTANGLE = "relative_rectangle";
    public static final String RELATIVE_EXPANDED_RECTANGLE = "relative_expanded_rectangle";
    public static final String CONTAINING_RECTANGLE = "containing_rectangle";
    private Changing changing = Changing.EXPAND;
    private int x = 0;
    private Integer y = null;
    private boolean rectangleMustBeCovered = false;

    public ChangeRectangleInsideMapBuffer() {
        this.addInputScalar("map_buffer_id");
        this.setDefaultInputNumbers(RECTANGLE);
        this.addInputNumbers(EXPANDED);
        this.setDefaultOutputNumbers(RECTANGLE);
        this.addOutputScalar(DIM_X);
        this.addOutputScalar(DIM_Y);
        this.addOutputNumbers(RELATIVE_RECTANGLE);
        this.addOutputNumbers(RELATIVE_EXPANDED_RECTANGLE);
        this.addOutputNumbers(CONTAINING_RECTANGLE);
        this.addOutputScalar("map_buffer_id");
    }

    public Changing getChanging() {
        return this.changing;
    }

    public ChangeRectangleInsideMapBuffer setChanging(Changing changing) {
        this.changing = (Changing)((Object)ChangeRectangleInsideMapBuffer.nonNull((Object)((Object)changing)));
        return this;
    }

    public int getX() {
        return this.x;
    }

    public ChangeRectangleInsideMapBuffer setX(int x) {
        this.x = x;
        return this;
    }

    public Integer getY() {
        return this.y;
    }

    public ChangeRectangleInsideMapBuffer setY(Integer y) {
        this.y = y;
        return this;
    }

    public boolean isRectangleMustBeCovered() {
        return this.rectangleMustBeCovered;
    }

    public ChangeRectangleInsideMapBuffer setRectangleMustBeCovered(boolean rectangleMustBeCovered) {
        this.rectangleMustBeCovered = rectangleMustBeCovered;
        return this;
    }

    protected SNumbers processNumbers(SNumbers source) {
        SScalar id = this.getInputScalar("map_buffer_id");
        MapBuffer mapBuffer = MapBufferKey.getInstance(id.toLong()).reqMapBuffer();
        IRectangularArea expanded = this.getInputNumbers(EXPANDED, true).toIRectangularArea();
        IRectangularArea area = source.toIRectangularArea();
        boolean originalAreaMustBeCovered = this.rectangleMustBeCovered;
        if (area == null) {
            area = mapBuffer.reqLastFrame().position();
            originalAreaMustBeCovered = true;
        }
        IRectangularArea changed = this.changing.change(area, this.x, this.y != null ? (long)this.y.intValue() : (long)this.x);
        IRectangularArea result = mapBuffer.changeRectangleOnMap(area, changed, originalAreaMustBeCovered);
        if (expanded != null) {
            IRectangularArea cropped = result.intersection(expanded);
            if (cropped == null) {
                throw new IllegalArgumentException("Expanded rectangle " + String.valueOf(expanded) + " does not intersect " + String.valueOf(result) + ", the result of " + this.changing.name + " of " + String.valueOf(area) + " by (" + this.x + ", " + this.y + ")");
            }
            result = cropped;
            this.getNumbers(RELATIVE_RECTANGLE).setTo(result.shiftBack(expanded.min()));
            this.getNumbers(RELATIVE_EXPANDED_RECTANGLE).setTo(expanded.shiftBack(result.min()));
        }
        if (this.isOutputNecessary(CONTAINING_RECTANGLE)) {
            this.getNumbers(CONTAINING_RECTANGLE).setTo(mapBuffer.containingRectangle());
        }
        this.getScalar(DIM_X).setTo(result.sizeX());
        this.getScalar(DIM_Y).setTo(result.sizeY());
        this.getScalar("map_buffer_id").setTo(id);
        return SNumbers.of((IRectangularArea)result);
    }

    protected boolean allowUninitializedInput() {
        return true;
    }

    public static enum Changing {
        LEFT_UP("left-up shift"){

            @Override
            IRectangularArea change(IRectangularArea area, long x, long y) {
                return area.shift(IPoint.of((long)(-x), (long)(-y)));
            }
        }
        ,
        RIGHT_UP("right-up shift"){

            @Override
            IRectangularArea change(IRectangularArea area, long x, long y) {
                return area.shift(IPoint.of((long)x, (long)(-y)));
            }
        }
        ,
        LEFT_DOWN("left-down shift"){

            @Override
            IRectangularArea change(IRectangularArea area, long x, long y) {
                return area.shift(IPoint.of((long)(-x), (long)y));
            }
        }
        ,
        RIGHT_DOWN("right-down shift"){

            @Override
            IRectangularArea change(IRectangularArea area, long x, long y) {
                return area.shift(IPoint.of((long)x, (long)y));
            }
        }
        ,
        EXPAND("expanding"){

            @Override
            IRectangularArea change(IRectangularArea area, long x, long y) {
                return area.dilate(IPoint.of((long)x, (long)y));
            }
        };

        private final String name;

        private Changing(String name) {
            this.name = name;
        }

        abstract IRectangularArea change(IRectangularArea var1, long var2, long var4);
    }
}

