/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.model;

import com.siams.cv.monitor.model.property.AnyPropertyModel;
import com.siams.cv.monitor.model.property.BoolPropertyModel;
import com.siams.cv.monitor.model.property.DoublePropertyModel;
import com.siams.cv.monitor.model.property.IntPropertyModel;
import com.siams.cv.monitor.model.property.LongPropertyModel;
import com.siams.cv.monitor.model.property.PropertyModel;
import com.siams.cv.monitor.model.property.ShortPropertyModel;
import com.siams.cv.monitor.model.property.StrPropertyModel;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SimplePrimitive {
    private static final Logger logger = Logger.getLogger(SimplePrimitive.class.getName());
    private String name;
    private PRIMITIVE_TYPE type;
    private Object val;

    public static SimplePrimitive unknown() {
        SimplePrimitive property = new SimplePrimitive();
        property.type = PRIMITIVE_TYPE.UNKNOWN;
        return property;
    }

    public static SimplePrimitive unknown(String name) {
        SimplePrimitive property = new SimplePrimitive();
        property.name = name;
        property.type = PRIMITIVE_TYPE.UNKNOWN;
        return property;
    }

    private SimplePrimitive() {
    }

    public SimplePrimitive(String name, Object val) {
        this.name = name;
        this.val = val;
        if (val instanceof Integer) {
            this.type = PRIMITIVE_TYPE.INT32;
        } else if (val instanceof Long) {
            this.type = PRIMITIVE_TYPE.INT64;
        } else if (val instanceof Double) {
            this.type = PRIMITIVE_TYPE.DOUBLE;
        } else if (val instanceof Boolean) {
            this.type = PRIMITIVE_TYPE.BOOL;
        } else if (val instanceof String) {
            this.type = PRIMITIVE_TYPE.STR;
        }
    }

    public SimplePrimitive(String name, PRIMITIVE_TYPE type, Object val) {
        this.name = name;
        this.type = type;
        this.val = val;
    }

    public SimplePrimitive(String name, int val) {
        this.name = name;
        this.type = PRIMITIVE_TYPE.INT32;
        this.val = val;
    }

    public SimplePrimitive(String name, long val) {
        this.name = name;
        this.type = PRIMITIVE_TYPE.INT64;
        this.val = val;
    }

    public SimplePrimitive(String name, double val) {
        this.name = name;
        this.type = PRIMITIVE_TYPE.DOUBLE;
        this.val = val;
    }

    public SimplePrimitive(String name, String val) {
        this.name = name;
        this.type = PRIMITIVE_TYPE.STR;
        this.val = val;
    }

    public SimplePrimitive(String name, boolean val) {
        this.name = name;
        this.type = PRIMITIVE_TYPE.BOOL;
        this.val = val;
    }

    public PRIMITIVE_TYPE getType() {
        return this.type;
    }

    public Object getVal() {
        return this.val;
    }

    public String getName() {
        return this.name;
    }

    public static SimplePrimitive valueOf(PropertyModel propertyModel) {
        String name = propertyModel.getName();
        PRIMITIVE_TYPE type = PRIMITIVE_TYPE.from(propertyModel.getType());
        Object value = null;
        if (propertyModel instanceof StrPropertyModel) {
            value = ((StrPropertyModel)propertyModel).getValue();
        } else if (propertyModel instanceof BoolPropertyModel) {
            value = ((BoolPropertyModel)propertyModel).getValue();
        } else if (propertyModel instanceof ShortPropertyModel) {
            value = ((ShortPropertyModel)propertyModel).getValue();
        } else if (propertyModel instanceof IntPropertyModel) {
            value = ((IntPropertyModel)propertyModel).getValue();
        } else if (propertyModel instanceof DoublePropertyModel) {
            value = ((DoublePropertyModel)propertyModel).getValue();
        } else if (propertyModel instanceof LongPropertyModel) {
            value = ((LongPropertyModel)propertyModel).getValue();
        } else {
            System.err.println(String.format("Failed convert simple primitive from property model: %s", propertyModel.toString()));
        }
        return new SimplePrimitive(name, type, value);
    }

    public PropertyModel convertTo() {
        String name = this.getName();
        Object value = this.getVal();
        Objects.requireNonNull(value, String.format("Property: %s value required", name != null ? name : ""));
        AnyPropertyModel propertyModel = switch (this.getType().ordinal()) {
            case 1 -> new BoolPropertyModel(name, (Boolean)value);
            case 4 -> new StrPropertyModel(name, (String)value);
            case 2 -> new IntPropertyModel(name, (Integer)value);
            case 5 -> new LongPropertyModel(name, (Long)value);
            case 3 -> new DoublePropertyModel(name, (Double)value);
            default -> throw new IllegalArgumentException(String.format("Conversion failed to PropertyModel unsupported type: %s", this.getType().toString()));
        };
        return propertyModel;
    }

    public int asInt(int def) {
        try {
            return this.asInt();
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, String.format("Failed parse property: %s", this), t);
            return def;
        }
    }

    public int asInt() {
        if (this.val instanceof Integer) {
            return (Integer)this.val;
        }
        if (this.val instanceof Double) {
            return ((Double)this.val).intValue();
        }
        if (this.val instanceof Boolean) {
            return (Boolean)this.val != false ? 1 : 0;
        }
        if (this.val instanceof String) {
            return Integer.parseInt((String)this.val);
        }
        if (this.val instanceof Long) {
            return ((Long)this.val).intValue();
        }
        throw new IllegalStateException("Failed cast val as integer");
    }

    public double asDouble() {
        if (this.val instanceof Double) {
            return (Double)this.val;
        }
        if (this.val instanceof Integer) {
            return ((Integer)this.val).doubleValue();
        }
        if (this.val instanceof Boolean) {
            return (Boolean)this.val != false ? 1.0 : 0.0;
        }
        if (this.val instanceof String) {
            return Double.parseDouble((String)this.val);
        }
        if (this.val instanceof Long) {
            return ((Long)this.val).doubleValue();
        }
        throw new IllegalStateException("Failed cast val as double");
    }

    public double asDouble(double def) {
        try {
            return this.asDouble();
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, String.format("Failed parse property: %s", this), t);
            return def;
        }
    }

    public String asString() {
        return this.val.toString();
    }

    public String asString(String def) {
        try {
            return this.val.toString();
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, String.format("Failed parse property: %s", this), t);
            return def;
        }
    }

    public boolean asBoolean() {
        return Boolean.parseBoolean(this.asString());
    }

    public boolean asBoolean(boolean def) {
        try {
            return this.asBoolean();
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, String.format("Failed parse property: %s", this), t);
            return def;
        }
    }

    public String toString() {
        return "SimplePrimitive{name='" + this.name + "', type=" + String.valueOf((Object)this.type) + ", val=" + String.valueOf(this.val) + "}";
    }

    public static enum PRIMITIVE_TYPE {
        UNKNOWN(0),
        BOOL(1),
        INT32(2),
        DOUBLE(3),
        STR(4),
        INT64(5);

        private final int id;

        private PRIMITIVE_TYPE(int id) {
            this.id = id;
        }

        static PRIMITIVE_TYPE from(String typeName) {
            String lowercase;
            Objects.requireNonNull(typeName, "Type name required");
            switch (lowercase = typeName.toLowerCase()) {
                case "bool": 
                case "boolean": {
                    return BOOL;
                }
                case "int": 
                case "int32": 
                case "integer": {
                    return INT32;
                }
                case "double": 
                case "float64": {
                    return DOUBLE;
                }
                case "str": 
                case "string": 
                case "scalar": {
                    return STR;
                }
                case "int64": 
                case "long": {
                    return INT64;
                }
            }
            System.err.println(String.format("Unknown primitive type typeName: %s", typeName));
            return UNKNOWN;
        }
    }
}

