/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.nativebridge;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.graalvm.nativebridge.BinaryOutput;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.PointerBase;

public abstract class BinaryInput {
    private static final int EOF = -1;
    private byte[] tempEncodingByteBuffer;
    private char[] tempEncodingCharBuffer;
    protected final int length;
    protected int pos;

    private BinaryInput(int length) {
        this.length = length;
    }

    public final boolean readBoolean() throws IndexOutOfBoundsException {
        int b = this.read();
        if (b < 0) {
            throw new IndexOutOfBoundsException();
        }
        return b != 0;
    }

    public final byte readByte() throws IndexOutOfBoundsException {
        int b = this.read();
        if (b < 0) {
            throw new IndexOutOfBoundsException();
        }
        return (byte)b;
    }

    public final short readShort() throws IndexOutOfBoundsException {
        int b2;
        int b1 = this.read();
        if ((b1 | (b2 = this.read())) < 0) {
            throw new IndexOutOfBoundsException();
        }
        return BinaryInput.packShort(b1, b2);
    }

    private static short packShort(int b1, int b2) {
        return (short)((b1 << 8) + b2);
    }

    public final char readChar() throws IndexOutOfBoundsException {
        int b2;
        int b1 = this.read();
        if ((b1 | (b2 = this.read())) < 0) {
            throw new IndexOutOfBoundsException();
        }
        return BinaryInput.packChar(b1, b2);
    }

    private static char packChar(int b1, int b2) {
        return (char)((b1 << 8) + b2);
    }

    public final int readInt() throws IndexOutOfBoundsException {
        int b4;
        int b3;
        int b2;
        int b1 = this.read();
        if ((b1 | (b2 = this.read()) | (b3 = this.read()) | (b4 = this.read())) < 0) {
            throw new IndexOutOfBoundsException();
        }
        return BinaryInput.packInt(b1, b2, b3, b4);
    }

    private static int packInt(int b1, int b2, int b3, int b4) {
        return (b1 << 24) + (b2 << 16) + (b3 << 8) + b4;
    }

    public final long readLong() throws IndexOutOfBoundsException {
        int b8;
        int b7;
        int b6;
        int b5;
        int b4;
        int b3;
        int b2;
        int b1 = this.read();
        if ((b1 | (b2 = this.read()) | (b3 = this.read()) | (b4 = this.read()) | (b5 = this.read()) | (b6 = this.read()) | (b7 = this.read()) | (b8 = this.read())) < 0) {
            throw new IndexOutOfBoundsException();
        }
        return BinaryInput.packLong(b1, b2, b3, b4, b5, b6, b7, b8);
    }

    private static long packLong(int b1, int b2, int b3, int b4, int b5, int b6, int b7, int b8) {
        return ((long)b1 << 56) + ((long)b2 << 48) + ((long)b3 << 40) + ((long)b4 << 32) + ((long)b5 << 24) + ((long)b6 << 16) + ((long)b7 << 8) + (long)b8;
    }

    public final float readFloat() throws IndexOutOfBoundsException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final double readDouble() throws IndexOutOfBoundsException {
        return Double.longBitsToDouble(this.readLong());
    }

    public abstract int read();

    public abstract void read(byte[] var1, int var2, int var3) throws IndexOutOfBoundsException;

    public final String readUTF() throws IndexOutOfBoundsException, IllegalArgumentException {
        int c1;
        int byteCount;
        int len;
        int b2;
        int b1 = this.read();
        if ((b1 | (b2 = this.read())) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if ((b1 & 0x80) == 128) {
            int b4;
            int b3 = this.read();
            if ((b3 | (b4 = this.read())) < 0) {
                throw new IndexOutOfBoundsException();
            }
            len = ((b1 & 0xFFFFFF7F) << 24) + (b2 << 16) + (b3 << 8) + b4;
        } else {
            len = (b1 << 8) + b2;
        }
        this.ensureBufferSize(len);
        if (this.tempEncodingCharBuffer == null || this.tempEncodingCharBuffer.length < len) {
            this.tempEncodingCharBuffer = new char[Math.max(BinaryOutput.bufferSize(0, len), 80)];
        }
        int charCount = 0;
        this.read(this.tempEncodingByteBuffer, 0, len);
        for (byteCount = 0; byteCount < len && (c1 = this.tempEncodingByteBuffer[byteCount] & 0xFF) <= 127; ++byteCount) {
            this.tempEncodingCharBuffer[charCount++] = (char)c1;
        }
        block6: while (byteCount < len) {
            c1 = this.tempEncodingByteBuffer[byteCount] & 0xFF;
            switch (c1 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++byteCount;
                    this.tempEncodingCharBuffer[charCount++] = (char)c1;
                    continue block6;
                }
                case 12: 
                case 13: {
                    if ((byteCount += 2) > len) {
                        throw new IllegalArgumentException("Partial character at end");
                    }
                    byte c2 = this.tempEncodingByteBuffer[byteCount - 1];
                    if ((c2 & 0xC0) != 128) {
                        throw new IllegalArgumentException("malformed input around byte " + byteCount);
                    }
                    this.tempEncodingCharBuffer[charCount++] = (char)((c1 & 0x1F) << 6 | c2 & 0x3F);
                    continue block6;
                }
                case 14: {
                    if ((byteCount += 3) > len) {
                        throw new IllegalArgumentException("malformed input: partial character at end");
                    }
                    byte c2 = this.tempEncodingByteBuffer[byteCount - 2];
                    byte c3 = this.tempEncodingByteBuffer[byteCount - 1];
                    if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128) {
                        throw new IllegalArgumentException("malformed input around byte " + (byteCount - 1));
                    }
                    this.tempEncodingCharBuffer[charCount++] = (char)((c1 & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F);
                    continue block6;
                }
            }
            throw new IllegalArgumentException("malformed input around byte " + byteCount);
        }
        return new String(this.tempEncodingCharBuffer, 0, charCount);
    }

    public final Object readTypedValue() throws IndexOutOfBoundsException, IllegalArgumentException {
        byte tag = this.readByte();
        switch (tag) {
            case 10: {
                int len = this.readInt();
                Object[] arr = new Object[len];
                for (int i = 0; i < len; ++i) {
                    arr[i] = this.readTypedValue();
                }
                return arr;
            }
            case 0: {
                return null;
            }
            case 1: {
                return this.readBoolean();
            }
            case 2: {
                return this.readByte();
            }
            case 3: {
                return this.readShort();
            }
            case 4: {
                return Character.valueOf(this.readChar());
            }
            case 5: {
                return this.readInt();
            }
            case 6: {
                return this.readLong();
            }
            case 7: {
                return Float.valueOf(this.readFloat());
            }
            case 8: {
                return this.readDouble();
            }
            case 9: {
                return this.readUTF();
            }
        }
        throw new IllegalArgumentException(String.format("Unknown tag %d", tag));
    }

    public final void read(boolean[] b, int off, int len) {
        this.ensureBufferSize(len);
        this.read(this.tempEncodingByteBuffer, 0, len);
        int limit = off + len;
        int j = 0;
        for (int i = off; i < limit; ++i) {
            b[i] = this.tempEncodingByteBuffer[j++] != 0;
        }
    }

    public final void read(short[] b, int off, int len) {
        int size = len * 2;
        this.ensureBufferSize(size);
        this.read(this.tempEncodingByteBuffer, 0, size);
        int limit = off + len;
        int j = 0;
        for (int i = off; i < limit; ++i) {
            int b1 = this.tempEncodingByteBuffer[j++] & 0xFF;
            int b2 = this.tempEncodingByteBuffer[j++] & 0xFF;
            b[i] = BinaryInput.packShort(b1, b2);
        }
    }

    public final void read(char[] b, int off, int len) {
        int size = len * 2;
        this.ensureBufferSize(size);
        this.read(this.tempEncodingByteBuffer, 0, size);
        int limit = off + len;
        int j = 0;
        for (int i = off; i < limit; ++i) {
            int b1 = this.tempEncodingByteBuffer[j++] & 0xFF;
            int b2 = this.tempEncodingByteBuffer[j++] & 0xFF;
            b[i] = BinaryInput.packChar(b1, b2);
        }
    }

    public final void read(int[] b, int off, int len) {
        int size = len * 4;
        this.ensureBufferSize(size);
        this.read(this.tempEncodingByteBuffer, 0, size);
        int limit = off + len;
        int j = 0;
        for (int i = off; i < limit; ++i) {
            int b1 = this.tempEncodingByteBuffer[j++] & 0xFF;
            int b2 = this.tempEncodingByteBuffer[j++] & 0xFF;
            int b3 = this.tempEncodingByteBuffer[j++] & 0xFF;
            int b4 = this.tempEncodingByteBuffer[j++] & 0xFF;
            b[i] = BinaryInput.packInt(b1, b2, b3, b4);
        }
    }

    public final void read(long[] b, int off, int len) {
        int size = len * 8;
        this.ensureBufferSize(size);
        this.read(this.tempEncodingByteBuffer, 0, size);
        int limit = off + len;
        int j = 0;
        for (int i = off; i < limit; ++i) {
            int b1 = this.tempEncodingByteBuffer[j++] & 0xFF;
            int b2 = this.tempEncodingByteBuffer[j++] & 0xFF;
            int b3 = this.tempEncodingByteBuffer[j++] & 0xFF;
            int b4 = this.tempEncodingByteBuffer[j++] & 0xFF;
            int b5 = this.tempEncodingByteBuffer[j++] & 0xFF;
            int b6 = this.tempEncodingByteBuffer[j++] & 0xFF;
            int b7 = this.tempEncodingByteBuffer[j++] & 0xFF;
            int b8 = this.tempEncodingByteBuffer[j++] & 0xFF;
            b[i] = BinaryInput.packLong(b1, b2, b3, b4, b5, b6, b7, b8);
        }
    }

    public final void read(float[] b, int off, int len) {
        int size = len * 4;
        this.ensureBufferSize(size);
        this.read(this.tempEncodingByteBuffer, 0, size);
        int limit = off + len;
        int j = 0;
        for (int i = off; i < limit; ++i) {
            int b1 = this.tempEncodingByteBuffer[j++] & 0xFF;
            int b2 = this.tempEncodingByteBuffer[j++] & 0xFF;
            int b3 = this.tempEncodingByteBuffer[j++] & 0xFF;
            int b4 = this.tempEncodingByteBuffer[j++] & 0xFF;
            b[i] = Float.intBitsToFloat(BinaryInput.packInt(b1, b2, b3, b4));
        }
    }

    public final void read(double[] b, int off, int len) {
        int size = len * 8;
        this.ensureBufferSize(size);
        this.read(this.tempEncodingByteBuffer, 0, size);
        int limit = off + len;
        int j = 0;
        for (int i = off; i < limit; ++i) {
            int b1 = this.tempEncodingByteBuffer[j++] & 0xFF;
            int b2 = this.tempEncodingByteBuffer[j++] & 0xFF;
            int b3 = this.tempEncodingByteBuffer[j++] & 0xFF;
            int b4 = this.tempEncodingByteBuffer[j++] & 0xFF;
            int b5 = this.tempEncodingByteBuffer[j++] & 0xFF;
            int b6 = this.tempEncodingByteBuffer[j++] & 0xFF;
            int b7 = this.tempEncodingByteBuffer[j++] & 0xFF;
            int b8 = this.tempEncodingByteBuffer[j++] & 0xFF;
            b[i] = Double.longBitsToDouble(BinaryInput.packLong(b1, b2, b3, b4, b5, b6, b7, b8));
        }
    }

    public abstract ByteBuffer asByteBuffer(int var1);

    public static BinaryInput create(byte[] buffer) {
        return new ByteArrayBinaryInput(buffer);
    }

    public static BinaryInput create(byte[] buffer, int length) {
        return new ByteArrayBinaryInput(buffer, length);
    }

    public static BinaryInput create(CCharPointer address, int length) {
        return new CCharPointerInput(address, length);
    }

    private void ensureBufferSize(int len) {
        if (this.tempEncodingByteBuffer == null || this.tempEncodingByteBuffer.length < len) {
            this.tempEncodingByteBuffer = new byte[Math.max(BinaryOutput.bufferSize(0, len), 80)];
        }
    }

    private static final class ByteArrayBinaryInput
    extends BinaryInput {
        private final byte[] buffer;

        ByteArrayBinaryInput(byte[] buffer) {
            super(buffer.length);
            this.buffer = buffer;
        }

        ByteArrayBinaryInput(byte[] buffer, int length) {
            super(length);
            this.buffer = buffer;
        }

        @Override
        public int read() {
            if (this.pos >= this.length) {
                return -1;
            }
            return this.buffer[this.pos++] & 0xFF;
        }

        @Override
        public void read(byte[] b, int off, int len) {
            if (len < 0) {
                throw new IllegalArgumentException(String.format("Len must be non negative but was %d", len));
            }
            if (this.pos + len > this.length) {
                throw new IndexOutOfBoundsException();
            }
            System.arraycopy(this.buffer, this.pos, b, off, len);
            this.pos += len;
        }

        @Override
        public ByteBuffer asByteBuffer(int len) {
            ByteBuffer result = ByteBuffer.wrap(this.buffer, this.pos, len).slice().asReadOnlyBuffer();
            this.pos += len;
            return result;
        }
    }

    private static final class CCharPointerInput
    extends BinaryInput {
        private static final int BYTEBUFFER_COPY_TO_ARRAY_THRESHOLD = 6;
        private final CCharPointer address;
        private ByteBuffer byteBufferView;

        CCharPointerInput(CCharPointer address, int length) {
            super(length);
            this.address = address;
        }

        @Override
        public int read() {
            if (this.pos >= this.length) {
                return -1;
            }
            return this.address.read(this.pos++) & 0xFF;
        }

        @Override
        public void read(byte[] b, int off, int len) {
            if (len < 0) {
                throw new IllegalArgumentException(String.format("Len must be non negative but was %d", len));
            }
            if (this.pos + len > this.length) {
                throw new IndexOutOfBoundsException();
            }
            if (len > 6) {
                if (this.byteBufferView == null) {
                    this.byteBufferView = CTypeConversion.asByteBuffer((PointerBase)this.address, (int)this.length);
                }
                this.byteBufferView.position(this.pos);
                this.byteBufferView.get(b, off, len);
            } else {
                int i = 0;
                int j = this.pos;
                while (i < len) {
                    b[off + i] = this.address.read(j);
                    ++i;
                    ++j;
                }
            }
            this.pos += len;
        }

        @Override
        public ByteBuffer asByteBuffer(int len) {
            ByteBuffer result = CTypeConversion.asByteBuffer((PointerBase)this.address.addressOf(this.pos), (int)len).order(ByteOrder.BIG_ENDIAN).asReadOnlyBuffer();
            this.pos += len;
            return result;
        }
    }
}

