/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.viewers.ui.content.sph;

import com.siams.cv.monitor.model.viewer.SphKindModel;
import com.siams.cv.monitor.model.viewer.SphViewerModel;
import com.siams.cv.monitor.viewers.ui.content.RasterViewer;
import com.siams.cv.monitor.viewers.ui.content.Viewer;
import com.siams.cv.monitor.viewers.ui.content.ViewerData;
import com.siams.cv.monitor.viewers.ui.content.sph.SphViewerContent;
import com.siams.cv.monitor.viewers.ui.content.sph.SphViewerKind;
import com.siams.javafx.PaneHelper;
import com.siams.javafx.utils.FxColor;
import com.siams.javafx.utils.FxPlatform;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import java.awt.Color;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Logger;
import javafx.animation.AnimationTimer;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.MenuButton;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import net.algart.executors.api.data.SMat;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.api.data.SScalar;
import net.algart.json.Jsons;
import net.algart.math.Range;
import net.algart.math.RectangularArea;
import net.algart.math.geometry.Orthonormal3DBasis;
import net.algart.model3d.spherepolyhedra.drawing.DrawingColor;
import net.algart.model3d.spherepolyhedra.drawing.SpherePolyhedraDrawer;
import net.algart.model3d.spherepolyhedra.kinds.SpherePolyhedronKind;
import net.algart.model3d.spherepolyhedra.kinds.SpherePolyhedronKindSet;
import net.algart.model3d.spherepolyhedra.objects.SerializedSpherePolyhedra;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedra;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedronColorSelector;
import net.algart.multimatrix.MultiMatrix;
import net.algart.multimatrix.MultiMatrix2D;

public class SphViewer
extends Viewer<SphViewerModel> {
    private final Logger logger = Logger.getLogger(SphViewer.class.getCanonicalName());
    private SphViewerContent root;
    private final Map<String, UUID> nameCacheId = new HashMap<String, UUID>();
    static final String PORT_XYZR = "xyzr";
    static final String PORT_GENERATRIX_SET = "generatrix_sets";
    static final String PORT_KINDS = "kinds";
    static final String PORT_KIND_SET = "kind_set";
    private SNumbers xyzr = null;
    private SNumbers generatrixSets = null;
    private SNumbers kinds = null;
    private SScalar kindSet = null;
    private SpherePolyhedraDrawer drawer = null;
    private Orthonormal3DBasis basis = Orthonormal3DBasis.DEFAULT;
    private SpherePolyhedra spherePolyhedra = null;
    private SpherePolyhedronKindSet sphKindSet = null;
    private RectangularArea spherePolyhedraRectangular = null;
    private MouseHandler mouseHandler;
    private double scale = 20.0;
    private double xDegree = 0.0;
    private double yDegree = 0.0;
    private double zDegree = 0.0;
    private int xTranslate = 0;
    private int yTranslate = 0;
    private int dimX = 1000;
    private int dimY = 1000;
    private double zSection = 1.0;
    private boolean zSectionEnabled = true;
    private boolean upwardAxisY = true;
    private double drawnSectionZ = Double.MAX_VALUE;
    private final ViewerBoundsListener viewerBoundsListener = new ViewerBoundsListener();
    private AnimationTimer renderTimer;
    private boolean updateRender = false;
    private long lastUpdateRender = 0L;

    private void updateBasis() {
        this.basis = Orthonormal3DBasis.DEFAULT;
        this.basis = this.basis.rotateJK(Math.toRadians(this.xDegree));
        this.basis = this.basis.rotateKI(Math.toRadians(this.yDegree));
        this.basis = this.basis.rotateIJ(Math.toRadians(this.zDegree));
    }

    public SphViewer(SphViewerModel viewerModel) {
        super(viewerModel);
    }

    public void initialize() {
        this.initializeRoot();
        this.initializeMouseEvents();
        this.initializeControls();
        this.initializeAnimationTimer();
    }

    private void initializeAnimationTimer() {
        this.renderTimer = new AnimationTimer(){

            public void handle(long now) {
                if (!SphViewer.this.updateRender) {
                    return;
                }
                long throttle = 25L;
                if (System.currentTimeMillis() - SphViewer.this.lastUpdateRender < 25L) {
                    return;
                }
                SphViewer.this.render();
                SphViewer.this.updateRender = false;
                SphViewer.this.lastUpdateRender = System.currentTimeMillis();
            }
        };
        this.renderTimer.start();
    }

    private void requestRender() {
        this.updateRender = true;
    }

    private void initializeMouseEvents() {
        this.mouseHandler = new MouseHandler((Node)this.root.imageView, null);
    }

    private void initializeDrawer() {
        this.drawer = SpherePolyhedraDrawer.newOptimizedInstance((int)this.dimX, (int)this.dimY, (DrawingColor)DrawingColor.of((Color)Color.WHITE));
        this.drawer.setColor(DrawingColor.of((Color)Color.CYAN));
        if (this.sphKindSet != null) {
            this.drawer.setColorSelector(spherePolyhedron -> {
                Color color = this.sphKindSet.getFirstColor(spherePolyhedron);
                Optional opt = ((SphViewerModel)this.viewerModel).findSphKind(Long.valueOf(spherePolyhedron.kindId()));
                if (opt.isPresent()) {
                    color = ((SphKindModel)opt.get()).getVisible() == false ? SpherePolyhedronColorSelector.TRANSPARENT : FxColor.toAwtColor((String)((SphKindModel)opt.get()).getColor());
                }
                return color;
            });
        } else {
            this.drawer.setColorSelector(spherePolyhedron -> Color.CYAN);
        }
        this.updateBasis();
        this.updateSection();
        this.scale = this.autoAdjustScale();
    }

    private void updateSection() {
        if (this.zSectionEnabled && this.spherePolyhedra != null) {
            Range zRange = SpherePolyhedraDrawer.estimateDrawnZRange((Orthonormal3DBasis)this.basis, (double)this.scale, (SpherePolyhedra)this.spherePolyhedra);
            this.drawnSectionZ = zRange.min() + this.zSection * zRange.size();
        } else {
            this.drawnSectionZ = Double.POSITIVE_INFINITY;
        }
    }

    private void drawAxes(SpherePolyhedraDrawer drawer, int dimX, int dimY, int x0, int y0, Orthonormal3DBasis basis) {
        Color AXIS_X_COLOR = new Color(0xFF8080);
        Color AXIS_Y_COLOR = new Color(0x80FF80);
        Color AXIS_Z_COLOR = new Color(0xC0C0FF);
        double d = Math.max(dimX, dimY);
        drawer.setColor(DrawingColor.BLACK);
        drawer.setAlternateColor(DrawingColor.of((Color)AXIS_X_COLOR));
        drawer.drawGradientLine((double)x0 + basis.x(-d, 0.0, 0.0), (double)y0 + basis.y(-d, 0.0, 0.0), basis.z(-d, 0.0, 0.0), (double)x0 + basis.x(d, 0.0, 0.0), (double)y0 + basis.y(d, 0.0, 0.0), basis.z(d, 0.0, 0.0));
        drawer.setAlternateColor(DrawingColor.of((Color)AXIS_Y_COLOR));
        drawer.drawGradientLine((double)x0 + basis.x(0.0, -d, 0.0), (double)y0 + basis.y(0.0, -d, 0.0), basis.z(0.0, -d, 0.0), (double)x0 + basis.x(0.0, d, 0.0), (double)y0 + basis.y(0.0, d, 0.0), basis.z(0.0, d, 0.0));
        drawer.setAlternateColor(DrawingColor.of((Color)AXIS_Z_COLOR));
        drawer.drawGradientLine((double)x0 + basis.x(0.0, 0.0, -d), (double)y0 + basis.y(0.0, 0.0, -d), basis.z(0.0, 0.0, -d), (double)x0 + basis.x(0.0, 0.0, d), (double)y0 + basis.y(0.0, 0.0, d), basis.z(0.0, 0.0, d));
    }

    private void initializeRoot() {
        this.root = new SphViewerContent(this);
    }

    @Override
    protected void initializeControls() {
        this.root.btnZoomIn.getStyleClass().add((Object)"zoom-in");
        this.root.btnZoomIn.setOnAction(event -> {
            this.scale *= 2.0;
            this.requestRender();
        });
        this.root.btnZoomOut.getStyleClass().add((Object)"zoom-out");
        this.root.btnZoomOut.setOnAction(event -> {
            this.scale = Math.max(this.scale / 2.0, 1.0);
            this.requestRender();
        });
        this.root.btnResetZoom.getStyleClass().add((Object)"reset");
        this.root.btnResetZoom.setOnAction(event -> {
            this.scale = this.autoAdjustScale();
            this.xDegree = 0.0;
            this.yDegree = 0.0;
            this.zDegree = 0.0;
            this.updateBasis();
            this.requestRender();
        });
        this.root.rasterContainer.layoutBoundsProperty().addListener((ChangeListener)this.viewerBoundsListener);
        this.root.cbCuttingZPlane.setOnAction(event -> {
            this.zSectionEnabled = this.root.cbCuttingZPlane.isSelected();
            this.updateSection();
            this.requestRender();
        });
        this.root.cbUpwardAxisY.setOnAction(event -> {
            this.upwardAxisY = this.root.cbUpwardAxisY.isSelected();
            this.requestRender();
        });
        this.root.sliderCuttingZPlane.setMin(0.0);
        this.root.sliderCuttingZPlane.setMax(1.0);
        this.root.sliderCuttingZPlane.setBlockIncrement(0.01);
        this.root.sliderCuttingZPlane.valueProperty().addListener((ob, o, n) -> {
            this.zSection = n.doubleValue();
            this.root.spinnerCuttingZPane.getEditor().setText(String.format("%.2f", this.zSection));
            if (this.zSectionEnabled) {
                this.updateSection();
                this.requestRender();
            }
        });
        this.root.spinnerCuttingZPane.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.DoubleSpinnerValueFactory(0.0, 1.0, 0.0, 0.01));
        this.root.spinnerCuttingZPane.valueProperty().addListener((ob, o, n) -> {
            this.zSection = n;
            this.root.sliderCuttingZPlane.setValue(this.zSection);
            if (this.zSectionEnabled) {
                this.updateSection();
                this.requestRender();
            }
        });
        this.root.cmiZoomControls.setOnAction(event -> {
            CheckMenuItem item = (CheckMenuItem)event.getSource();
            boolean isSelected = item.isSelected();
            this.root.vBoxZoomControls.setManaged(isSelected);
            this.root.vBoxZoomControls.setVisible(isSelected);
        });
        this.root.spinnerXRotation.getEditor().setText(String.valueOf(this.xDegree));
        this.root.spinnerXRotation.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.IntegerSpinnerValueFactory(-360, 360, 0, 1));
        this.root.spinnerXRotation.valueProperty().addListener((ob, o, n) -> {
            this.xDegree = n.intValue();
            this.updateBasis();
            this.requestRender();
        });
        this.root.spinnerYRotation.getEditor().setText(String.valueOf(this.yDegree));
        this.root.spinnerYRotation.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.IntegerSpinnerValueFactory(-360, 360, 0, 1));
        this.root.spinnerYRotation.valueProperty().addListener((ob, o, n) -> {
            this.yDegree = n.intValue();
            this.updateBasis();
            this.requestRender();
        });
        this.root.spinnerZRotation.getEditor().setText(String.valueOf(this.zDegree));
        this.root.spinnerZRotation.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.IntegerSpinnerValueFactory(-360, 360, 0, 1));
        this.root.spinnerZRotation.valueProperty().addListener((ob, o, n) -> {
            this.zDegree = n.intValue();
            this.updateBasis();
            this.requestRender();
        });
    }

    private double autoAdjustScale() {
        if (this.spherePolyhedraRectangular == null) {
            return 0.0;
        }
        double maxSize = Math.max(Math.max(this.spherePolyhedraRectangular.sizeX(), this.spherePolyhedraRectangular.sizeY()), this.spherePolyhedraRectangular.sizeZ());
        return 0.8 * (double)this.dimX / maxSize;
    }

    @Override
    protected void render(ViewerData viewerData) {
        this.xyzr = viewerData.get(PORT_XYZR, SNumbers.class).orElse(SNumbers.zeros(Double.TYPE, (int)0, (int)3));
        this.generatrixSets = viewerData.get(PORT_GENERATRIX_SET, SNumbers.class).orElse(null);
        this.kinds = viewerData.get(PORT_KINDS, SNumbers.class).orElse(null);
        this.kindSet = viewerData.get(PORT_KIND_SET, SScalar.class).orElse(null);
        this.sphKindSet = null;
        this.spherePolyhedra = null;
        this.drawer = null;
        this.spherePolyhedraRectangular = null;
        this.xyzr = this.xyzr == null ? (this.xyzr = SNumbers.zeros(Double.TYPE, (int)0, (int)3)) : this.xyzr;
        try {
            this.spherePolyhedra = SpherePolyhedra.deserialize((SerializedSpherePolyhedra)new SerializedSpherePolyhedra().setCoordinates(this.xyzr.toDoubleArray(), this.xyzr.getBlockLength()).setSerializedGeneratrixSets(this.generatrixSets != null ? this.generatrixSets.toIntArray() : null).setKindIds(this.kinds != null ? this.kinds.toLongArray() : null));
            this.spherePolyhedraRectangular = this.spherePolyhedra.containingAllParallelepiped();
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Cannot load sphere-polyhedra", e);
        }
        if (this.kindSet != null) {
            this.sphKindSet = SpherePolyhedronKindSet.of((JsonObject)Jsons.toJson((String)this.kindSet.getValue()), (boolean)true);
        }
        this.updateSphKinds();
        this.initializeDrawer();
        this.requestRender();
    }

    @Override
    public void embed(Pane viewerContainer) {
        viewerContainer.getChildren().add((Object)this.root);
        PaneHelper.setAnchorZero((Node)this.root);
    }

    @Override
    public Pane provideControls() {
        return null;
    }

    @Override
    public Node provideView() {
        return this.root.imageView;
    }

    @Override
    public List<Node> provideTools() {
        return new LinkedList<MenuButton>(List.of(this.root.mbView));
    }

    @Override
    public void release() {
        super.release();
        this.root.rasterContainer.layoutBoundsProperty().removeListener((ChangeListener)this.viewerBoundsListener);
        this.renderTimer.stop();
    }

    public void restorePreference() {
        this.scale = ((SphViewerModel)this.viewerModel).getScale();
        this.xDegree = ((SphViewerModel)this.viewerModel).getXRotateDegree();
        this.yDegree = ((SphViewerModel)this.viewerModel).getYRotateDegree();
        this.zDegree = ((SphViewerModel)this.viewerModel).getZRotateDegree();
        this.xTranslate = ((SphViewerModel)this.viewerModel).getXTranslate();
        this.yTranslate = ((SphViewerModel)this.viewerModel).getYTranslate();
        this.zSection = ((SphViewerModel)this.viewerModel).getZSection();
        this.zSectionEnabled = ((SphViewerModel)this.viewerModel).getZSectionEnabled();
        this.upwardAxisY = ((SphViewerModel)this.viewerModel).getUpwardAxisY();
    }

    public void savePreference() {
        ((SphViewerModel)this.viewerModel).setScale(Double.valueOf(this.scale));
        ((SphViewerModel)this.viewerModel).setXRotateDegree(Double.valueOf(this.xDegree));
        ((SphViewerModel)this.viewerModel).setYRotateDegree(Double.valueOf(this.yDegree));
        ((SphViewerModel)this.viewerModel).setZRotateDegree(Double.valueOf(this.zDegree));
        ((SphViewerModel)this.viewerModel).setXTranslate(Integer.valueOf(this.xTranslate));
        ((SphViewerModel)this.viewerModel).setYTranslate(Integer.valueOf(this.yTranslate));
        ((SphViewerModel)this.viewerModel).setZSection(Double.valueOf(this.zSection));
        ((SphViewerModel)this.viewerModel).setZSectionEnabled(Boolean.valueOf(this.zSectionEnabled));
        ((SphViewerModel)this.viewerModel).setUpwardAxisY(Boolean.valueOf(this.upwardAxisY));
        ((SphViewerModel)this.viewerModel).setSplitterPosition(Double.valueOf(this.root.splitPaneControls.getDividerPositions()[0]));
        ((SphViewerModel)this.viewerModel).setDisplayZoomControls(Boolean.valueOf(this.root.cmiZoomControls.isSelected()));
    }

    private void render() {
        if (this.drawer == null) {
            return;
        }
        if (this.spherePolyhedra == null) {
            return;
        }
        long t1 = System.currentTimeMillis();
        this.drawer.clear();
        this.drawAxes(this.drawer, this.dimX, this.dimY, this.dimX / 2 + this.xTranslate, this.dimY / 2 + this.yTranslate, this.basis);
        this.drawer.setSectionZ(this.drawnSectionZ);
        this.drawer.drawSpherePolyhedra((double)(this.dimX / 2 + this.xTranslate), (double)(this.dimY / 2 + this.yTranslate), this.basis, this.scale, this.spherePolyhedra);
        MultiMatrix2D result = MultiMatrix.of2DRGBA((List)this.drawer.rgbMatrices(this.upwardAxisY));
        SMat mat = SMat.of((MultiMatrix)result);
        WritableImage image = RasterViewer.writableImageFromSMat(mat);
        FxPlatform.RunFxThread(() -> this.root.imageView.setImage((Image)image));
        this.root.spinnerXRotation.getEditor().setText(String.valueOf((int)this.xDegree));
        this.root.spinnerYRotation.getEditor().setText(String.valueOf((int)this.yDegree));
        this.root.spinnerZRotation.getEditor().setText(String.valueOf((int)this.zDegree));
        this.logger.fine(String.format("SphViewer render: %d ms", System.currentTimeMillis() - t1));
    }

    private void updateSphKinds() {
        Platform.runLater(() -> {
            this.root.vbSphKinds.getChildren().clear();
            HashSet<Long> kindIds = new HashSet<Long>();
            if (this.kinds != null && !this.kinds.isEmpty() && this.kinds.isInitialized()) {
                for (long id : this.kinds.toLongArray()) {
                    kindIds.add(id);
                }
            }
            if (this.kindSet != null && this.kindSet.isInitialized()) {
                JsonObject jsonKindSet = Json.createReader((Reader)new StringReader(this.kindSet.getValue())).readObject();
                List kindSet = SpherePolyhedronKindSet.readKinds((JsonObject)jsonKindSet);
                Iterator iterator = kindIds.iterator();
                while (iterator.hasNext()) {
                    long kindId = (Long)iterator.next();
                    Optional<SpherePolyhedronKind> opt = kindSet.stream().filter(kind -> kind.getId() == kindId).findFirst();
                    SphKindModel sphKindModel = ((SphViewerModel)this.viewerModel).findSphKind(Long.valueOf(kindId)).orElseGet(() -> {
                        Object kindName;
                        SphKindModel prjSphKind = new SphKindModel();
                        prjSphKind.setId(Long.valueOf(kindId));
                        prjSphKind.setVisible(Boolean.valueOf(true));
                        opt.ifPresent(kind -> prjSphKind.setColor(FxColor.toHex((Color)kind.getColor(), (boolean)false)));
                        Object object = kindName = kindId == 0L ? "$" : SpherePolyhedronKind.idToFriendlyString((long)kindId);
                        if (kindId <= 0L) {
                            kindName = (String)kindName + " (system)";
                        }
                        prjSphKind.setName((String)kindName);
                        ((SphViewerModel)this.viewerModel).addSphKind(prjSphKind);
                        return prjSphKind;
                    });
                    SphViewerKind sphViewerKind = new SphViewerKind(sphKindModel);
                    sphViewerKind.addListener((ob, o, n) -> this.requestRender());
                    this.root.vbSphKinds.getChildren().add((Object)sphViewerKind);
                }
            }
        });
    }

    class ViewerBoundsListener
    implements ChangeListener<Bounds> {
        ViewerBoundsListener() {
        }

        public void changed(ObservableValue observable, Bounds oldValue, Bounds newValue) {
            int dim;
            int height;
            int width = (int)Math.max(Math.min(newValue.getWidth(), 1000.0), 100.0);
            if (width % 2 == 1) {
                ++width;
            }
            if ((height = (int)Math.max(Math.min(newValue.getHeight(), 1000.0), 100.0)) % 2 == 1) {
                ++height;
            }
            SphViewer.this.dimX = dim = Math.min(width, height);
            SphViewer.this.dimY = dim;
            SphViewer.this.initializeDrawer();
            SphViewer.this.requestRender();
        }
    }

    private class MouseHandler {
        protected Node eventConsumer;
        protected Node eventTarget;
        protected MouseButton dragMouseButton = MouseButton.NONE;
        protected DragInfo dragInfoScreen = new DragInfo();
        protected DragInfo dragInfoLocal = new DragInfo();
        protected EventConsumptionMode eventConsumptionMode = EventConsumptionMode.DEFAULT;
        private double xRotateStart = 0.0;
        private double yRotateStart = 0.0;
        private double zRotateStart = 0.0;
        private double xTranslateStart = 0.0;
        private double yTranslateStart = 0.0;
        private double zSectionStart = 0.0;

        private MouseHandler(Node eventConsumer, Node eventTarget) {
            this.eventConsumer = eventConsumer;
            this.eventTarget = eventTarget;
            this.initialize();
        }

        private void initialize() {
            this.initializePressHandler();
            this.initializeDragHandler();
            this.initializeReleaseHandler();
        }

        private void initializePressHandler() {
            switch (this.eventConsumptionMode.ordinal()) {
                case 2: {
                    this.eventConsumer.setOnMousePressed(this::onMousePressedHandle);
                    break;
                }
                case 0: {
                    this.eventConsumer.addEventFilter(MouseEvent.MOUSE_PRESSED, this::onMousePressedHandle);
                    break;
                }
                case 1: {
                    this.eventConsumer.addEventHandler(MouseEvent.MOUSE_PRESSED, this::onMousePressedHandle);
                }
            }
        }

        private void initializeDragHandler() {
            switch (this.eventConsumptionMode.ordinal()) {
                case 2: {
                    this.eventConsumer.setOnMouseDragged(this::onMouseDraggedHandle);
                    break;
                }
                case 0: {
                    this.eventConsumer.addEventFilter(MouseEvent.MOUSE_DRAGGED, this::onMouseDraggedHandle);
                    break;
                }
                case 1: {
                    this.eventConsumer.addEventHandler(MouseEvent.MOUSE_DRAGGED, this::onMouseDraggedHandle);
                }
            }
        }

        private void initializeReleaseHandler() {
            switch (this.eventConsumptionMode.ordinal()) {
                case 2: {
                    this.eventConsumer.setOnMouseReleased(this::onMouseReleasedHandle);
                    break;
                }
                case 0: {
                    this.eventConsumer.addEventFilter(MouseEvent.MOUSE_RELEASED, this::onMouseReleasedHandle);
                    break;
                }
                case 1: {
                    this.eventConsumer.addEventHandler(MouseEvent.MOUSE_RELEASED, this::onMouseReleasedHandle);
                }
            }
        }

        private void onMousePressedHandle(MouseEvent event) {
            if (this.dragMouseButton == MouseButton.NONE || event.getButton() == this.dragMouseButton) {
                this.dragInfoScreen.startDrag(event.getScreenX(), event.getScreenY());
                this.dragInfoLocal.startDrag(event.getX(), event.getY());
                this.onPress(event);
            }
        }

        private void onMouseDraggedHandle(MouseEvent event) {
            if (this.dragMouseButton == MouseButton.NONE || event.getButton() == this.dragMouseButton) {
                this.dragInfoScreen.dragTo(event.getScreenX(), event.getScreenY());
                this.dragInfoLocal.dragTo(this.dragInfoLocal.distanceX + event.getX(), this.dragInfoLocal.distanceY + event.getY());
                this.onDrag(event);
            }
        }

        private void onMouseReleasedHandle(MouseEvent event) {
            if (this.dragMouseButton == MouseButton.NONE || event.getButton() == this.dragMouseButton) {
                this.onRelease(event);
            }
        }

        private void onPress(MouseEvent event) {
            this.xRotateStart = SphViewer.this.xDegree;
            this.yRotateStart = SphViewer.this.yDegree;
            this.zRotateStart = SphViewer.this.zDegree;
            this.xTranslateStart = SphViewer.this.xTranslate;
            this.yTranslateStart = SphViewer.this.yTranslate;
            this.zSectionStart = SphViewer.this.drawer.getSectionZ();
        }

        private void onDrag(MouseEvent event) {
            double factor = 0.5;
            if (event.isControlDown()) {
                SphViewer.this.zSection = this.zSectionStart + this.dragInfoScreen.distanceY;
            } else if (event.isPrimaryButtonDown()) {
                SphViewer.this.xDegree = this.xRotateStart + this.dragInfoScreen.distanceY * factor;
                SphViewer.this.yDegree = this.yRotateStart + this.dragInfoScreen.distanceX * factor;
                SphViewer.this.updateBasis();
            } else if (event.isSecondaryButtonDown()) {
                SphViewer.this.xTranslate = (int)(this.xTranslateStart + this.dragInfoScreen.distanceX);
                SphViewer.this.yTranslate = (int)(this.yTranslateStart - this.dragInfoScreen.distanceY);
            }
            SphViewer.this.requestRender();
        }

        private void onRelease(MouseEvent event) {
        }
    }

    private static enum EventConsumptionMode {
        CAPTURING,
        BUBBLING,
        DEFAULT;

    }

    private static class DragInfo {
        public double startX;
        public double startY;
        public double distanceX;
        public double distanceY;

        private DragInfo() {
        }

        public void startDrag(double x, double y) {
            this.startX = x;
            this.startY = y;
            this.distanceX = 0.0;
            this.distanceY = 0.0;
        }

        public void dragTo(double x, double y) {
            this.distanceX = x - this.startX;
            this.distanceY = y - this.startY;
        }
    }
}

