/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.viewers.ui.content;

import com.siams.cv.monitor.model.viewer.ViewerModel;
import com.siams.cv.monitor.viewers.ui.content.IRasterViewerContent;
import com.siams.cv.monitor.viewers.ui.content.ImageViewRectChangeListener;
import com.siams.cv.monitor.viewers.ui.content.RasterViewerStatusBar;
import com.siams.cv.monitor.viewers.ui.content.ViewRect;
import com.siams.cv.monitor.viewers.ui.content.Viewer;
import com.siams.cv.monitor.viewers.ui.content.ViewerData;
import com.siams.cv.monitor.viewers.ui.content.ViewerStateHandler;
import com.siams.notifications.StareNotification;
import com.siams.stare.utils.SMatUtils;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.util.Map;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.canvas.Canvas;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.input.MouseEvent;
import javafx.scene.shape.Rectangle;
import net.algart.executors.api.data.Data;
import net.algart.executors.api.data.SMat;

public abstract class RasterViewer<T extends ViewerModel>
extends Viewer<T>
implements ImageViewRectChangeListener {
    protected RasterViewerStatusBar statusBar;
    protected Image image;
    protected ViewRect imageViewRect;
    protected SimpleBooleanProperty propertyEnabled = new SimpleBooleanProperty(true);
    protected SimpleDoubleProperty propertyOpacity = new SimpleDoubleProperty(1.0);
    protected ViewerStateHandler viewerStateHandler = null;

    public RasterViewer(T model) {
        super(model);
    }

    @Override
    public abstract void onChangeImageViewRect(ViewRect var1);

    public abstract void renderImage(Image var1);

    public void initializeImageViewRect() {
        this.imageViewRect = new ViewRect();
    }

    public void setImage(Image image) {
        this.image = image;
        if (image != null) {
            this.imageViewRect.setImageSize(image.getWidth(), image.getHeight());
        }
    }

    public Image getImage() {
        return this.image;
    }

    public boolean isEnabled() {
        return this.propertyEnabled.get();
    }

    public SimpleBooleanProperty getPropertyEnabled() {
        return this.propertyEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.propertyEnabled.set(enabled);
    }

    public void setOpacity(double opacity) {
        this.propertyOpacity.set(opacity);
    }

    public SimpleDoubleProperty getPropertyOpacity() {
        return this.propertyOpacity;
    }

    public double getOpacity() {
        return this.propertyOpacity.get();
    }

    public ViewRect getImageViewRect() {
        return this.imageViewRect;
    }

    public double[] getPixelValue(int x, int y) {
        SMat data = this.extractDefaultData(this.viewerDataSource.getData().orElse(null));
        return SMatUtils.getPixelValue((Data)data, (int)x, (int)y);
    }

    public ViewerStateHandler getViewerStateHandler() {
        return this.viewerStateHandler;
    }

    public void clear() {
        this.image = null;
        this.imageViewRect.setImageSize(0.0, 0.0);
        this.imageViewRect.setScale(1.0);
        this.imageViewRect.setX(0.0);
        this.imageViewRect.setY(0.0);
        Canvas canvas = this.getRasterViewerContent().getCanvas();
        canvas.getGraphicsContext2D().clearRect(0.0, 0.0, canvas.getWidth(), canvas.getHeight());
    }

    @Override
    public void release() {
        super.release();
        if (this.imageViewRect != null) {
            this.imageViewRect.release();
            this.imageViewRect = null;
        }
        this.image = null;
        this.viewerStateHandler = null;
    }

    public void restorePreference() {
        this.propertyOpacity.setValue((Number)this.viewerModel.getOpacity());
        this.propertyEnabled.setValue(this.viewerModel.getEnabled());
    }

    public void savePreference() {
        this.viewerModel.setOpacity(this.propertyOpacity.getValue());
        this.viewerModel.setEnabled(this.propertyEnabled.getValue());
    }

    public static WritableImage writableImageFromSMat(SMat source) {
        if (source == null || !source.isInitialized()) {
            return null;
        }
        switch (source.getNumberOfChannels()) {
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Can't represent SMat with %d channels as WritableImage. Supported channels are 1, 3 or 4.", source.getNumberOfChannels()));
            }
        }
        return SwingFXUtils.toFXImage((BufferedImage)source.toBufferedImage(), null);
    }

    public static Image scaleImage(Image image, double scale) {
        if (scale == 1.0) {
            return image;
        }
        BufferedImage bi = SwingFXUtils.fromFXImage((Image)image, null);
        int newWidth = (int)(image.getWidth() * scale);
        int newHeight = (int)(image.getHeight() * scale);
        BufferedImage biScaled = new BufferedImage(newWidth, newHeight, 2);
        AffineTransform at = new AffineTransform();
        at.scale(scale, scale);
        AffineTransformOp scaleOp = new AffineTransformOp(at, 1);
        scaleOp.filter(bi, biScaled);
        return SwingFXUtils.toFXImage((BufferedImage)biScaled, null);
    }

    protected abstract void updatePixelValue(int var1, int var2);

    protected abstract IRasterViewerContent getRasterViewerContent();

    protected void initializeStatusBar() {
        this.statusBar = new RasterViewerStatusBar();
    }

    protected void onRasterContainerClicked(MouseEvent event) {
    }

    protected void moveHighlighter(int mouseX, int mouseY) {
        Rectangle highlighter = this.getRasterViewerContent().getHighlighter();
        if (highlighter == null) {
            return;
        }
        if (this.imageViewRect == null) {
            return;
        }
        if (this.imageViewRect.getScale() > 1.0) {
            int scale = (int)this.imageViewRect.getScale();
            highlighter.setVisible(true);
            highlighter.setManaged(true);
            highlighter.setWidth((double)scale);
            highlighter.setHeight((double)scale);
            int x = (int)this.imageViewRect.getX();
            int y = (int)this.imageViewRect.getY();
            int shiftX = (double)x < 0.0 ? (scale - Math.abs(x)) % scale : x % scale;
            int shiftY = (double)y < 0.0 ? (scale - Math.abs(y)) % scale : y % scale;
            int discreteX = (mouseX - shiftX) / scale * scale;
            int discreteY = (mouseY - shiftY) / scale * scale;
            highlighter.setX((double)(shiftX + discreteX));
            highlighter.setY((double)(shiftY + discreteY));
        } else {
            highlighter.setVisible(false);
            highlighter.setManaged(false);
        }
    }

    protected SMat extractDefaultData(ViewerData viewerData) {
        Map<String, Data> map;
        SMat sMat = null;
        if (viewerData != null && (map = viewerData.getData()) != null) {
            for (String name : map.keySet()) {
                Data data = map.get(name);
                if (data == null || !SMat.class.isAssignableFrom(data.getClass())) continue;
                sMat = (SMat)data;
            }
        }
        return sMat;
    }

    private void setNewImageSize(Data data) {
        if (data != null) {
            if (SMat.class.isAssignableFrom(data.getClass())) {
                SMat sMat = (SMat)data;
                this.imageViewRect.setImageSize((int)sMat.getDimX(), (int)sMat.getDimY());
            } else {
                StareNotification.showWarn((String)"Can't set image size: unknown Data type");
            }
        }
    }

    @Override
    public void onViewerDataReceived(ViewerData viewerData) {
        this.setNewImageSize((Data)this.extractDefaultData(viewerData));
        this.render(viewerData);
        if (this.viewerStateHandler != null) {
            this.viewerStateHandler.onViewerStateChanged();
        }
    }
}

