/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.viewers.ui.content;

import com.siams.cv.monitor.model.viewer.ImageViewerModel;
import com.siams.cv.monitor.viewers.ui.content.BaseImageViewer;
import com.siams.cv.monitor.viewers.ui.content.BaseImageViewerContent;
import com.siams.cv.monitor.viewers.ui.content.BaseImageViewerControls;
import com.siams.cv.monitor.viewers.ui.content.IBaseImageViewerContent;
import com.siams.cv.monitor.viewers.ui.content.IRasterViewerContent;
import com.siams.cv.monitor.viewers.ui.content.ImageViewerControls;
import com.siams.cv.monitor.viewers.ui.content.RasterViewer;
import com.siams.cv.monitor.viewers.ui.content.SMatActionAutoContrast;
import com.siams.cv.monitor.viewers.ui.content.SMatActionSimpleThreshold;
import com.siams.cv.monitor.viewers.ui.content.ViewerData;
import java.util.List;
import java.util.logging.Logger;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.image.Image;
import net.algart.executors.api.data.SMat;

public class ImageViewer
extends BaseImageViewer<ImageViewerModel> {
    private final Logger logger = Logger.getLogger(ImageViewer.class.getCanonicalName());
    private SMatActionAutoContrast autoContrast;
    private SMatActionSimpleThreshold simpleThreshold;
    protected ImageViewerContent root;

    public ImageViewer(ImageViewerModel model) {
        super(model);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.initializeSMatActions();
    }

    @Override
    protected void initializeRoot() {
        this.root = new ImageViewerContent((ImageViewerModel)this.viewerModel);
        this.root.setOnBoundsChangedCallback(() -> this.renderImage(this.image));
    }

    private void initializeSMatActions() {
        this.autoContrast = new SMatActionAutoContrast();
        this.simpleThreshold = new SMatActionSimpleThreshold(false, 0.0, 1.0, false);
        this.autoContrast.setNext(this.simpleThreshold);
    }

    @Override
    protected IBaseImageViewerContent getBaseContent() {
        return this.root;
    }

    @Override
    protected IRasterViewerContent getRasterViewerContent() {
        return this.root;
    }

    @Override
    protected BaseImageViewerControls createImageViewControls() {
        return new ImageViewerControls(this);
    }

    @Override
    public List<Node> provideTools() {
        List<Node> baseTools = super.provideTools();
        baseTools.add((Node)this.root.cbAutoContrast);
        return baseTools;
    }

    @Override
    protected void render(ViewerData viewerData) {
        this.getRasterData().ifPresent(sMat -> {
            Image image = this.preprocessImage((SMat)sMat);
            this.setImage(image);
            this.renderImage(image);
        });
    }

    protected Image preprocessImage(SMat data) {
        this.autoContrast.setEnabled(((ImageViewerModel)this.viewerModel).getAutoContrastEnabled());
        this.simpleThreshold.setEnabled(((ImageViewerModel)this.viewerModel).getSimpleThresholdEnabled());
        this.simpleThreshold.setInvert(((ImageViewerModel)this.viewerModel).getSimpleThresholdInverted());
        this.simpleThreshold.setMin(((ImageViewerModel)this.viewerModel).getSimpleThresholdRangeMin());
        this.simpleThreshold.setMax(((ImageViewerModel)this.viewerModel).getSimpleThresholdRangeMax());
        this.simpleThreshold.setRaw(((ImageViewerModel)this.viewerModel).getSimpleThresholdRawValues());
        SMat processed = this.autoContrast.execute(data);
        return RasterViewer.writableImageFromSMat(processed);
    }

    public void setAutoContrastEnabled(boolean enabled) {
        ((ImageViewerModel)this.viewerModel).setAutoContrastEnabled(Boolean.valueOf(enabled));
    }

    public void setRangeEnabled(boolean enabled) {
        ((ImageViewerModel)this.viewerModel).setSimpleThresholdEnabled(Boolean.valueOf(enabled));
    }

    public void setRangeInverted(boolean inverted) {
        ((ImageViewerModel)this.viewerModel).setSimpleThresholdInverted(Boolean.valueOf(inverted));
    }

    public void setRangeMin(double min) {
        ((ImageViewerModel)this.viewerModel).setSimpleThresholdRangeMin(Double.valueOf(min));
    }

    public void setRangeMax(double max) {
        ((ImageViewerModel)this.viewerModel).setSimpleThresholdRangeMax(Double.valueOf(max));
    }

    void setRangeRawValues(boolean rawValues) {
        ((ImageViewerModel)this.viewerModel).setSimpleThresholdRawValues(Boolean.valueOf(rawValues));
    }

    @Override
    public void restorePreference() {
        super.restorePreference();
    }

    @Override
    public void savePreference() {
        super.savePreference();
    }

    private class ImageViewerContent
    extends BaseImageViewerContent<ImageViewerModel> {
        ImageViewerContent(ImageViewerModel viewerModel) {
            super(viewerModel);
            this.rasterContainer.layoutBoundsProperty().addListener((ob, o, n) -> {
                this.canvas.setWidth(n.getWidth());
                this.canvas.setHeight(n.getHeight());
                ImageViewer.this.renderImage(ImageViewer.this.image);
            });
            this.initializeAutoContrastControl(viewerModel);
        }

        private void initializeAutoContrastControl(ImageViewerModel viewerModel) {
            this.cbAutoContrast = new CheckBox("Autocontrast");
            this.cbAutoContrast.setSelected(viewerModel.getAutoContrastEnabled().booleanValue());
            this.cbAutoContrast.setOnAction(event -> {
                boolean enabled = ((CheckBox)event.getSource()).isSelected();
                ImageViewer.this.setAutoContrastEnabled(enabled);
                ImageViewer.this.viewerDataSource.getData().ifPresent(ImageViewer.this::render);
            });
        }

        @Override
        public void center() {
            double valX = (this.canvas.getWidth() - ImageViewer.this.image.getWidth() * ImageViewer.this.imageViewRect.getScale()) / 2.0;
            double valY = (this.canvas.getHeight() - ImageViewer.this.image.getHeight() * ImageViewer.this.imageViewRect.getScale()) / 2.0;
            ImageViewer.this.imageViewRect.setX(valX);
            ImageViewer.this.imageViewRect.setY(valY);
        }
    }
}

