/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.viewers.ui.content;

import java.util.function.Consumer;
import javafx.css.Styleable;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.Toggle;

class DefaultPinHandler
implements EventHandler<ActionEvent> {
    private final Consumer<Boolean> pinConsumer;

    DefaultPinHandler(Consumer<Boolean> pinEventHandler) {
        this.pinConsumer = pinEventHandler;
    }

    public void handle(ActionEvent event) {
        Object source = event.getSource();
        boolean pinned = false;
        if (Toggle.class.isAssignableFrom(source.getClass())) {
            Toggle toggle = (Toggle)source;
            pinned = toggle.isSelected();
        }
        if (Styleable.class.isAssignableFrom(source.getClass())) {
            Styleable styleable = (Styleable)source;
            if (pinned) {
                styleable.getStyleClass().remove((Object)"unpinned");
                styleable.getStyleClass().add((Object)"pinned");
            } else {
                styleable.getStyleClass().remove((Object)"pinned");
                styleable.getStyleClass().add((Object)"unpinned");
            }
        }
        if (this.pinConsumer != null) {
            this.pinConsumer.accept(pinned);
        }
    }
}

