/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.viewers.ui.content;

import com.siams.cv.monitor.viewers.ui.content.ViewRect;
import com.siams.stare.utils.Rect;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;

public class CropViewRect
extends ViewRect {
    private BooleanProperty selectionModeProperty;
    private Rect cropRect = new Rect();
    private AnchorPane cropArea;

    public void bindSelectionMode(BooleanProperty masterProperty) {
        this.selectionModeProperty = BooleanProperty.booleanProperty((Property)masterProperty);
    }

    public void setCropArea(AnchorPane cropArea) {
        this.cropArea = cropArea;
        this.cropRect = new Rect(cropArea.getLayoutX(), cropArea.getLayoutY(), cropArea.getWidth(), cropArea.getHeight());
    }

    public AnchorPane getCropArea() {
        return this.cropArea;
    }

    public Rect getCropRect() {
        return this.cropRect;
    }

    public void screenToRect() {
        double cropX = this.screenToImageX(this.cropArea.getLayoutX());
        double cropY = this.screenToImageY(this.cropArea.getLayoutY());
        double cropWidth = this.screenToImageX(this.cropArea.getLayoutX() + this.cropArea.getWidth()) - cropX;
        double cropHeight = this.screenToImageY(this.cropArea.getLayoutY() + this.cropArea.getHeight()) - cropY;
        this.cropRect.set(cropX, cropY, cropWidth, cropHeight);
    }

    @Override
    public void release() {
        super.release();
        if (this.selectionModeProperty.isBound()) {
            this.selectionModeProperty.unbind();
        }
    }

    private void resizeCropArea(double eventX, double eventY) {
        double newLayoutX = this.mouseTranslateX > 0.0 ? this.mousePressedX : eventX;
        double newLayoutY = this.mouseTranslateY > 0.0 ? this.mousePressedY : eventY;
        double newWidth = Math.abs(this.mousePressedX - eventX);
        double newHeight = Math.abs(this.mousePressedY - eventY);
        if (this.screenToImageX(newLayoutX + newWidth) > this.imageWidth) {
            newWidth = this.imageWidth - this.screenToImageX(newLayoutX);
            newWidth *= this.scale;
        }
        if (this.screenToImageY(newLayoutY + newHeight) > this.imageHeight) {
            newHeight = this.imageHeight - this.screenToImageY(newLayoutY);
            newHeight *= this.scale;
        }
        if (this.screenToImageX(newLayoutX) >= 0.0) {
            this.cropArea.setLayoutX(newLayoutX);
            this.cropArea.setPrefWidth(newWidth);
        }
        if (this.screenToImageY(newLayoutY) >= 0.0) {
            this.cropArea.setLayoutY(newLayoutY);
            this.cropArea.setPrefHeight(newHeight);
        }
    }

    @Override
    protected EventHandler<MouseEvent> panningMove() {
        return event -> {
            this.mouseTranslateX = event.getX() - this.mousePressedX;
            this.mouseTranslateY = event.getY() - this.mousePressedY;
            if (this.selectionModeProperty.get()) {
                this.cropArea.setVisible(true);
                this.resizeCropArea(event.getX(), event.getY());
            } else {
                this.notifyListeners(true, ViewRect.EventType.MOUSE_TRANSLATE);
            }
        };
    }

    @Override
    protected EventHandler<MouseEvent> panningRelease() {
        return event -> {
            if (this.selectionModeProperty.get()) {
                this.screenToRect();
            } else {
                this.x += this.mouseTranslateX;
                this.y += this.mouseTranslateY;
            }
            this.mousePressedX = 0.0;
            this.mousePressedY = 0.0;
            this.mouseTranslateX = 0.0;
            this.mouseTranslateY = 0.0;
        };
    }
}

