/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.viewers.ui.content;

import com.siams.cv.monitor.model.viewer.ViewerModel;
import com.siams.cv.monitor.viewers.ui.content.BaseImageViewerControls;
import com.siams.cv.monitor.viewers.ui.content.IBaseImageViewerContent;
import com.siams.cv.monitor.viewers.ui.content.RasterViewer;
import com.siams.cv.monitor.viewers.ui.content.ViewRect;
import com.siams.cv.monitor.viewers.ui.content.ViewerDataSource;
import com.siams.cv.monitor.viewers.ui.content.ViewerStateHandler;
import com.siams.javafx.PaneHelper;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Button;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.MenuButton;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import net.algart.executors.api.data.SMat;
import org.apache.log4j.Logger;

public abstract class BaseImageViewer<T extends ViewerModel>
extends RasterViewer<T> {
    private final Logger logger = Logger.getLogger(BaseImageViewer.class);
    protected Map<Feature, Boolean> features = new HashMap<Feature, Boolean>();

    public BaseImageViewer(T model) {
        super(model);
    }

    public BaseImageViewer(WritableImage image, T projectViewer) {
        super(projectViewer);
        this.image = image;
    }

    public void initialize() {
        this.initializeImageViewRect();
        this.initializeRoot();
        this.initializeRasterContainer();
        this.initializeControls();
    }

    protected abstract void initializeRoot();

    protected abstract IBaseImageViewerContent getBaseContent();

    protected void initializeRasterContainer() {
        IBaseImageViewerContent content = this.getBaseContent();
        Pane rasterContainer = content.getRasterContainer();
        rasterContainer.addEventHandler(MouseEvent.MOUSE_MOVED, event -> {
            int x = (int)event.getX();
            int y = (int)event.getY();
            this.moveHighlighter(x, y);
            this.updatePixelValue(x, y);
        });
        rasterContainer.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> this.onRasterContainerClicked((MouseEvent)event));
    }

    @Override
    protected void initializeControls() {
        this.initializeStatusBar();
        this.initializeZoomControls();
        this.initializeButtons();
    }

    @Override
    public void embed(Pane viewerContainer) {
        IBaseImageViewerContent content = this.getBaseContent();
        Pane root = content.getRoot();
        viewerContainer.getChildren().add(0, (Object)root);
        PaneHelper.setAnchorZero((Node)root);
        this.imageViewRect.addListener(this);
        this.imageViewRect.registerPanningNode((Node)content.getRasterContainer());
        this.imageViewRect.registerOuterBounds((Node)content.getRasterContainer());
    }

    @Override
    public Pane provideControls() {
        BaseImageViewerControls controls = this.createImageViewControls();
        controls.init();
        this.updateFeatures(controls);
        return controls;
    }

    protected abstract BaseImageViewerControls createImageViewControls();

    public ImageView provideView() {
        Canvas canvas = this.getBaseContent().getCanvas();
        WritableImage writableImage = new WritableImage((int)canvas.getWidth(), (int)canvas.getHeight());
        canvas.snapshot(new SnapshotParameters(), writableImage);
        return new ImageView((Image)writableImage);
    }

    @Override
    public List<Node> provideTools() {
        return new LinkedList<MenuButton>(List.of(this.getBaseContent().getMenuView()));
    }

    public void setViewerStateHandler(ViewerStateHandler viewerStateHandler) {
        this.viewerStateHandler = viewerStateHandler;
    }

    public void enableToolBar(boolean enable) {
        Pane statusBar = this.getBaseContent().getStatusBarHolder();
        if (statusBar != null) {
            statusBar.setVisible(enable);
            statusBar.setManaged(enable);
        }
    }

    public void enableZoomControls(boolean enable) {
        Node zoomControls = this.getBaseContent().getZoomControls();
        if (zoomControls != null) {
            zoomControls.setVisible(enable);
            zoomControls.setManaged(enable);
        }
    }

    @Override
    public void renderImage(Image image) {
        long t1 = System.currentTimeMillis();
        if (!this.isEnabled()) {
            return;
        }
        if (image == null) {
            return;
        }
        this.drawImage(image);
        this.logger.trace((Object)String.format("ImageViewer:renderImage (%d) ms", System.currentTimeMillis() - t1));
    }

    protected void drawImage(Image image) {
        if (!this.imageViewRect.dragHappened) {
            this.getBaseContent().center();
        }
        Canvas canvas = this.getBaseContent().getCanvas();
        GraphicsContext context = canvas.getGraphicsContext2D();
        context.clearRect(0.0, 0.0, canvas.getWidth(), canvas.getHeight());
        double scale = this.imageViewRect.getScale();
        int finalX = (int)(this.imageViewRect.getX() + this.imageViewRect.getTranslateX());
        int finalY = (int)(this.imageViewRect.getY() + this.imageViewRect.getTranslateY());
        context.drawImage(image, 0.0, 0.0, image.getWidth(), image.getHeight(), (double)finalX, (double)finalY, image.getWidth() * scale, image.getHeight() * scale);
    }

    @Override
    public void onChangeImageViewRect(ViewRect imageViewRect) {
        this.renderImage(this.image);
        if (this.viewerStateHandler != null) {
            this.viewerStateHandler.onViewerStateChanged();
        }
    }

    @Override
    public void setViewerDataSource(ViewerDataSource viewerDataSource) {
        super.setViewerDataSource(viewerDataSource);
        this.getRasterData().ifPresent(sMat -> this.setImage((Image)SwingFXUtils.toFXImage((BufferedImage)sMat.toBufferedImage(), null)));
    }

    @Override
    protected void initializeStatusBar() {
        super.initializeStatusBar();
        IBaseImageViewerContent content = this.getBaseContent();
        Pane statusBarHolder = content.getStatusBarHolder();
        statusBarHolder.getChildren().add((Object)this.statusBar);
        PaneHelper.setAnchorZero((Node)this.statusBar);
    }

    protected void initializeZoomControls() {
        IBaseImageViewerContent content = this.getBaseContent();
        Node zoomControls = content.getZoomControls();
        CheckMenuItem cmiZoomControls = content.getCheckMenuItemZoomControls();
        Button btnZoomIn = content.getButtonZoomIn();
        Button btnZoomOut = content.getButtonZoomOut();
        Button btnResetZoom = content.getButtonResetZoom();
        cmiZoomControls.setOnAction(event -> {
            CheckMenuItem item = (CheckMenuItem)event.getSource();
            boolean isSelected = item.isSelected();
            zoomControls.setManaged(isSelected);
            zoomControls.setVisible(isSelected);
        });
        btnZoomIn.setOnAction(event -> this.imageViewRect.zoomIn());
        btnZoomOut.setOnAction(event -> this.imageViewRect.zoomOut());
        btnResetZoom.setOnAction(event -> {
            this.imageViewRect.zoomReset();
            this.getBaseContent().center();
            this.imageViewRect.notifyListeners(false, ViewRect.EventType.ZOOM);
        });
    }

    protected void initializeButtons() {
        IBaseImageViewerContent content = this.getBaseContent();
        Button btnZoomIn = content.getButtonZoomIn();
        btnZoomIn.getStyleClass().add((Object)"zoom-in");
        Button btnZoomOut = content.getButtonZoomOut();
        btnZoomOut.getStyleClass().add((Object)"zoom-out");
        Button btnZoomReset = content.getButtonResetZoom();
        btnZoomReset.getStyleClass().add((Object)"reset");
    }

    @Override
    public void onChangeStageShowingProperty(Boolean showing) {
        super.onChangeStageShowingProperty(showing);
        if (showing.booleanValue()) {
            this.getBaseContent().center();
        }
    }

    @Override
    protected void updatePixelValue(int mouseX, int mouseY) {
        if (this.imageViewRect == null) {
            return;
        }
        int x = (int)Math.floor(((double)mouseX - this.imageViewRect.getX()) / this.imageViewRect.getScale());
        int y = (int)Math.floor(((double)mouseY - this.imageViewRect.getY()) / this.imageViewRect.getScale());
        this.statusBar.setCrd(x, y);
        double[] values = this.getPixelValue(x, y);
        if (values == null) {
            return;
        }
        String format = "%.4f";
        String[] colorNames = new String[]{"R=", "G=", "B=", "\u03b1="};
        CharSequence[] pixelValues = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            pixelValues[i] = (values.length == 3 || values.length == 4 ? colorNames[i] : "") + String.format(Locale.US, "%.4f", values[i]);
        }
        this.statusBar.setStatus(String.join((CharSequence)", ", pixelValues));
    }

    protected void updateFeatures(BaseImageViewerControls controls) {
        for (Feature feature : this.features.keySet()) {
            controls.enableFeature(feature, this.features.get((Object)feature));
        }
    }

    public void enableFeature(Feature feature, boolean enabled) {
        this.features.put(feature, enabled);
    }

    @Override
    public void savePreference() {
        super.savePreference();
        IBaseImageViewerContent content = this.getBaseContent();
        this.viewerModel.setDisplayZoomControls(Boolean.valueOf(content.getCheckMenuItemZoomControls().isSelected()));
    }

    public Optional<SMat> getRasterData() {
        return this.viewerDataSource.getData().map(this::extractDefaultData);
    }

    public static enum Feature {
        VIEWER_KIND,
        RANGE_THRESHOLD,
        AUTO_CONTRAST,
        OPACITY;

    }
}

