/*
 * Decompiled with CFR 0.152.
 */
package com.siams.fx.process;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Optional;
import org.apache.log4j.Logger;

public class TextEditByExternalApp {
    private static Logger logger = Logger.getLogger(TextEditByExternalApp.class);

    public static Optional<String> edit(String text, String ext) throws IOException, InterruptedException {
        Optional<String> result = Optional.empty();
        File tmp = File.createTempFile("stare-editing-", ext);
        try (FileWriter out = new FileWriter(tmp);){
            out.write(text);
        }
        String osName = System.getProperty("os.name");
        if (osName.toLowerCase().contains("windows")) {
            result = Optional.of(TextEditByExternalApp.editByWindowsCmd(tmp, ext));
        } else {
            logger.error((Object)String.format("Unsupported OS: %s", osName));
        }
        tmp.delete();
        return result;
    }

    private static String editByWindowsCmd(File tmp, String ext) throws IOException, InterruptedException {
        ProcessBuilder builder = new ProcessBuilder("cmd", String.format("/C start /WAIT %s", tmp.getAbsolutePath()));
        Process process = builder.start();
        process.waitFor();
        int size = (int)tmp.length();
        char[] buffer = new char[size];
        try (FileReader reader = new FileReader(tmp);){
            reader.read(buffer, 0, size);
        }
        return new String(buffer);
    }
}

