/*
 * Decompiled with CFR 0.152.
 */
package com.siams.fx.control;

import com.siams.cv.monitor.model.SimplePrimitive;
import com.siams.cv.monitor.model.worker.control.SControl;
import com.siams.fx.components.tooltip.StareTooltip;
import com.siams.fx.control.UIControlEventHandler;
import com.siams.fx.control.UIValueControl;
import com.siams.fx.control.UIValueControlFile;
import com.siams.fxml.loader.CustomFXMLLoader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Optional;
import java.util.prefs.Preferences;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.AnchorPane;
import javafx.stage.DirectoryChooser;

public class UIValueControlFolder
extends AnchorPane
implements UIValueControl,
ChangeListener<String> {
    private SControl structureControl;
    private UIControlEventHandler eventHandler;
    @FXML
    private Button buttonSelectFolder;
    @FXML
    private Button btnAbsolute;
    @FXML
    private TextField textFieldValue;
    private File workingDir = null;

    UIValueControlFolder() {
        try {
            CustomFXMLLoader.loadElement((Object)this);
            this.textFieldValue.textProperty().addListener((ChangeListener)this);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setProperty(SimplePrimitive property) {
        this.textFieldValue.textProperty().removeListener((ChangeListener)this);
        this.textFieldValue.setText(property.asString(""));
        this.textFieldValue.textProperty().addListener((ChangeListener)this);
    }

    @Override
    public Node getNode() {
        return this;
    }

    @Override
    public void setControlEventHandler(UIControlEventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    @Override
    public void setStructureControl(SControl structureControl) {
        this.structureControl = structureControl;
        String hint = structureControl.getSmartHint();
        if (!hint.isEmpty()) {
            this.textFieldValue.setTooltip((Tooltip)new StareTooltip(hint));
        }
        this.buttonSelectFolder.setOnAction(event -> {
            String folder = "";
            DirectoryChooser chooser = new DirectoryChooser();
            try {
                Preferences preferences = Preferences.userNodeForPackage(UIValueControlFolder.class);
                folder = preferences.get("folder.selector.folder", "");
                if (!folder.isEmpty() && new File(folder).exists()) {
                    chooser.setInitialDirectory(new File(folder));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            File file = chooser.showDialog(null);
            if (file != null) {
                String path = UIValueControl.convertToForwardSlash(file.getAbsolutePath());
                this.textFieldValue.setText(path);
                try {
                    Preferences preferences = Preferences.userNodeForPackage(UIValueControlFolder.class);
                    preferences.put("folder.selector.folder", file.getParentFile().getAbsolutePath());
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
            }
        });
        Tooltip.install((Node)this.btnAbsolute, (Tooltip)new StareTooltip("Switch absolute/relative path"));
        this.btnAbsolute.setOnAction(event -> UIValueControlFile.switchAbsoluteRelativePath(event, this.workingDir, this.textFieldValue));
    }

    @Override
    public SControl getStructureControl() {
        return this.structureControl;
    }

    @Override
    public void setWorkingDir(File workDir) {
        this.workingDir = workDir;
    }

    public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
        if (oldValue.equals(newValue)) {
            return;
        }
        String path = UIValueControl.convertToForwardSlash(newValue);
        this.eventHandler.onValueChange(this.structureControl, path);
    }

    private Optional<File> resolveAbsolutePath(String filePath) {
        if (filePath == null) {
            return Optional.empty();
        }
        File file = new File(filePath);
        if (file.isAbsolute()) {
            return Optional.of(file);
        }
        if (this.workingDir == null || !Files.exists(this.workingDir.toPath(), new LinkOption[0])) {
            return Optional.empty();
        }
        return Optional.of(this.workingDir.toPath().resolve(file.toPath()).toFile());
    }
}

