/*
 * Decompiled with CFR 0.152.
 */
package com.siams.fx.control;

import com.siams.cv.monitor.model.IIdentifiable;
import com.siams.cv.monitor.model.SimplePrimitive;
import com.siams.cv.monitor.model.worker.control.SControl;
import com.siams.fx.components.tooltip.StareTooltip;
import com.siams.fx.control.UIControlContainer;
import com.siams.fx.control.UIControlEventHandler;
import com.siams.fx.control.UIValueControl;
import com.siams.fx.control.UIValueControlFile;
import com.siams.fxml.loader.CustomFXMLLoader;
import com.siams.javafx.PaneHelper;
import com.siams.javafx.utils.FxPlatform;
import java.io.File;
import java.io.IOException;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import net.algart.executors.api.data.SNumbers;

public class UIValueControlContainer
extends VBox
implements UIControlContainer,
UIControlEventHandler {
    private static final Color ADVANCED_PARAMETER_CAPTION_COLOR = Color.DARKGREY;
    private SControl structureControl;
    private IIdentifiable iid;
    private UIValueControl uiValueControl;
    private UIControlEventHandler controlEventHandler = null;
    @FXML
    private AnchorPane anchorValueControl;
    @FXML
    private Label labelDescription;
    @FXML
    private Label labelCaption;
    @FXML
    private ImageView imgAdvanced;

    UIValueControlContainer() {
        try {
            CustomFXMLLoader.loadElement((Object)this);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setValueControl(UIValueControl uiValueControl) {
        this.uiValueControl = uiValueControl;
        this.anchorValueControl.getChildren().add((Object)uiValueControl.getNode());
        PaneHelper.setAnchorZero((Node)uiValueControl.getNode());
        this.labelCaption.setVisible(uiValueControl.displayCaption());
        this.labelCaption.setManaged(uiValueControl.displayCaption());
        this.imgAdvanced.setImage(new Image(UIValueControlFile.class.getResourceAsStream("icon_advanced.png")));
    }

    @Override
    public void setStructureControl(SControl structureControl) {
        this.structureControl = structureControl;
        String caption = structureControl.getCaption();
        if (caption.isEmpty()) {
            caption = structureControl.getName();
        }
        String description = structureControl.getDescription();
        String hint = structureControl.getSmartHint();
        if (!hint.isEmpty()) {
            this.labelCaption.setTooltip((Tooltip)new StareTooltip(hint));
        }
        this.labelCaption.setText(caption);
        this.labelDescription.setText(description);
        this.labelDescription.setVisible(!description.isEmpty());
        this.labelDescription.setManaged(!description.isEmpty());
        this.imgAdvanced.setManaged(false);
        this.imgAdvanced.setVisible(false);
        if (structureControl.getAdvanced().booleanValue()) {
            this.labelCaption.setTextFill((Paint)ADVANCED_PARAMETER_CAPTION_COLOR);
        }
    }

    @Override
    public SControl getStructureControl() {
        return this.structureControl;
    }

    @Override
    public void setProperty(SimplePrimitive property) {
        FxPlatform.RunFxThread(() -> this.uiValueControl.setProperty(property));
    }

    @Override
    public void setObject(IIdentifiable iid) {
        this.iid = iid;
    }

    @Override
    public Node getNode() {
        return this;
    }

    @Override
    public void setUIControlEventHandler(UIControlEventHandler controlEventHandler) {
        this.controlEventHandler = controlEventHandler;
    }

    @Override
    public void setWorkingDir(File workDir) {
        this.uiValueControl.setWorkingDir(workDir);
    }

    @Override
    public void setNumbersData(SNumbers sNumbers) {
        this.uiValueControl.setNumbersData(sNumbers);
    }

    @Override
    public void onValueChange(SControl structureControl, Object value) {
        if (this.controlEventHandler != null) {
            this.controlEventHandler.onValueChange(structureControl, value);
        }
    }
}

