/*
 * Decompiled with CFR 0.152.
 */
package com.siams.fx.control;

import com.siams.cv.monitor.model.SimplePrimitive;
import com.siams.cv.monitor.model.worker.control.SControl;
import com.siams.fx.components.tooltip.StareTooltip;
import com.siams.fx.control.UIControlEventHandler;
import com.siams.fx.control.UIValueControl;
import com.siams.fxml.loader.CustomFXMLLoader;
import java.io.IOException;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.AnchorPane;

public class UIValueControlCheckBox
extends AnchorPane
implements UIValueControl,
ChangeListener<Boolean> {
    private UIControlEventHandler eventHandler;
    private SControl structureControl;
    @FXML
    private CheckBox checkboxValue;
    @FXML
    private AnchorPane root;

    UIValueControlCheckBox() {
        try {
            CustomFXMLLoader.loadElement((Object)this);
            this.checkboxValue.selectedProperty().addListener((ChangeListener)this);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setProperty(SimplePrimitive property) {
        this.checkboxValue.selectedProperty().removeListener((ChangeListener)this);
        this.checkboxValue.setSelected(property.asBoolean(false));
        this.checkboxValue.selectedProperty().addListener((ChangeListener)this);
    }

    @Override
    public Node getNode() {
        return this;
    }

    @Override
    public void setControlEventHandler(UIControlEventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    @Override
    public void setStructureControl(SControl structureControl) {
        String hint;
        this.structureControl = structureControl;
        String caption = structureControl.getCaption();
        if (caption.isEmpty()) {
            caption = structureControl.getName();
        }
        if (!(hint = structureControl.getSmartHint()).isEmpty()) {
            this.checkboxValue.setTooltip((Tooltip)new StareTooltip(hint));
        }
        this.checkboxValue.setText(caption);
    }

    @Override
    public SControl getStructureControl() {
        return this.structureControl;
    }

    public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
        if (oldValue.equals(newValue)) {
            return;
        }
        this.eventHandler.onValueChange(this.structureControl, newValue);
    }

    @Override
    public boolean displayCaption() {
        return false;
    }
}

