/*
 * Decompiled with CFR 0.152.
 */
package net.algart.multimatrix;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.multimatrix.MultiMatrix;
import net.algart.multimatrix.MultiMatrix2D;
import net.algart.multimatrix.SimpleMultiMatrix;

class SimpleMultiMatrix2D
extends SimpleMultiMatrix
implements MultiMatrix2D {
    private final long dimX;
    private final long dimY;

    SimpleMultiMatrix2D(List<? extends Matrix<? extends PArray>> channels) {
        super(channels);
        Matrix ch = (Matrix)this.channels.getFirst();
        if (ch.dimCount() != 2) {
            throw new IllegalArgumentException("2-dimensional matrices allowed only");
        }
        this.dimX = ch.dimX();
        this.dimY = ch.dimY();
    }

    @Override
    public long dimX() {
        return this.dimX;
    }

    @Override
    public long dimY() {
        return this.dimY;
    }

    @Override
    public MultiMatrix2D asPrecision(Class<?> newElementType) {
        if (newElementType == this.elementType()) {
            return this;
        }
        return new SimpleMultiMatrix2D(SimpleMultiMatrix2D.asPrecision(this.channels, newElementType));
    }

    @Override
    public MultiMatrix2D toPrecisionIfNot(Class<?> newElementType) {
        Objects.requireNonNull(newElementType, "Null newElementType");
        if (newElementType == this.elementType()) {
            return this;
        }
        return new SimpleMultiMatrix2D(SimpleMultiMatrix2D.toPrecision(this.channels, newElementType));
    }

    @Override
    public MultiMatrix2D asMono() {
        return this.numberOfChannels() == 1 ? this : new SimpleMultiMatrix2D(Collections.singletonList(this.intensityChannel()));
    }

    @Override
    public MultiMatrix2D asOtherNumberOfChannels(int newNumberOfChannels, boolean fillAlphaWithMaxValue) {
        return newNumberOfChannels == this.numberOfChannels() ? this : new SimpleMultiMatrix2D(this.otherNumberOfChannels(newNumberOfChannels, fillAlphaWithMaxValue));
    }

    @Override
    public MultiMatrix2D clone() {
        return new SimpleMultiMatrix2D(MultiMatrix.cloneMatrices(this.channels));
    }

    @Override
    public MultiMatrix2D actualizeLazy() {
        return new SimpleMultiMatrix2D(MultiMatrix.actualizeLazyMatrices(this.channels));
    }

    @Override
    public String toString() {
        return "multi-matrix " + String.valueOf(this.elementType()) + "[" + this.numberOfChannels() + "x" + this.dimX + "x" + this.dimY + "]";
    }
}

