/*
 * Decompiled with CFR 0.152.
 */
package net.algart.multimatrix;

import net.algart.arrays.Array;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.Arrays;
import net.algart.arrays.BitArray;
import net.algart.arrays.ByteArray;
import net.algart.arrays.CharArray;
import net.algart.arrays.DataBuffer;
import net.algart.arrays.DoubleArray;
import net.algart.arrays.FloatArray;
import net.algart.arrays.IntArray;
import net.algart.arrays.JArrays;
import net.algart.arrays.LongArray;
import net.algart.arrays.PArray;
import net.algart.arrays.ShortArray;
import net.algart.math.Range;

class NonZeroRangeCalculator
extends Arrays.ParallelExecutor {
    private static final int BYTE_MIN = 0;
    private static final int BYTE_MAX = 255;
    private static final int CHAR_MIN = 0;
    private static final int CHAR_MAX = 65535;
    private static final int SHORT_MIN = 0;
    private static final int SHORT_MAX = 65535;
    private static final int INT_MIN = Integer.MIN_VALUE;
    private static final int INT_MAX = Integer.MAX_VALUE;
    private static final long LONG_MIN = Long.MIN_VALUE;
    private static final long LONG_MAX = Long.MAX_VALUE;
    private static final float FLOAT_MIN = Float.NEGATIVE_INFINITY;
    private static final float FLOAT_MAX = Float.POSITIVE_INFINITY;
    private static final double DOUBLE_MIN = Double.NEGATIVE_INFINITY;
    private static final double DOUBLE_MAX = Double.POSITIVE_INFINITY;
    private final DataBuffer[] buffers = new DataBuffer[this.numberOfTasks()];
    private final double[] threadMin = new double[this.numberOfTasks()];
    private final double[] threadMax = new double[this.numberOfTasks()];
    Range resultRange;

    public NonZeroRangeCalculator(ArrayContext context, PArray src) {
        super(context, null, (Array)src, 65536, 0, 0L);
        JArrays.fill((double[])this.threadMin, (double)Double.POSITIVE_INFINITY);
        JArrays.fill((double[])this.threadMax, (double)Double.NEGATIVE_INFINITY);
    }

    public void process() {
        if (this.src.isEmpty()) {
            this.resultRange = null;
        } else if (this.src instanceof BitArray) {
            this.resultRange = ((BitArray)this.src).indexOf(0L, this.src.length(), true) == -1L ? null : Range.of((double)1.0, (double)1.0);
        } else {
            super.process();
        }
    }

    protected void processSubArr(long position, int count, int threadIndex) {
        DataBuffer buf = this.buffers[threadIndex];
        if (buf == null) {
            this.buffers[threadIndex] = buf = this.src.buffer(DataBuffer.AccessMode.READ, (long)this.blockSize);
        }
        buf.map(position, (long)count);
        long index = position;
        if (this.src instanceof BitArray) {
            throw new AssertionError((Object)"Illegal usage");
        }
        if (this.src instanceof ByteArray) {
            int min = 255;
            int max = 0;
            byte[] ja = (byte[])buf.data();
            int k = buf.from();
            int kMax = buf.to();
            while (k < kMax) {
                int v = ja[k] & 0xFF;
                if (v != 0) {
                    if (v < min) {
                        min = v;
                    }
                    if (v > max) {
                        max = v;
                    }
                }
                ++k;
                ++index;
            }
            if ((double)min < this.threadMin[threadIndex]) {
                this.threadMin[threadIndex] = min;
            }
            if ((double)max > this.threadMax[threadIndex]) {
                this.threadMax[threadIndex] = max;
            }
        } else if (this.src instanceof CharArray) {
            char min = '\uffff';
            char max = '\u0000';
            char[] ja = (char[])buf.data();
            int k = buf.from();
            int kMax = buf.to();
            while (k < kMax) {
                char v = ja[k];
                if (v != '\u0000') {
                    if (v < min) {
                        min = v;
                    }
                    if (v > max) {
                        max = v;
                    }
                }
                ++k;
                ++index;
            }
            if ((double)min < this.threadMin[threadIndex]) {
                this.threadMin[threadIndex] = min;
            }
            if ((double)max > this.threadMax[threadIndex]) {
                this.threadMax[threadIndex] = max;
            }
        } else if (this.src instanceof ShortArray) {
            int min = 65535;
            int max = 0;
            short[] ja = (short[])buf.data();
            int k = buf.from();
            int kMax = buf.to();
            while (k < kMax) {
                int v = ja[k] & 0xFFFF;
                if (v != 0) {
                    if (v < min) {
                        min = v;
                    }
                    if (v > max) {
                        max = v;
                    }
                }
                ++k;
                ++index;
            }
            if ((double)min < this.threadMin[threadIndex]) {
                this.threadMin[threadIndex] = min;
            }
            if ((double)max > this.threadMax[threadIndex]) {
                this.threadMax[threadIndex] = max;
            }
        } else if (this.src instanceof IntArray) {
            int min = Integer.MAX_VALUE;
            int max = Integer.MIN_VALUE;
            int[] ja = (int[])buf.data();
            int k = buf.from();
            int kMax = buf.to();
            while (k < kMax) {
                int v = ja[k];
                if (v != 0) {
                    if (v < min) {
                        min = v;
                    }
                    if (v > max) {
                        max = v;
                    }
                }
                ++k;
                ++index;
            }
            if ((double)min < this.threadMin[threadIndex]) {
                this.threadMin[threadIndex] = min;
            }
            if ((double)max > this.threadMax[threadIndex]) {
                this.threadMax[threadIndex] = max;
            }
        } else if (this.src instanceof LongArray) {
            long min = Long.MAX_VALUE;
            long max = Long.MIN_VALUE;
            long[] ja = (long[])buf.data();
            int k = buf.from();
            int kMax = buf.to();
            while (k < kMax) {
                long v = ja[k];
                if (v != 0L) {
                    if (v < min) {
                        min = v;
                    }
                    if (v > max) {
                        max = v;
                    }
                }
                ++k;
                ++index;
            }
            if ((double)min < this.threadMin[threadIndex]) {
                this.threadMin[threadIndex] = min;
            }
            if ((double)max > this.threadMax[threadIndex]) {
                this.threadMax[threadIndex] = max;
            }
        } else if (this.src instanceof FloatArray) {
            float min = Float.POSITIVE_INFINITY;
            float max = Float.NEGATIVE_INFINITY;
            float[] ja = (float[])buf.data();
            int k = buf.from();
            int kMax = buf.to();
            while (k < kMax) {
                float v = ja[k];
                if (v != 0.0f) {
                    if (v < min) {
                        min = v;
                    }
                    if (v > max) {
                        max = v;
                    }
                }
                ++k;
                ++index;
            }
            if ((double)min < this.threadMin[threadIndex]) {
                this.threadMin[threadIndex] = min;
            }
            if ((double)max > this.threadMax[threadIndex]) {
                this.threadMax[threadIndex] = max;
            }
        } else if (this.src instanceof DoubleArray) {
            double min = Double.POSITIVE_INFINITY;
            double max = Double.NEGATIVE_INFINITY;
            double[] ja = (double[])buf.data();
            int k = buf.from();
            int kMax = buf.to();
            while (k < kMax) {
                double v = ja[k];
                if (v != 0.0) {
                    if (v < min) {
                        min = v;
                    }
                    if (v > max) {
                        max = v;
                    }
                }
                ++k;
                ++index;
            }
            if (min < this.threadMin[threadIndex]) {
                this.threadMin[threadIndex] = min;
            }
            if (max > this.threadMax[threadIndex]) {
                this.threadMax[threadIndex] = max;
            }
        } else {
            throw new AssertionError((Object)("Disallowed type of passed array: " + String.valueOf(this.src.getClass())));
        }
    }

    protected synchronized void finish() {
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (int k = 0; k < this.threadMin.length; ++k) {
            if (this.threadMin[k] < min) {
                min = this.threadMin[k];
            }
            if (!(this.threadMax[k] > max)) continue;
            max = this.threadMax[k];
        }
        this.resultRange = min <= max ? Range.of((double)min, (double)max) : null;
    }
}

