/*
 * Decompiled with CFR 0.152.
 */
package net.algart.multimatrix;

import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Function;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.math.Range;
import net.algart.math.functions.Func;
import net.algart.math.functions.LinearFunc;
import net.algart.multimatrix.MultiMatrix;

public interface MultiMatrix2D
extends MultiMatrix {
    public long dimX();

    public long dimY();

    default public long indexInArray(long x, long y) {
        long dimX = this.dimX();
        long dimY = this.dimY();
        if (x < 0L || x >= dimX) {
            throw new IndexOutOfBoundsException("X-coordinate (" + x + (String)(x < 0L ? ") < 0" : ") >= dimX() (" + dimX + ")") + " in " + String.valueOf(this));
        }
        if (y < 0L || y >= dimY) {
            throw new IndexOutOfBoundsException("Y-coordinate (" + y + (String)(y < 0L ? ") < 0" : ") >= dimY() (" + dimY + ")") + " in " + String.valueOf(this));
        }
        return y * dimX + x;
    }

    @Override
    default public MultiMatrix2D asMultiMatrix2D() {
        return this;
    }

    default public MultiMatrix.PixelValue getPixel(long x, long y) {
        return this.getPixel(this.indexInArray(x, y));
    }

    default public void setPixel(long x, long y, MultiMatrix.PixelValue pixelValue) {
        this.setPixel(this.indexInArray(x, y), pixelValue);
    }

    default public double getPixelChannel(int channelIndex, long x, long y) {
        return this.channelArray(channelIndex).getDouble(this.indexInArray(x, y));
    }

    default public void setPixelChannel(int channelIndex, long x, long y, double value) {
        ((UpdatablePArray)this.channelArray(channelIndex)).setDouble(this.indexInArray(x, y), value);
    }

    @Override
    public MultiMatrix2D asPrecision(Class<?> var1);

    @Override
    default public MultiMatrix2D toPrecision(Class<?> newElementType) {
        return newElementType.equals(this.elementType()) ? this.clone() : this.toPrecisionIfNot((Class)newElementType);
    }

    @Override
    public MultiMatrix2D toPrecisionIfNot(Class<?> var1);

    @Override
    default public MultiMatrix2D asFloatingPoint() {
        return this.isFloatingPoint() ? this : this.asPrecision((Class)Float.TYPE);
    }

    @Override
    default public MultiMatrix2D asFloat() {
        return this.elementType() == Float.TYPE ? this : this.asPrecision((Class)Float.TYPE);
    }

    @Override
    default public MultiMatrix2D toFloatIfNot() {
        return this.elementType() == Float.TYPE ? this : this.toPrecisionIfNot((Class)Float.TYPE);
    }

    @Override
    public MultiMatrix2D asMono();

    @Override
    default public MultiMatrix2D toMonoIfNot() {
        return this.isMono() ? this : this.asMono().clone();
    }

    @Override
    default public MultiMatrix2D asOtherNumberOfChannels(int numberOfChannels) {
        return this.asOtherNumberOfChannels(numberOfChannels, true);
    }

    @Override
    public MultiMatrix2D asOtherNumberOfChannels(int var1, boolean var2);

    @Override
    public MultiMatrix2D clone();

    @Override
    default public MultiMatrix2D nonZeroPixels(boolean checkOnlyRGBChannels) {
        return MultiMatrix.of2DMono(this.nonZeroPixelsMatrix(checkOnlyRGBChannels));
    }

    @Override
    default public MultiMatrix2D zeroPixels(boolean checkOnlyRGBChannels) {
        return MultiMatrix.of2DMono(this.zeroPixelsMatrix(checkOnlyRGBChannels));
    }

    @Override
    default public MultiMatrix2D nonZeroAnyChannel() {
        return MultiMatrix.of2DMono(this.nonZeroAnyChannelMatrix());
    }

    @Override
    default public MultiMatrix2D zeroAllChannels() {
        return MultiMatrix.of2DMono(this.zeroAllChannelsMatrix());
    }

    @Override
    default public MultiMatrix2D nonZeroRGB() {
        return MultiMatrix.of2DMono(this.nonZeroRGBMatrix());
    }

    @Override
    default public MultiMatrix2D zeroRGB() {
        return MultiMatrix.of2DMono(this.zeroRGBMatrix());
    }

    default public MultiMatrix2D min(MultiMatrix2D other) {
        return this.asFunc(Func.MIN, other);
    }

    default public MultiMatrix2D max(MultiMatrix2D other) {
        return this.asFunc(Func.MAX, other);
    }

    @Override
    default public MultiMatrix2D asFunc(Func funcOfOneArgument) {
        return this.asFunc(funcOfOneArgument, (Class)this.arrayType());
    }

    @Override
    default public MultiMatrix2D asFunc(Func funcOfOneArgument, Class<? extends PArray> requiredType) {
        int n = this.numberOfChannels();
        ArrayList<Matrix> channels = new ArrayList<Matrix>();
        for (int k = 0; k < n; ++k) {
            channels.add(Matrices.asFuncMatrix((Func)funcOfOneArgument, requiredType, this.channel(k)));
        }
        return MultiMatrix.of2D(channels);
    }

    default public MultiMatrix2D asFunc(Func funcOfTwoArguments, MultiMatrix2D other) {
        return this.asFunc(funcOfTwoArguments, other, this.arrayType());
    }

    default public MultiMatrix2D asFunc(Func funcOfTwoArguments, MultiMatrix2D other, Class<? extends PArray> requiredType) {
        Objects.requireNonNull(other, "Null other multi-matrix");
        int n = this.numberOfChannels();
        other = other.asOtherNumberOfChannels(n).asPrecision((Class)this.elementType());
        if (!1.$assertionsDisabled && other.numberOfChannels() != n) {
            throw new AssertionError((Object)"Invalid asOtherNumberOfChannels implementation");
        }
        ArrayList<Matrix> channels = new ArrayList<Matrix>();
        for (int k = 0; k < n; ++k) {
            channels.add(Matrices.asFuncMatrix((Func)funcOfTwoArguments, requiredType, this.channel(k), other.channel(k)));
        }
        return MultiMatrix.of2D(channels);
    }

    default public MultiMatrix apply2D(Function<Matrix<? extends PArray>, Matrix<? extends PArray>> function) {
        return this.apply(function).asMultiMatrix2D();
    }

    @Override
    default public MultiMatrix2D contrast() {
        Range range = this.rangeOfIntensityOrNull();
        if (range == null) {
            return this;
        }
        return this.contrast(range, false);
    }

    @Override
    default public MultiMatrix2D contrast(Range sourceRangeToContrast, boolean requireMonochromeOrColor) {
        Range destRange = Range.of((double)0.0, (double)this.maxPossibleValue());
        LinearFunc function = sourceRangeToContrast == null || sourceRangeToContrast.size() == 0.0 ? null : LinearFunc.getInstance((Range)destRange, (Range)sourceRangeToContrast);
        return this.correctIntensity(function, requireMonochromeOrColor).asMultiMatrix2D();
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

