/*
 * Decompiled with CFR 0.152.
 */
package net.algart.json;

class PropertyCheckerHelper {
    PropertyCheckerHelper() {
    }

    static String findPropertyNameFromCurrentSetter(String defaultName) {
        StackTraceElement[] stack;
        for (StackTraceElement stackTraceElement : stack = Thread.currentThread().getStackTrace()) {
            String methodName = stackTraceElement.getMethodName();
            if (!methodName.startsWith("set")) continue;
            Object propertyName = methodName.substring("set".length());
            if (((String)propertyName).isEmpty()) break;
            propertyName = ((String)propertyName).substring(0, 1).toLowerCase() + ((String)propertyName).substring(1);
            return propertyName;
        }
        return defaultName;
    }

    static class TestStackTrace {
        TestStackTrace() {
        }

        static void setSomething(double value) {
            System.out.println("Current property name in setter: " + PropertyCheckerHelper.findPropertyNameFromCurrentSetter("N/A"));
        }

        public static void main(String[] args) {
            TestStackTrace.setSomething(1.0);
            System.out.println("Current property name outside: " + PropertyCheckerHelper.findPropertyNameFromCurrentSetter("N/A"));
        }
    }
}

