/*
 * Decompiled with CFR 0.152.
 */
package net.algart.jep;

import java.util.Objects;
import java.util.function.Supplier;
import jep.JepConfig;
import net.algart.jep.JepPerformer;
import net.algart.jep.additions.JepSingleThreadInterpreter;
import net.algart.jep.additions.JepType;

public final class JepPerformerContainer
implements AutoCloseable {
    private static volatile boolean disableNoConfiguration = false;
    private Supplier<JepConfig> configurationSupplier = null;
    private final JepType type;
    private volatile JepPerformer performer = null;
    private final Object lock = new Object();

    private JepPerformerContainer(JepType type) {
        this.type = Objects.requireNonNull(type, "Null JEP interpretation type");
    }

    public static JepPerformerContainer newContainer(JepType type) {
        return new JepPerformerContainer(type);
    }

    public JepType type() {
        return this.type;
    }

    public Supplier<JepConfig> getConfigurationSupplier() {
        return this.configurationSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JepPerformerContainer setConfigurationSupplier(Supplier<JepConfig> configurationSupplier) {
        Objects.requireNonNull(configurationSupplier, "Null configuration supplier");
        Object object = this.lock;
        synchronized (object) {
            this.configurationSupplier = configurationSupplier;
        }
        return this;
    }

    public JepPerformerContainer noConfiguration() {
        if (disableNoConfiguration) {
            throw new IllegalStateException("noConfiguration() is disabled after disableNoConfiguration() call");
        }
        return this.setConfigurationSupplier(JepConfig::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JepPerformer performer() {
        JepPerformer performer;
        boolean created = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.configurationSupplier == null) {
                throw new IllegalStateException("Creating a new performer is not allowed: the configuration supplier has not been set.");
            }
            performer = this.performer;
            if (performer == null) {
                this.performer = performer = JepPerformer.newPerformer(JepSingleThreadInterpreter.newInstance(this.type, this.configurationSupplier));
                created = true;
            }
        }
        if (created) {
            JepPerformer.LOG.log(System.Logger.Level.DEBUG, "Created new " + String.valueOf(performer));
        }
        return performer;
    }

    public boolean isEmpty() {
        return this.performer == null;
    }

    public String toString() {
        JepPerformer performer = this.performer;
        return "JEP performer container (" + String.valueOf((Object)this.type) + "), " + (performer == null ? "EMPTY" : performer.toString()) + ", identity 0x" + System.identityHashCode(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        String message = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.performer != null) {
                message = this.performer.toString();
                this.performer.close();
                this.performer = null;
            }
        }
        if (message != null) {
            JepPerformer.LOG.log(System.Logger.Level.DEBUG, "Closed " + message);
        }
    }

    public static void disableNoConfiguration() {
        disableNoConfiguration = true;
    }
}

