/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.scalars.io;

import java.io.IOError;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Objects;
import net.algart.executors.api.data.SScalar;
import net.algart.executors.modules.core.common.io.FileOperation;

public class ReadScalar
extends FileOperation {
    private String charset = "UTF-8";
    private String defaultValue = "";

    public ReadScalar() {
        this.addFileOperationPorts();
        this.addInputScalar(DEFAULT_INPUT_PORT);
        this.addOutputScalar(DEFAULT_OUTPUT_PORT);
    }

    public static ReadScalar getInstance() {
        return new ReadScalar();
    }

    public static ReadScalar getSecureInstance() {
        ReadScalar result = new ReadScalar();
        result.setSecure(true);
        return result;
    }

    public String getCharset() {
        return this.charset;
    }

    public ReadScalar setCharset(String charset) {
        this.charset = ReadScalar.nonEmpty(charset).trim();
        return this;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public ReadScalar setDefaultValue(String defaultValue) {
        this.defaultValue = ReadScalar.nonNull(defaultValue);
        return this;
    }

    @Override
    public ReadScalar setFile(String file) {
        super.setFile(file);
        return this;
    }

    @Override
    public void process() {
        SScalar input = this.getInputScalar(this.defaultInputPortName(), true);
        if (input.isInitialized()) {
            ReadScalar.logDebug(() -> "Reading scalar");
            this.getScalar().setTo(this.checkResult(input.getValue()));
        } else {
            this.getScalar().setTo(this.checkResult(this.readString()));
        }
    }

    public final String readString() {
        Path path = this.completeFilePath();
        try {
            if (this.skipIfMissingFileOrThrow(path)) {
                ReadScalar.logDebug(() -> "Creating null scalar for non-existing " + String.valueOf(path.toAbsolutePath()));
                return this.defaultValue.isEmpty() ? null : this.defaultValue;
            }
            ReadScalar.logDebug(() -> "Reading UTF-8 scalar from " + String.valueOf(path.toAbsolutePath()));
            return ReadScalar.readString(path, this.charset);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    String checkResult(String result) {
        return result;
    }

    public static String readString(Path file, String charset) throws IOException {
        Objects.requireNonNull(file, "Null file");
        Objects.requireNonNull(charset, "Null charset");
        return Files.readString(file, Charset.forName(charset));
    }
}

