/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.scalars.io;

import java.util.function.Supplier;
import net.algart.executors.api.LogLevel;
import net.algart.executors.api.data.SScalar;
import net.algart.executors.modules.core.common.scalars.ScalarFilter;
import net.algart.executors.modules.core.scalars.io.WriteScalar;

public final class PrintScalar
extends ScalarFilter {
    public static final String S = "s";
    public static final String X = "x";
    public static final String M = "m";
    public static final String SCALAR_PATTERN = "$$$";
    private static final int MAX_RESULT_LENGTH = 50000;
    private String pattern = "$$$";
    private boolean doAction = true;
    private LogLevel logLevel = LogLevel.INFO;
    private String file = "";

    public PrintScalar() {
        this.addInputScalar(S);
        this.addInputNumbers(X);
        this.addInputMat(M);
        this.addOutputScalar(S);
        this.addOutputNumbers(X);
        this.addOutputMat(M);
    }

    public static PrintScalar getInstance() {
        return new PrintScalar();
    }

    public String getPattern() {
        return this.pattern;
    }

    public PrintScalar setPattern(String pattern) {
        this.pattern = PrintScalar.nonNull(pattern);
        return this;
    }

    public boolean isDoAction() {
        return this.doAction;
    }

    public PrintScalar setDoAction(boolean doAction) {
        this.doAction = doAction;
        return this;
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public PrintScalar setLogLevel(LogLevel logLevel) {
        this.logLevel = PrintScalar.nonNull(logLevel);
        return this;
    }

    public String getFile() {
        return this.file;
    }

    public PrintScalar setFile(String file) {
        this.file = PrintScalar.nonNull(file);
        return this;
    }

    @Override
    public SScalar process(SScalar source) {
        this.getScalar(S).exchange(this.getInputScalar(S, true));
        this.getNumbers(X).exchange(this.getInputNumbers(X, true));
        this.getMat(M).exchange(this.getInputMat(M, true));
        if (this.doAction) {
            String result = this.print(source::getValue, this.isOutputNecessary(this.defaultOutputPortName()));
            return SScalar.of(result);
        }
        return SScalar.empty();
    }

    public String print(Supplier<String> source, boolean resultRequired) {
        if (resultRequired || this.logLevel.isLoggable()) {
            return this.print(source.get());
        }
        return null;
    }

    public String print(String s) {
        if (s == null) {
            s = "[No input scalar]";
        }
        if (((String)s).length() > 50000) {
            s = ((String)s).substring(0, 49997) + "...";
        }
        String message = this.pattern.replace("\\n", "\n").replace("\\r", "\r").replace(SCALAR_PATTERN, (CharSequence)s);
        this.logLevel.log(message);
        if (!this.file.isEmpty()) {
            WriteScalar.getInstance().setFile(this.file).writeString(message);
        }
        return message;
    }

    @Override
    protected boolean allowUninitializedInput() {
        return true;
    }
}

