/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.scalars.creation;

import java.io.IOError;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.algart.executors.api.Executor;
import net.algart.executors.modules.core.common.io.PathPropertyReplacement;
import net.algart.executors.modules.core.files.ResolvePath;

public final class CreatePath
extends Executor {
    public static final String OUTPUT_ABSOLUTE_PATH = "absolute_path";
    public static final String OUTPUT_PARENT_FOLDER = "parent_folder";
    public static final String OUTPUT_FILE_NAME = "file_name";
    private final boolean readOnly;
    private String path = "";
    private ResolvePath.Operation operation = ResolvePath.Operation.NONE;
    private boolean secure = false;

    private CreatePath(boolean readOnly) {
        this.readOnly = readOnly;
        this.setDefaultInputScalar(DEFAULT_INPUT_PORT);
        this.setDefaultOutputScalar(OUTPUT_ABSOLUTE_PATH);
        this.addOutputScalar(OUTPUT_PARENT_FOLDER);
        this.addOutputScalar(OUTPUT_FILE_NAME);
    }

    public static CreatePath getInstanceForSource() {
        return new CreatePath(true);
    }

    public static CreatePath getInstanceForResult() {
        return new CreatePath(false);
    }

    public static CreatePath getSecureInstanceForSource() {
        return CreatePath.getInstanceForSource().setSecure(true);
    }

    public static CreatePath getSecureInstanceForResult() {
        return CreatePath.getInstanceForResult().setSecure(true);
    }

    public String getPath() {
        return this.path;
    }

    public CreatePath setPath(String path) {
        this.path = CreatePath.nonNull(path);
        return this;
    }

    public ResolvePath.Operation getOperation() {
        return this.operation;
    }

    public CreatePath setOperation(ResolvePath.Operation operation) {
        this.operation = CreatePath.nonNull(operation);
        return this;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public CreatePath setSecure(boolean secure) {
        this.secure = secure;
        return this;
    }

    @Override
    public void process() {
        Path fileName;
        if (this.readOnly && !this.operation.isReadOnlyOperation()) {
            throw new UnsupportedOperationException("Non-read-only operation " + String.valueOf((Object)this.operation) + " is not allowed in " + String.valueOf(this.getClass()));
        }
        String filePath = this.filePath();
        if (this.readOnly || !this.secure) {
            filePath = PathPropertyReplacement.translatePathProperties(filePath, this);
        }
        if (!this.secure) {
            filePath = PathPropertyReplacement.translateSystemProperties(filePath);
        }
        filePath = PathPropertyReplacement.translateTmpDir(filePath);
        Path path = Paths.get(filePath, new String[0]);
        if (this.readOnly || !this.secure) {
            path = this.translateCurrentDirectory(path);
        } else {
            PathPropertyReplacement.checkAbsolute(path);
        }
        if (this.secure) {
            PathPropertyReplacement.checkProbableProperties(filePath);
        }
        this.getScalar(OUTPUT_ABSOLUTE_PATH).setTo(path.toString());
        Path parent = path.getParent();
        if (parent != null) {
            this.getScalar(OUTPUT_PARENT_FOLDER).setTo(parent.toString());
        }
        if ((fileName = path.getFileName()) != null) {
            this.getScalar(OUTPUT_FILE_NAME).setTo(fileName.toString());
        }
        try {
            this.operation.checkOrCreate(path);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    private String filePath() {
        String inputPath = this.getInputScalar(DEFAULT_INPUT_PORT, true).getValue();
        String result = inputPath != null ? inputPath : this.path;
        return CreatePath.nonEmpty(result.trim(), "path");
    }
}

