/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.numbers.misc;

import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.algart.executors.api.Executor;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.Data;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.core.common.numbers.IndexingBase;
import net.algart.executors.modules.core.numbers.misc.InvertTable;

public final class TableTranslateNumbers
extends Executor
implements ReadOnlyExecutionInput {
    public static final String INPUT_INDEXES = "indexes";
    public static final String INPUT_TABLE_1 = "table";
    public static final String INPUT_TABLE_2 = "table_2";
    public static final String INPUT_TABLE_3 = "table_3";
    public static final String INPUT_TABLE_4 = "table_4";
    public static final String OUTPUT_VALUES_1 = "values";
    public static final String OUTPUT_VALUES_2 = "values_2";
    public static final String OUTPUT_VALUES_3 = "values_3";
    public static final String OUTPUT_VALUES_4 = "values_4";
    public static final String OUTPUT_N = "n";
    public static final String OUTPUT_CHANGED = "changed";
    private IndexingBase indexingBase = IndexingBase.ONE_BASED;
    private Double replacementForNotExisting = null;
    private boolean invertIndexes = false;
    private boolean tableRequired = false;

    public TableTranslateNumbers() {
        this.useVisibleResultParameter();
        this.setDefaultInputNumbers(INPUT_INDEXES);
        this.addInputNumbers(INPUT_TABLE_1);
        this.addInputNumbers(INPUT_TABLE_2);
        this.addInputNumbers(INPUT_TABLE_3);
        this.addInputNumbers(INPUT_TABLE_4);
        this.setDefaultOutputNumbers(OUTPUT_VALUES_1);
        this.addOutputNumbers(OUTPUT_VALUES_2);
        this.addOutputNumbers(OUTPUT_VALUES_3);
        this.addOutputNumbers(OUTPUT_VALUES_4);
        this.addOutputScalar(OUTPUT_N);
        this.addOutputScalar(OUTPUT_CHANGED);
    }

    public IndexingBase getIndexingBase() {
        return this.indexingBase;
    }

    public TableTranslateNumbers setIndexingBase(IndexingBase indexingBase) {
        this.indexingBase = TableTranslateNumbers.nonNull(indexingBase);
        return this;
    }

    public Double getReplacementForNotExisting() {
        return this.replacementForNotExisting;
    }

    public TableTranslateNumbers setReplacementForNotExisting(Double replacementForNotExisting) {
        this.replacementForNotExisting = replacementForNotExisting;
        return this;
    }

    public boolean isInvertIndexes() {
        return this.invertIndexes;
    }

    public TableTranslateNumbers setInvertIndexes(boolean invertIndexes) {
        this.invertIndexes = invertIndexes;
        return this;
    }

    public boolean isTableRequired() {
        return this.tableRequired;
    }

    public TableTranslateNumbers setTableRequired(boolean tableRequired) {
        this.tableRequired = tableRequired;
        return this;
    }

    @Override
    public void process() {
        SNumbers source = this.getInputNumbers();
        SNumbers[] result = this.process(source, new SNumbers[]{this.getInputNumbers(INPUT_TABLE_1, !this.tableRequired), this.getInputNumbers(INPUT_TABLE_2, true), this.getInputNumbers(INPUT_TABLE_3, true), this.getInputNumbers(INPUT_TABLE_4, true)});
        this.getNumbers(OUTPUT_VALUES_1).exchange(result[0]);
        this.getNumbers(OUTPUT_VALUES_2).exchange(result[1]);
        this.getNumbers(OUTPUT_VALUES_3).exchange(result[2]);
        this.getNumbers(OUTPUT_VALUES_4).exchange(result[3]);
    }

    public SNumbers[] process(SNumbers indexes, SNumbers[] translationTables) {
        Objects.requireNonNull(indexes, "Null indexes");
        Objects.requireNonNull(translationTables, "Null translationTables array");
        if (this.tableRequired) {
            Objects.requireNonNull(translationTables[0], "Null 1st translation table");
        }
        long t1 = TableTranslateNumbers.debugTime();
        int indexesBlockLength = indexes.getBlockLength();
        int[] indexArray = indexes.toIntArrayOrReference();
        int resultN = indexes.n();
        long t2 = TableTranslateNumbers.debugTime();
        if (this.invertIndexes) {
            if (indexesBlockLength != 1) {
                throw new IllegalArgumentException("\"Invert indexes\" mode requires 1-column indexes array");
            }
            indexArray = InvertTable.invert(indexArray, this.indexingBase.start);
            resultN = indexArray.length;
            indexes = null;
        }
        this.getScalar(OUTPUT_N).setTo(resultN);
        long t3 = TableTranslateNumbers.debugTime();
        SNumbers[] results = new SNumbers[translationTables.length];
        boolean changed = false;
        for (int tableIndex = 0; tableIndex < translationTables.length; ++tableIndex) {
            SNumbers result;
            SNumbers translationTable = translationTables[tableIndex];
            if (translationTable == null || !translationTable.isInitialized()) {
                results[tableIndex] = tableIndex == 0 && !this.tableRequired ? SNumbers.ofArray(indexArray, indexesBlockLength) : new SNumbers();
                continue;
            }
            long resultBlockLength = (long)translationTable.getBlockLength() * (long)indexesBlockLength;
            SNumbers.checkDimensions(resultN, resultBlockLength);
            if (translationTable.getBlockLength() == 1 && translationTable.isIntArray()) {
                int[] translated = this.translateIntNumbers(indexArray, translationTable);
                result = SNumbers.arrayAsNumbers(translated, indexesBlockLength);
                if (this.isOutputNecessary(OUTPUT_CHANGED) && !changed) {
                    changed = !Arrays.equals(indexArray, translated);
                }
            } else {
                result = SNumbers.zeros(translationTable.elementType(), resultN, (int)resultBlockLength);
                this.translateNumbers(result, indexArray, translationTable);
                if (this.isOutputNecessary(OUTPUT_CHANGED)) {
                    this.getScalar(OUTPUT_CHANGED).setTo(!result.equals(indexes));
                }
            }
            results[tableIndex] = result;
        }
        if (this.isOutputNecessary(OUTPUT_CHANGED)) {
            this.getScalar(OUTPUT_CHANGED).setTo(changed);
        }
        long t4 = TableTranslateNumbers.debugTime();
        if (LOGGABLE_DEBUG) {
            TableTranslateNumbers.logDebug(String.format(Locale.US, "Translating numbers by table(s) %s: %.3f ms = %.3f ms reading indexes + %.3f ms inversion + %.3f ms translation", Stream.of(results).filter(Data::isInitialized).collect(Collectors.toList()), (double)(t4 - t1) * 1.0E-6, (double)(t2 - t1) * 1.0E-6, (double)(t3 - t2) * 1.0E-6, (double)(t4 - t3) * 1.0E-6));
        }
        return results;
    }

    @Override
    public String translateLegacyParameterAlias(String name) {
        return name.equals("requireTable") ? "tableRequired" : name;
    }

    private void translateNumbers(SNumbers result, int[] indexes, SNumbers translationTable) {
        IntStream.range(0, indexes.length + 255 >>> 8).parallel().forEach(block -> {
            int start = this.indexingBase.start;
            int step = translationTable.getBlockLength();
            if (step == 1) {
                TableTranslateNumbers.translateRangeStep1(result, indexes, translationTable, block, start, this.replacementForNotExisting);
            } else {
                TableTranslateNumbers.translateRange(result, indexes, translationTable, block, step, start, this.replacementForNotExisting);
            }
        });
    }

    private int[] translateIntNumbers(int[] indexes, SNumbers translationTable) {
        int[] table = (int[])translationTable.arrayReference();
        int[] result = new int[indexes.length];
        IntStream.range(0, indexes.length + 255 >>> 8).parallel().forEach(block -> {
            int start = this.indexingBase.start;
            TableTranslateNumbers.translateIntRangeStep1(result, indexes, table, block, start, this.replacementForNotExisting);
        });
        return result;
    }

    private static void translateRange(SNumbers result, int[] indexes, SNumbers translationTable, int block, int step, int start, Double replacementForNotExisting) {
        int n = indexes.length;
        int tableN = translationTable.n();
        int blockLength = translationTable.blockLength();
        int i = block << 8;
        int disp = i * step;
        int to = (int)Math.min((long)i + 256L, (long)n);
        while (i < to) {
            int originalValue = indexes[i];
            int index = originalValue - start;
            if (index >= 0 && index < tableN) {
                int j = 0;
                int tableDisp = index * blockLength;
                while (j < step) {
                    result.setValue(disp + j, translationTable.getValue(tableDisp));
                    ++j;
                    ++tableDisp;
                }
            } else {
                double replacement = replacementForNotExisting != null ? replacementForNotExisting : (double)originalValue;
                for (int j = 0; j < step; ++j) {
                    result.setValue(disp + j, replacement);
                }
            }
            ++i;
            disp += step;
        }
    }

    private static void translateRangeStep1(SNumbers result, int[] indexes, SNumbers translationTable, int block, int start, Double replacementForNotExisting) {
        int i;
        assert (translationTable.blockLength() == 1);
        int n = indexes.length;
        int tableN = translationTable.n();
        int to = (int)Math.min((long)i + 256L, (long)n);
        for (i = block << 8; i < to; ++i) {
            int originalValue = indexes[i];
            int index = originalValue - start;
            if (index >= 0 && index < tableN) {
                result.setValue(i, translationTable.getValue(index));
                continue;
            }
            result.setValue(i, replacementForNotExisting != null ? replacementForNotExisting : (double)originalValue);
        }
    }

    private static void translateIntRangeStep1(int[] result, int[] indexes, int[] table, int block, int start, Double replacementForNotExisting) {
        int i;
        boolean useReplacement = replacementForNotExisting != null;
        int replacement = useReplacement ? (int)replacementForNotExisting.doubleValue() : 157;
        int tableN = table.length;
        int to = (int)Math.min((long)i + 256L, (long)indexes.length);
        for (i = block << 8; i < to; ++i) {
            int originalValue = indexes[i];
            int index = originalValue - start;
            result[i] = index >= 0 && index < tableN ? table[index] : (useReplacement ? replacement : originalValue);
        }
    }
}

