/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.numbers.creation;

import net.algart.executors.api.Executor;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.api.data.SScalar;

public final class CreateNumbersFromString
extends Executor
implements ReadOnlyExecutionInput {
    private int blockLength = 1;
    private boolean singleBlock = true;
    private Class<?> elementType = Float.TYPE;
    private String value = "";

    public CreateNumbersFromString() {
        this.addInputNumbers(DEFAULT_INPUT_PORT);
        this.addOutputNumbers(DEFAULT_OUTPUT_PORT);
    }

    public int getBlockLength() {
        return this.blockLength;
    }

    public CreateNumbersFromString setBlockLength(int blockLength) {
        this.blockLength = CreateNumbersFromString.positive(blockLength);
        return this;
    }

    public boolean isSingleBlock() {
        return this.singleBlock;
    }

    public CreateNumbersFromString setSingleBlock(boolean singleBlock) {
        this.singleBlock = singleBlock;
        return this;
    }

    public Class<?> getElementType() {
        return this.elementType;
    }

    public CreateNumbersFromString setElementType(Class<?> elementType) {
        this.elementType = CreateNumbersFromString.nonNull(elementType, "element type");
        return this;
    }

    public CreateNumbersFromString setElementType(String elementType) {
        return this.setElementType(SNumbers.elementType(elementType));
    }

    public String getValue() {
        return this.value;
    }

    public CreateNumbersFromString setValue(String value) {
        this.value = CreateNumbersFromString.nonNull(value);
        return this;
    }

    @Override
    public void process() {
        SNumbers input = this.getInputNumbers(this.defaultInputPortName(), true);
        if (input.isInitialized()) {
            CreateNumbersFromString.logDebug(() -> "Copying number array: " + String.valueOf(input));
            this.getNumbers().setTo(input);
            return;
        }
        if (this.elementType == Long.TYPE) {
            long[] longs;
            try {
                longs = new SScalar(this.value).toLongs();
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Illegal numbers in string \"" + this.value + "\": for \"long\" element type you must use correct integer values (in particular. automatic type cast is not supported)", e);
            }
            this.getNumbers().setTo(longs, this.singleBlock ? longs.length : this.blockLength);
        } else {
            double[] doubles;
            try {
                doubles = new SScalar(this.value).toDoubles();
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Illegal numbers in string \"" + this.value + "\"", e);
            }
            this.getNumbers().setToArray(doubles, this.singleBlock ? doubles.length : this.blockLength).setPrecision(this.elementType);
        }
    }
}

