/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.numbers.conversions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.core.common.numbers.SeveralNumbersOperation;
import net.algart.executors.modules.core.numbers.conversions.MergeNumbers;

public final class MergeNumbersColumns
extends SeveralNumbersOperation
implements ReadOnlyExecutionInput {
    public static final String NUMBER_OF_EMPTY_COLUMNS_FOR_NON_INITIALIZED_PREFIX = "numberOfEmptyColumns";
    private boolean inputRequired = true;
    private MergeNumbers.ResultElementType resultElementType = MergeNumbers.ResultElementType.FIRST_INPUT;
    private final Map<Integer, Integer> numberOfEmptyColumnsForNonInitialized = new HashMap<Integer, Integer>();

    public MergeNumbersColumns() {
        super(new String[0]);
    }

    public boolean isInputRequired() {
        return this.inputRequired;
    }

    public MergeNumbersColumns setInputRequired(boolean inputRequired) {
        this.inputRequired = inputRequired;
        return this;
    }

    public MergeNumbers.ResultElementType getResultElementType() {
        return this.resultElementType;
    }

    public MergeNumbersColumns setResultElementType(MergeNumbers.ResultElementType resultElementType) {
        this.resultElementType = MergeNumbersColumns.nonNull(resultElementType);
        return this;
    }

    public int getNumberOfEmptyColumnsForNonInitialized(int index) {
        return this.numberOfEmptyColumnsForNonInitialized.getOrDefault(index, 0);
    }

    public MergeNumbersColumns setNumberOfEmptyColumnsForNonInitialized(int index, int numberOfEmptyColumnsForNonInitialized) {
        this.numberOfEmptyColumnsForNonInitialized.put(index, numberOfEmptyColumnsForNonInitialized);
        return this;
    }

    @Override
    public void onChangeParameter(String name) {
        if (name.startsWith(NUMBER_OF_EMPTY_COLUMNS_FOR_NON_INITIALIZED_PREFIX)) {
            int index;
            try {
                index = Integer.parseInt(name.substring(NUMBER_OF_EMPTY_COLUMNS_FOR_NON_INITIALIZED_PREFIX.length())) - 1;
            }
            catch (NumberFormatException ignored) {
                return;
            }
            int value = this.parameters().getInteger(name);
            this.setNumberOfEmptyColumnsForNonInitialized(index, MergeNumbersColumns.nonNegative(value, "number of empty columns"));
            return;
        }
        super.onChangeParameter(name);
    }

    @Override
    public SNumbers processNumbers(List<SNumbers> sources) {
        if (sources.stream().noneMatch(Objects::nonNull)) {
            if (this.inputRequired) {
                throw new IllegalArgumentException("There are no initialized input arrays");
            }
            return new SNumbers();
        }
        Class<?> resultElementType = MergeNumbers.findElementType(sources, this.resultElementType);
        assert (resultElementType != null) : "must not be null if there are non-null sources: " + String.valueOf(sources);
        int n = sources.stream().filter(Objects::nonNull).findFirst().map(SNumbers::n).orElse(0);
        ArrayList<SNumbers> actualSources = new ArrayList<SNumbers>();
        long resultBlockLength = 0L;
        int size = sources.size();
        for (int i = 0; i < size; ++i) {
            SNumbers source = sources.get(i);
            if (source != null) {
                actualSources.add(source);
                resultBlockLength += (long)source.getBlockLength();
                continue;
            }
            int blockLength = this.numberOfEmptyColumnsForNonInitialized.getOrDefault(i, 0);
            if (blockLength <= 0) continue;
            actualSources.add(SNumbers.zeros(resultElementType, n, blockLength).fillValue(Double.NaN));
            resultBlockLength += (long)blockLength;
        }
        if (resultBlockLength > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Too large total number of channels: " + resultBlockLength + " >=2^31");
        }
        SNumbers result = SNumbers.zeros(resultElementType, n, (int)resultBlockLength);
        int blockDisp = 0;
        for (SNumbers source : actualSources) {
            assert (source != null);
            if (source.elementType() != resultElementType) {
                source = source.toPrecision(resultElementType);
            }
            int blockLength = source.getBlockLength();
            result.replaceColumnRange(blockDisp, source, 0, blockLength);
            blockDisp += blockLength;
        }
        return result;
    }

    @Override
    public String translateLegacyParameterAlias(String name) {
        return name.equals("requireInput") ? "inputRequired" : name;
    }

    @Override
    protected boolean allowAllUninitializedInputs() {
        return !this.inputRequired;
    }

    @Override
    protected boolean numberOfBlocksEqualityRequired() {
        return true;
    }

    @Override
    protected boolean blockLengthEqualityRequired() {
        return false;
    }
}

