/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.numbers.arithmetic;

import net.algart.arrays.Arrays;
import net.algart.arrays.FloatArray;
import net.algart.arrays.PArray;
import net.algart.arrays.UpdatablePNumberArray;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SScalar;
import net.algart.executors.modules.core.common.numbers.NumberArrayFilter;
import net.algart.math.functions.AbstractFunc;
import net.algart.math.functions.Func;

public final class NumbersInSeveralRanges
extends NumberArrayFilter
implements ReadOnlyExecutionInput {
    private double[] thresholds = new double[0];
    private double[] values = new double[]{1.0};

    public double[] getThresholds() {
        return (double[])this.thresholds.clone();
    }

    public NumbersInSeveralRanges setThresholds(double[] thresholds) {
        this.thresholds = (double[])NumbersInSeveralRanges.nonNull(thresholds).clone();
        return this;
    }

    public NumbersInSeveralRanges setThresholds(String thresholds) {
        this.thresholds = new SScalar(NumbersInSeveralRanges.nonNull(thresholds)).toDoubles();
        return this;
    }

    public double[] getValues() {
        return (double[])this.values.clone();
    }

    public NumbersInSeveralRanges setValues(double[] values) {
        NumbersInSeveralRanges.nonNull(values);
        if (values.length == 0) {
            throw new IllegalArgumentException("At least 1 value must be specifed");
        }
        this.values = (double[])values.clone();
        return this;
    }

    public NumbersInSeveralRanges setValues(String values) {
        return this.setValues(new SScalar(NumbersInSeveralRanges.nonNull(values)).toDoubles());
    }

    @Override
    public PArray process(UpdatablePNumberArray array, int blockLength, int numberOfBlocks) {
        final int length = Math.min(this.values.length - 1, this.thresholds.length);
        return Arrays.asFuncArray((Func)new AbstractFunc(){

            public double get(double ... x) {
                return this.get(x[0]);
            }

            public double get(double x0) {
                double result = NumbersInSeveralRanges.this.values[0];
                for (int k = 0; k < length; ++k) {
                    if (!(x0 >= NumbersInSeveralRanges.this.thresholds[k])) continue;
                    result = NumbersInSeveralRanges.this.values[k + 1];
                }
                return result;
            }
        }, FloatArray.class, (PArray[])new PArray[]{array});
    }
}

