/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.matrices.io;

import java.io.IOError;
import java.io.IOException;
import java.nio.file.Path;
import net.algart.executors.api.ExecutionVisibleResultsInformation;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.Port;
import net.algart.executors.modules.core.common.io.WriteFileOperation;
import net.algart.io.MatrixIO;
import net.algart.multimatrix.MultiMatrix;

public final class WriteAlgARTImage
extends WriteFileOperation
implements ReadOnlyExecutionInput {
    private boolean inputRequired = false;

    public WriteAlgARTImage() {
        this.addFileOperationPorts();
        this.addInputMat(DEFAULT_INPUT_PORT);
    }

    @Override
    public WriteAlgARTImage setFile(String file) {
        super.setFile(file);
        return this;
    }

    public boolean isInputRequired() {
        return this.inputRequired;
    }

    public WriteAlgARTImage setInputRequired(boolean inputRequired) {
        this.inputRequired = inputRequired;
        return this;
    }

    @Override
    public void process() {
        MultiMatrix m = this.getInputMat(!this.inputRequired).toMultiMatrix();
        if (m != null) {
            this.writeMat(m);
        }
    }

    public void writeMat(MultiMatrix m) {
        Path file = this.completeFilePath().toAbsolutePath();
        WriteAlgARTImage.logDebug(() -> "Writing AlgART " + String.valueOf(m) + " to file " + String.valueOf(file));
        try {
            MatrixIO.writeImageFolder((Path)file, m.allChannels());
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public ExecutionVisibleResultsInformation visibleResultsInformation() {
        return this.defaultVisibleResultsInformation(Port.Type.INPUT, DEFAULT_INPUT_PORT);
    }

    @Override
    public String translateLegacyParameterAlias(String name) {
        return name.equals("requireInput") ? "inputRequired" : name;
    }
}

