/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.matrices.conversions;

import java.util.ArrayList;
import java.util.List;
import net.algart.arrays.ByteArray;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.executors.api.data.SMat;
import net.algart.executors.modules.core.matrices.conversions.ColorSpaceConversion;
import net.algart.executors.modules.core.matrices.conversions.SplitColorChannels;
import net.algart.multimatrix.MultiMatrix;

public final class MergeColorChannels
extends ColorSpaceConversion {
    public static final long DEFAULT_DIM_X_WHEN_NO_SOURCE = 512L;
    public static final long DEFAULT_DIM_Y_WHEN_NO_SOURCE = 512L;
    private final double[] defaultFillerForChannels = new double[]{1.0, 1.0, 1.0, 1.0};
    private boolean force4Channels = false;

    public MergeColorChannels() {
        this.addOutputMat(DEFAULT_OUTPUT_PORT);
        for (String port : SplitColorChannels.CHANNEL_PORTS) {
            this.addInputMat(port);
        }
    }

    public double getDefaultFillerForChannel1() {
        return this.defaultFillerForChannels[0];
    }

    public void setDefaultFillerForChannel1(double defaultFillerForChannel1) {
        this.defaultFillerForChannels[0] = defaultFillerForChannel1;
    }

    public double getDefaultFillerForChannel2() {
        return this.defaultFillerForChannels[1];
    }

    public void setDefaultFillerForChannel2(double defaultFillerForChannel2) {
        this.defaultFillerForChannels[1] = defaultFillerForChannel2;
    }

    public double getDefaultFillerForChannel3() {
        return this.defaultFillerForChannels[2];
    }

    public void setDefaultFillerForChannel3(double defaultFillerForChannel3) {
        this.defaultFillerForChannels[2] = defaultFillerForChannel3;
    }

    public double getDefaultFillerForChannel4() {
        return this.defaultFillerForChannels[3];
    }

    public void setDefaultFillerForChannel4(double defaultFillerForChannel4) {
        this.defaultFillerForChannels[3] = defaultFillerForChannel4;
    }

    public boolean isForce4Channels() {
        return this.force4Channels;
    }

    public MergeColorChannels setForce4Channels(boolean force4Channels) {
        this.force4Channels = force4Channels;
        return this;
    }

    @Override
    public void process() {
        double scale;
        ArrayList<Matrix<? extends PArray>> channels = new ArrayList<Matrix<? extends PArray>>();
        ArrayList<Matrix<? extends PArray>> initialized = new ArrayList<Matrix<? extends PArray>>();
        for (String port : SplitColorChannels.CHANNEL_PORTS) {
            int channelIndex = channels.size();
            SMat channel = this.getInputMat(port, true);
            if (channel.isInitialized()) {
                Matrix<? extends PArray> m = channel.toMultiMatrix2D().intensityChannel();
                MergeColorChannels.logDebug(() -> "Merging channel #" + (channelIndex + 1) + " -> color matrix " + m.dimX() + "x" + m.dimY());
                channels.add(m);
                initialized.add(m);
                continue;
            }
            if (channelIndex == 3 && !this.force4Channels) break;
            MergeColorChannels.logDebug(() -> "Merged channel #" + (channelIndex + 1) + " is empty: it will be filled by default value " + this.defaultFillerForChannels[channelIndex]);
            channels.add(null);
        }
        Matrices.checkDimensionEquality(initialized);
        Matrix some = initialized.isEmpty() ? null : (Matrix)initialized.get(0);
        long dimX = some == null ? 512L : some.dimX();
        long dimY = some == null ? 512L : some.dimY();
        Class type = some == null ? ByteArray.class : some.type(PArray.class);
        double d = scale = some == null ? 255.0 : ((PArray)some.array()).maxPossibleValue(1.0);
        if (some == null) {
            MergeColorChannels.logDebug(() -> "All merged channels are empty; creating constant byte matrix " + dimX + "x" + dimY);
        }
        for (int k = 0; k < channels.size(); ++k) {
            if (channels.get(k) != null) continue;
            double value = scale * this.defaultFillerForChannels[k];
            channels.set(k, (Matrix<? extends PArray>)Matrices.constantMatrix((double)value, (Class)type, (long[])new long[]{dimX, dimY}));
        }
        List<Matrix<? extends PArray>> rgba = this.getChannelsColorSpace().merge(channels);
        this.getMat().setTo(MultiMatrix.of2DRGBA(rgba).clone());
    }
}

