/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.matrices.conversions;

import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import net.algart.arrays.Array;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.UpdatableArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.executors.modules.core.common.matrices.SeveralMultiMatricesChannelOperation;
import net.algart.math.functions.Func;
import net.algart.math.functions.LinearFunc;

public final class InterpolateLayersWithIncreasingNumberOfDimensions
extends SeveralMultiMatricesChannelOperation {
    public static final String INPUT_FRONT = "front";
    public static final String INPUT_REAR = "rear";
    private long newDimension = 2L;

    public InterpolateLayersWithIncreasingNumberOfDimensions() {
        super(INPUT_FRONT, INPUT_REAR);
    }

    public long getNewDimension() {
        return this.newDimension;
    }

    public InterpolateLayersWithIncreasingNumberOfDimensions setNewDimension(long newDimension) {
        this.newDimension = InterpolateLayersWithIncreasingNumberOfDimensions.positive(newDimension);
        return this;
    }

    @Override
    protected Matrix<? extends PArray> processChannel(List<Matrix<? extends PArray>> m) {
        Matrix<? extends PArray> front = m.get(0);
        Matrix<? extends PArray> rear = m.get(1);
        assert (rear == null || front.elementType() == rear.elementType()) : "Superclass didn't correct precision";
        int newDimCount = front.dimCount() + 1;
        long[] newDimensions = Arrays.copyOf(front.dimensions(), newDimCount);
        newDimensions[newDimCount - 1] = this.newDimension;
        Matrix result = net.algart.arrays.Arrays.SMM.newMatrix(UpdatablePArray.class, front.elementType(), newDimensions);
        assert (this.newDimension == (long)((int)this.newDimension));
        long step = front.size();
        IntStream.range(0, (int)this.newDimension).parallel().forEach(coord -> {
            long p = (long)coord * step;
            UpdatablePArray resultArray = ((UpdatablePArray)result.array()).subArr(p, step);
            if (coord == 0 || rear == null) {
                net.algart.arrays.Arrays.copy(null, (UpdatableArray)resultArray, (Array)front.array());
            } else if ((long)coord == this.newDimension - 1L) {
                net.algart.arrays.Arrays.copy(null, (UpdatableArray)resultArray, (Array)rear.array());
            } else {
                assert (this.newDimension > 1L);
                double alpha = (double)coord / (double)(this.newDimension - 1L);
                net.algart.arrays.Arrays.applyFunc((ArrayContext)ArrayContext.DEFAULT_SINGLE_THREAD, (Func)LinearFunc.getInstance((double)0.0, (double[])new double[]{1.0 - alpha, alpha}), (UpdatablePArray)resultArray, (PArray[])new PArray[]{(PArray)front.array(), (PArray)rear.array()});
            }
        });
        return result;
    }

    @Override
    protected boolean allowUninitializedInput(int inputIndex) {
        return inputIndex >= 1;
    }
}

