/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.matrices.arithmetic;

import java.util.List;
import net.algart.arrays.DoubleArray;
import net.algart.arrays.FloatArray;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.executors.modules.core.common.matrices.SeveralMultiMatricesOperation;
import net.algart.executors.modules.core.matrices.arithmetic.MatrixDifference;
import net.algart.math.functions.DividingFunc;
import net.algart.math.functions.Func;
import net.algart.multimatrix.MultiMatrix;

public final class MatrixDifferenceFromPair
extends SeveralMultiMatricesOperation {
    public static final String INPUT_X = "x";
    public static final String INPUT_A = "a";
    public static final String INPUT_B = "b";
    private static final Func DIVIDING_FUNC = DividingFunc.getInstance((double)1.0);
    private Operation operation = Operation.RGB_DISTANCE_SQUARE_DIVIDED_BY_SUM;

    public MatrixDifferenceFromPair() {
        super(INPUT_X, INPUT_A, INPUT_B);
    }

    public Operation getOperation() {
        return this.operation;
    }

    public void setOperation(Operation operation) {
        this.operation = MatrixDifferenceFromPair.nonNull(operation);
    }

    @Override
    public MultiMatrix process(List<MultiMatrix> sources) {
        MultiMatrix x = sources.get(0);
        MultiMatrix a = sources.get(1);
        MultiMatrix b = sources.get(2);
        MatrixDifferenceFromPair.logDebug(() -> "Difference from pair: " + String.valueOf((Object)this.operation) + " for matrices " + String.valueOf(x) + "; " + String.valueOf(a) + "; " + String.valueOf(b));
        return MultiMatrix.of2DMono(this.operation.calculate(x, a, b));
    }

    public static enum Operation {
        RGB_DISTANCE_RELATION{

            @Override
            Matrix<? extends PArray> calculate(MultiMatrix x, MultiMatrix a, MultiMatrix b) {
                Matrix<? extends PArray> distanceToA = MatrixDifference.sumOfChannelsSquares(x.asFunc(Func.ABS_DIFF, a), true);
                Matrix<? extends PArray> distanceToB = MatrixDifference.sumOfChannelsSquares(x.asFunc(Func.ABS_DIFF, b), true);
                return Matrices.clone((Matrix)Matrices.asFuncMatrix((Func)DIVIDING_FUNC, FloatArray.class, distanceToA, distanceToB));
            }
        }
        ,
        RGB_DISTANCE_SQUARE_DIVIDED_BY_SUM{

            @Override
            Matrix<? extends PArray> calculate(MultiMatrix x, MultiMatrix a, MultiMatrix b) {
                Matrix<? extends PArray> distanceSquareToA = MatrixDifference.sumOfChannelsSquares(x.asFunc(Func.ABS_DIFF, a), false);
                Matrix<? extends PArray> distanceSquareToB = MatrixDifference.sumOfChannelsSquares(x.asFunc(Func.ABS_DIFF, b), false);
                return Matrices.clone((Matrix)Matrices.asFuncMatrix((Func)DIVIDING_FUNC, FloatArray.class, distanceSquareToA, (Matrix)Matrices.asFuncMatrix((Func)Func.X_PLUS_Y, DoubleArray.class, distanceSquareToA, distanceSquareToB)));
            }
        }
        ,
        RGB_DISTANCE_DIVIDED_BY_SUM{

            @Override
            Matrix<? extends PArray> calculate(MultiMatrix x, MultiMatrix a, MultiMatrix b) {
                Matrix<? extends PArray> distanceToA = MatrixDifference.sumOfChannelsSquares(x.asFunc(Func.ABS_DIFF, a), true);
                Matrix<? extends PArray> distanceToB = MatrixDifference.sumOfChannelsSquares(x.asFunc(Func.ABS_DIFF, b), true);
                return Matrices.clone((Matrix)Matrices.asFuncMatrix((Func)DIVIDING_FUNC, FloatArray.class, distanceToA, (Matrix)Matrices.asFuncMatrix((Func)Func.X_PLUS_Y, DoubleArray.class, distanceToA, distanceToB)));
            }
        };


        abstract Matrix<? extends PArray> calculate(MultiMatrix var1, MultiMatrix var2, MultiMatrix var3);
    }
}

