/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.common.matrices;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.algart.arrays.SizeMismatchException;
import net.algart.executors.api.Executor;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SMat;
import net.algart.multimatrix.MultiMatrix;

abstract class SeveralMultiMatricesProcessing
extends Executor
implements ReadOnlyExecutionInput {
    public static final String INPUT_PORT_PREFIX = "input_";
    private final String[] predefinedInputPortNames;
    private List<MultiMatrix> sourceMultiMatrices = null;

    protected SeveralMultiMatricesProcessing(String[] predefinedInputPortNames) {
        Objects.requireNonNull(predefinedInputPortNames, "Null predefinedInputPortNames");
        this.predefinedInputPortNames = (String[])predefinedInputPortNames.clone();
        for (String port : predefinedInputPortNames) {
            this.addInputMat(port);
        }
    }

    protected final List<MultiMatrix> sourceMultiMatrices() {
        return this.sourceMultiMatrices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() {
        Integer requiredNumberOfInputs = this.requiredNumberOfInputs();
        this.sourceMultiMatrices = new ArrayList<MultiMatrix>();
        try {
            for (int k = 0; requiredNumberOfInputs == null || k < requiredNumberOfInputs; ++k) {
                String portName = this.inputPortName(k);
                if (requiredNumberOfInputs == null && !this.hasInputPort(portName)) break;
                SMat input = this.getInputMat(portName, this.allowUninitializedInput(k));
                this.sourceMultiMatrices.add(input.isInitialized() ? input.toMultiMatrix(this.allowInputNonAlgartDepth(k)) : null);
            }
            if (this.dimensionsEqualityRequired()) {
                SeveralMultiMatricesProcessing.checkDimensionOfNonNullEquality(this.sourceMultiMatrices);
            }
            boolean resultRequired = this.resultRequired();
            this.setStartProcessingTimeStamp();
            Object result = this.process(this.sourceMultiMatrices, resultRequired);
            this.setEndProcessingTimeStamp();
            if (result != null) {
                this.setNonNullResult(result);
            } else {
                if (resultRequired) {
                    throw new AssertionError((Object)"Invalid process implementation: it returned null, though resultRequired=true");
                }
                if (this.hasDefaultOutputPort()) {
                    this.getMat().remove();
                }
            }
        }
        finally {
            this.sourceMultiMatrices = null;
        }
    }

    protected Integer requiredNumberOfInputs() {
        return this.predefinedInputPortNames.length == 0 ? null : Integer.valueOf(this.predefinedInputPortNames.length);
    }

    protected boolean allowUninitializedInput(int inputIndex) {
        return inputIndex >= this.predefinedInputPortNames.length;
    }

    protected boolean allowInputNonAlgartDepth(int inputIndex) {
        return true;
    }

    protected String inputPortName(int inputIndex) {
        return inputIndex < this.predefinedInputPortNames.length ? this.predefinedInputPortNames[inputIndex] : INPUT_PORT_PREFIX + (inputIndex + 1);
    }

    protected boolean dimensionsEqualityRequired() {
        return true;
    }

    abstract Object process(List<MultiMatrix> var1, boolean var2);

    abstract boolean resultRequired();

    abstract void setNonNullResult(Object var1);

    private static void checkDimensionOfNonNullEquality(List<? extends MultiMatrix> matrices) {
        Objects.requireNonNull(matrices);
        MultiMatrix first = null;
        int firstIndex = -1;
        int index = -1;
        for (MultiMatrix multiMatrix : matrices) {
            ++index;
            if (multiMatrix == null) continue;
            if (first == null) {
                first = multiMatrix;
                firstIndex = index;
                continue;
            }
            if (multiMatrix.dimEquals(first)) continue;
            throw new SizeMismatchException("The multi-matrix #" + index + " and #" + firstIndex + " dimensions mismatch: #" + index + " is " + String.valueOf(multiMatrix) + ", #" + firstIndex + " is " + String.valueOf(first));
        }
    }
}

