/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.common.matrices;

import net.algart.executors.api.Executor;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SMat;
import net.algart.multimatrix.MultiMatrix2D;

public abstract class MultiMatrix2DFilter
extends Executor
implements ReadOnlyExecutionInput {
    private MultiMatrix2D sourceMultiMatrix = null;

    protected MultiMatrix2DFilter() {
        this.addInputMat(DEFAULT_INPUT_PORT);
        this.addOutputMat(DEFAULT_OUTPUT_PORT);
    }

    protected final MultiMatrix2D sourceMultiMatrix() {
        return this.sourceMultiMatrix;
    }

    @Override
    public void process() {
        if (this.resultRequired()) {
            this.process(this.getInputMat(this.allowUninitializedInput()), this.getMat());
        } else {
            SMat result = this.process(this.getInputMat(this.allowUninitializedInput()), null);
            if (result != null) {
                this.getMat().setTo(result);
            } else if (this.hasDefaultOutputPort()) {
                this.getMat().remove();
            }
        }
    }

    public final SMat process(SMat source) {
        return this.process(source, null);
    }

    public abstract MultiMatrix2D process(MultiMatrix2D var1);

    protected boolean allowUninitializedInput() {
        return false;
    }

    protected boolean allowInputNonAlgartDepth() {
        return true;
    }

    protected boolean resultRequired() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SMat process(SMat source, SMat result) {
        this.sourceMultiMatrix = source.toMultiMatrix2D(this.allowInputNonAlgartDepth());
        try {
            this.setStartProcessingTimeStamp();
            MultiMatrix2D resultMultiMatrix = this.process(this.sourceMultiMatrix);
            this.setEndProcessingTimeStamp();
            if (resultMultiMatrix == null) {
                if (this.resultRequired()) {
                    throw new AssertionError((Object)"Invalid process implementation: it returned null, though resultRequired=true");
                }
                SMat sMat = null;
                return sMat;
            }
            if (result == null) {
                result = new SMat();
            }
            result.setTo(resultMultiMatrix);
            SMat sMat = result;
            return sMat;
        }
        finally {
            this.sourceMultiMatrix = null;
        }
    }
}

